<?php

/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 */

defined('ABSPATH') || exit;

global $product;

/**
 * Hook: woocommerce_before_single_product.
 *
 * @hooked wc_print_notices - 10
 */
do_action('woocommerce_before_single_product');


if (post_password_required()) {
	echo get_the_password_form(); // WPCS: XSS ok.
	return;
}
$product = wc_get_product(get_the_id());
?>
<div class="container-fluid">
	<div id="product-<?php the_ID(); ?>" <?php wc_product_class('', $product); ?>>
		<div class="page_product">
			<div class="wo_breadcrumb">
				<?php woocommerce_breadcrumb(); ?>
			</div>
		</div>
		<section class="wo_product_sin">
			<div class="head_single">
				<div class="row">
					<div class="col-12 col-md-6">
						<div class="title_infom_sin">
							<?php echo the_title('<h1>', '</h1>'); ?>
						</div>
					</div>
					<div class="col-12 col-md-6">
						<div class="wo-product-category">
							<?php echo woocommerce_template_single_meta(); ?>
							<?php get_template_part('template-parts/single-product/meta', 'meta'); ?>
							<?php get_template_part('template-parts/single-product/rating', 'rating'); ?>
						</div>
					</div>
					<div class="col-12 flex">
						<div class="title-engl">
							<?php woocommerce_show_product_loop_sale_flash(); ?>
							<?php echo metaboxs_get_meta('metaboxs_metaboxs1'); ?>
						</div>
						<div class="line_engl"></div>
					</div>
				</div>
			</div>
			<div class="row">
				<aside class="col-12 col-lg-3 order-first order-lg-none pal_0 sidebar">
					<div class="images_sin">
						<?php do_action('woocommerce_before_single_product_summary'); ?>
					</div>
				</aside>
				<article class="col-12 col-lg-6 pal_0 content-fix">
					<div class="wo-tabs-info">
						<?php do_action('woocommerce_after_single_product_summary'); ?>
					</div>
				</article>
				<aside class="col-12 col-lg-3 order-first order-lg-last sidebar">
				<div class="pric-box">
									<div class="marketing_u wo-product__seller-info">
										<div class="wo-product-seller-row wo-product__seller-row--seller wo-product__seller-row">
											<?php
												if (!$product->is_in_stock()) {
													echo metaboxs_get_meta('metaboxs_metaboxs4');
												} else {
													if (function_exists('dokan')) { ?>
														<p id="price-shop_table_one">
															<i class="fal fa-store-alt"></i>
															<?php echo sold_by(); ?>
														</p>
													<?php } ?>
													<p id="price-shop_table_one">
														<i class="fal fa-shield-check"></i>
														<span>
															<?php
															if (original_product_get_meta('Warranty')) {
																echo 'گارانتی اصالت و سلامت فیزیکی کالا';
															} else {
																echo 'گارانتی سلامت فیزیکی کالا';
															}
															?>
														</span>
													</p>
													<?php
													if (metaboxs_get_meta('Delivery_Time')) : ?>
														<p id="price-shop_table_one">
															<i class="fal fa-hourglass-end"></i>
															<span>
																حداکثر تا <?php echo metaboxs_get_meta('Delivery_Time'); ?> روز تحویل داده می شود.
															</span>
														</p>
													<?php
													endif;
													if ($product->get_stock_quantity()) :
													?>
														<p id="price-shop_table_one">
															<i class="fal fa-warehouse-alt"></i>
															<span class="stock_form">
																<?php do_action('show_stock_woo_denver'); ?>
															</span>
														</p>
											<?php
													endif;
												}
												do_action('woocommerce_single_product_summary');
											 ?>
										</div>
									</div>
								</div>
				</aside>
			</div>

		</section>
	</div>
	<?php 
		$show__product_offer_single = ot_get_option('show__product_offer_single', true);
		if ($show__product_offer_single == 'on'):
		get_template_part('themeplat/single/product-offer', 'product_offer');
		endif;
		?>
	<div class="row">
		<div class="col-sm-12">

		</div>
	</div>
	<?php do_action('woocommerce_after_single_product'); ?>
</div>