<?php
add_action('init', 'custom_theme_options');
function custom_theme_options()
{

	// OptionTree is not loaded yet, or this is not an admin request.
	if (!function_exists('ot_settings_id') || !is_admin()) {
		return false;
	}

	// Get a copy of the saved settings array.
	$saved_settings = get_option(ot_settings_id(), array());

	// Custom settings array that will eventually be passes to the OptionTree Settings API Class.
	$custom_settings = array(
		'contextual_help' => array(
			'sidebar' => '',
		),
		'sections'        => array(
			array(
				'id'    => 'general',
				'title' => esc_html__('general', 'leora'),
			),
			array(
				'id'    => 'logo_barsa',
				'title' => esc_html__('logo', 'leora'),
			),
			array(
				'id'    => 'header',
				'title' => esc_html__('header', 'leora'),
			),
			array(
				'id'    => 'post_single',
				'title' => esc_html__('نوشته ها', 'leora'),
			),
			array(
				'id'    => 'footer_blog',
				'title' => esc_html__('فوتر', 'leora'),
			),
			array(
				'id'    => 'search',
				'title' => esc_html__('جستجو', 'leora'),
			),
			array(
				'id'    => 'read_more',
				'title' => esc_html__('پیشنهادات', 'leora'),
			),
			array(
				'id'    => 'product_single',
				'title' => esc_html__('محصول', 'leora'),
			),
			array(
				'id'    => 'back_to_top',
				'title' => esc_html__('بازگشت به بالا', 'leora'), 
			),
			array(
				'id'    => 'profile_user',
				'title' => esc_html__('profile user', 'leora'),
			),
			array( 
				'id'    => 'advertising',
				'title' => esc_html__('تبلیغات', 'leora'),
			),
			array(
				'id'    => 'social_network',
				'title' => esc_html__('شبکه اجتماعی', 'leora'),
			),
			array(
				'id'    => 'advanced',
				'title' => esc_html__('Advanced', 'leora'),
			),
		),
		'settings'        => array(
			array(
				'id'           => 'background_body_blog',
				'label'        => esc_html__('Blog background', 'leora'),
				'desc'         => esc_html__('', 'leora'),
				'std'          => '',
				'type'         => 'background',
				'section'      => 'general',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'select_classic',
				'label'        => 'انتخاب ویرایشگر ابزارک',
				'desc'         => 'انتخاب استایل و ویرایشگر ابزارک ها بصورت ، کلاسیک و گوتنبرگ',
				'std'          => '',
				'type'         => 'select',
				'section'      => 'general',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
				'choices'      => array(
					array(
						'value' => 'classic',
						'label' => 'کلاسیک',
						'src'   => '',
					),
					array(
						'value' => 'gutenberg',
						'label' => 'گوتنبرگ',
						'src'   => '',
					),
				),
			),
			array(
				'id'           => 'select_tp_dowm_widget_mobile',
				'label'        => 'انتخاب ابزارک موبایل',
				'desc'         => 'انتخاب ابزارک مخصوص موبایل برای نمایش در پایین و بالای نوشته و محتوا',
				'std'          => '',
				'type'         => 'select',
				'section'      => 'general',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
				'choices'      => array(
					array(
						'value' => 'top',
						'label' => 'بالا',
						'src'   => '',
					),
					array(
						'value' => 'down',
						'label' => 'پایین',
						'src'   => '',
					),
				),
			),
			array(
				'id'           => 'select_article',
				'label'        => 'انتخاب چیدمان آرشیو',
				'desc'         => 'انتخاب چیدمان آرشیو بصورت پیش فرض',
				'std'          => '',
				'type'         => 'select',
				'section'      => 'general',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
				'choices'      => array(
					array(
						'value' => 'article_1',
						'label' => 'چیدمان یک',
						'src'   => '',
					),
					array(
						'value' => 'article_2',
						'label' => 'چیدمان دو',
						'src'   => '',
					),
					array(
						'value' => 'article_3',
						'label' => 'چیدمان سه',
						'src'   => '',
					),
				),
			),
			array(
				'id'           => 'item_arcive_blog',
				'label'        => esc_html__('Number of blog archive items', 'leora'),
				'desc'         => esc_html__('Number of blog archive items', 'leora'),
				'std'          => '',
				'type'         => 'numeric-slider',
				'section'      => 'general',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'theme_border_radius',
				'label'        => esc_html__('گردی حاشیه', 'leora'),
				'desc'         => esc_html__('انتخاب گردی حاشیه در تمامی صفحات', 'leora'),
				'std'          => '',
				'type'         => 'numeric-slider',
				'section'      => 'general',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'theme_border_radius_button',
				'label'        => esc_html__('گردی دکمه ها', 'leora'),
				'desc'         => esc_html__('انتخاب گردی دکمه و فیلد ها در تمامی صفحات', 'leora'),
				'std'          => '',
				'type'         => 'numeric-slider',
				'section'      => 'general',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'logo_blog_barsa',
				'label'        => esc_html__('Blog logo', 'leora'),
				'desc'         => esc_html__('Select a blog logo (100 * 50)', 'leora'),
				'std'          => '',
				'type'         => 'upload',
				'section'      => 'logo_barsa',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'logo_blog_header_4',
				'label'        => esc_html__('لوگو سربرگ چهار', 'leora'),
				'desc'         => esc_html__('انتخاب لوگو سربرگ چهار (230*90)', 'leora'),
				'std'          => '',
				'type'         => 'upload',
				'section'      => 'logo_barsa',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'logo_blog_header_7',
				'label'        => esc_html__('لوگو سربرگ هفت', 'leora'),
				'desc'         => esc_html__('انتخاب لوگو سربرگ هفت (150*60)', 'leora'),
				'std'          => '',
				'type'         => 'upload',
				'section'      => 'logo_barsa',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'general_head',
				'label'        => esc_html__('عمومی', 'leora'),
				'desc'         => esc_html__('عمومی', 'leora'),
				'std'          => '',
				'type'         => 'tab',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'select_header',
				'label'        => 'انتخاب سربرگ',
				'desc'         => 'انتخاب سربرگ بصورت پیش فرض',
				'std'          => '',
				'type'         => 'select',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
				'choices'      => array(
					array(
						'value' => 'header_nav_1',
						'label' => 'سربرگ یک',
						'src'   => '',
					),
					array(
						'value' => 'header_nav_2',
						'label' => 'سربرگ دو',
						'src'   => '',
					),
					array(
						'value' => 'header_nav_3',
						'label' => 'سربرگ سه',
						'src'   => '',
					),
					array(
						'value' => 'header_nav_4',
						'label' => 'سربرگ چهار',
						'src'   => '',
					),
					array(
						'value' => 'header_nav_5',
						'label' => 'سربرگ پنج',
						'src'   => '',
					),
					array(
						'value' => 'header_nav_6',
						'label' => 'سربرگ شش',
						'src'   => '',
					),
					array(
						'value' => 'header_nav_7',
						'label' => 'سربرگ هفت',
						'src'   => '',
					),
					array(
						'value' => 'header_nav_8',
						'label' => 'سربرگ هشت',
						'src'   => '',
					),
					array(
						'value' => 'header_nav_9',
						'label' => 'سربرگ نه',
						'src'   => '',
					),
					array(
						'value' => 'header_nav_10',
						'label' => 'سربرگ ده',
						'src'   => '',
					),
					array(
						'value' => 'header_nav_11',
						'label' => 'سربرگ یازده',
						'src'   => '',
					),
				),
			),
			array(
				'id'           => 'select_header_shop',
				'label'        => 'انتخاب سربرگ فروشگاه',
				'desc'         => 'انتخاب سربرگ بصورت پیش فرض فروشگاه',
				'std'          => '',
				'type'         => 'select',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
				'choices'      => array(
					array(
						'value' => 'header_nav_1',
						'label' => 'سربرگ یک',
						'src'   => '',
					),
					array(
						'value' => 'header_nav_2',
						'label' => 'سربرگ دو',
						'src'   => '',
					),
					array(
						'value' => 'header_nav_3',
						'label' => 'سربرگ سه',
						'src'   => '',
					),
					array(
						'value' => 'header_nav_4',
						'label' => 'سربرگ چهار',
						'src'   => '',
					),
					array(
						'value' => 'header_nav_5',
						'label' => 'سربرگ پنج',
						'src'   => '',
					),
					array(
						'value' => 'header_nav_6',
						'label' => 'سربرگ شش',
						'src'   => '',
					),
					array(
						'value' => 'header_nav_7',
						'label' => 'سربرگ هفت',
						'src'   => '',
					),
					array(
						'value' => 'header_nav_8',
						'label' => 'سربرگ هشت',
						'src'   => '',
					),
					array(
						'value' => 'header_nav_9',
						'label' => 'سربرگ نه',
						'src'   => '',
					),
					array(
						'value' => 'header_nav_10',
						'label' => 'سربرگ ده',
						'src'   => '',
					),
					array(
						'value' => 'header_nav_11',
						'label' => 'سربرگ یازده',
						'src'   => '',
					),
				),
			),
			array(
				'id'           => 'profile_header',
				'label'        => esc_html__('Show login button', 'leora'),
				'desc'         => esc_html__('Show or hide the registration and login of the user in the header', 'leora'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'display_search_header',
				'label'        => esc_html__('Show search button', 'leora'),
				'desc'         => esc_html__('Show or hide the search box in the header', 'leora'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'display_share_header',
				'label'        => esc_html__('دکمه اشتراک', 'leora'),
				'desc'         => esc_html__('دکمه اشتراک را در سربرگ نشان داده یا پنهان کنید', 'leora'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'head_mobile',
				'label'        => esc_html__('موبایل', 'leora'),
				'desc'         => esc_html__('موبایل', 'leora'),
				'std'          => '',
				'type'         => 'tab',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'profile_header_mobile',
				'label'        => esc_html__('Show login button', 'leora'),
				'desc'         => esc_html__('Show or hide the registration and login of the user in the mobile', 'leora'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'back_color_item_header',
				'label'        => esc_html__('پس زمینه ورود و ثبت نام', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه ورود و ثبت  نام در موبایل', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_item_brs',
				'label'        => esc_html__('رنگ آیکون ورود', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ ورود و ثبت  نام در موبایل', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_menu_mobile_b',
				'label'        => esc_html__('رنگ آیکون منو موبایل', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ ایکون منو موبایل ', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'header_menu_mobile_text',
				'label'        => esc_html__('متن منو', 'leora'),
				'desc'         => esc_html__('انتخاب متن منو موبایل', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'header_menu_mobile',
				'label'        => esc_html__('پس زمینه منو', 'leora'),
				'desc'         => esc_html__('انتخاب پس زمینه منو موبایل', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'sub_menu_mobile',
				'label'        => esc_html__('پس زمینه زیر منو', 'leora'),
				'desc'         => esc_html__('انتخاب پس زمینه زیر منو موبایل', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'header_border_line_mobile',
				'label'        => esc_html__('خط وسط', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ خط وسط ', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'header_tab_mobile',
				'label'        => esc_html__('موبایل فروشگاه', 'leora'),
				'desc'         => esc_html__('موبایل فروشگاه', 'leora'),
				'std'          => '',
				'type'         => 'tab',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_shop_header_mobile',
				'label'        => esc_html__('رنگ پس زمینه سربرگ', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه سربرگ', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_text_icon_mobile',
				'label'        => esc_html__('رنگ آیکون ', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ آیکون سربرگ', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'border_color_search_mobile',
				'label'        => esc_html__('حاشیه جستجو', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ حاشیه جستجو', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'header_border_line_mobile_2',
				'label'        => esc_html__('خط وسط', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ خط وسط ', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'header_radius_mobile',
				'label'        => esc_html__('گردی', 'leora'),
				'desc'         => esc_html__('تنظیم گردی سربرگ موبایل', 'leora'),
				'std'          => '',
				'type'         => 'numeric-slider',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'head_one',
				'label'        => esc_html__('سربرگ 1 و 2', 'leora'),
				'desc'         => esc_html__('سربرگ 1 و 2', 'leora'),
				'std'          => '',
				'type'         => 'tab',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'show__menu_bar',
				'label'        => esc_html__('فعال کردن منوبار', 'leora'),
				'desc'         => esc_html__('فعال /غیر فعال کردن منو بار ', 'leora'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_background_blog',
				'label'        => esc_html__('Header background color', 'leora'),
				'desc'         => esc_html__('Blog header background color', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_menu_blog',
				'label'        => esc_html__('Menu text color', 'leora'),
				'desc'         => esc_html__('Menu text color', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_icon_header_blog',
				'label'        => esc_html__('Icon colors', 'leora'),
				'desc'         => esc_html__('Icon color in blog header', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'hover_background_text_menu',
				'label'        => esc_html__('Menu text background color hover', 'leora'),
				'desc'         => esc_html__('Menu text background color hover', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_shop_menubar',
				'label'        => esc_html__('رنگ پس زمینه منو بار', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه منو بار', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_shop_menubar_share',
				'label'        => esc_html__('رنگ آیکون شبکه اجتماعی', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ آیکون شبکه اجتماعی منو بار ', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_backgr_logo',
				'label'        => esc_html__('پس زمینه لوگو', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ پس زممینه لوگو سربرگ', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'head_two',
				'label'        => esc_html__('سربرگ 3', 'leora'),
				'desc'         => esc_html__('سربرگ 3', 'leora'),
				'std'          => '',
				'type'         => 'tab',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_shop_header_two',
				'label'        => esc_html__('رنگ پس زمینه سربرگ', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه سربرگ', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'headershop_text_color_two',
				'label'        => esc_html__('رنگ متن سربرگ', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ متن سربرگ', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_back_menu_hashtag',
				'label'        => esc_html__('رنگ پس زمینه منو', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه منو هشتگ در سربرگ', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_text_menu_hashtag',
				'label'        => esc_html__('رنگ متن منو', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ متن منو هشتگ در سربرگ', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_back_logo',
				'label'        => esc_html__('رنگ پس زمینه لوگو', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه لوگو در سربرگ', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color__icon__header',
				'label'        => esc_html__('رنگ آیکون ها', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ  آیکون ها', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_icon_menu_mobile',
				'label'        => esc_html__('رنگ آیکون منو موبایل', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ آیکون منو موبایل', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'head_four',
				'label'        => esc_html__('سربرگ 4', 'leora'),
				'desc'         => esc_html__('سربرگ 4', 'leora'),
				'std'          => '',
				'type'         => 'tab',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'show__menu_bar_four',
				'label'        => esc_html__('فعال کردن منوبار', 'leora'),
				'desc'         => esc_html__('فعال /غیر فعال کردن منو بار در سربرگ چهار', 'leora'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_bac_menubar_four',
				'label'        => esc_html__('رنگ پس زمینه سربرگ', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه سربرگ', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_bac_main_menu_four',
				'label'        => esc_html__('رنگ پس زمینه منو', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه منو اصلی سربرگ', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_text_header_four',
				'label'        => esc_html__('رنگ متن سربرگ', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ متن سربرگ ', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_shop_menubar_four',
				'label'        => esc_html__('رنگ پس زمینه منو بار', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه منو بار در سربرگ', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_text_menubar_four',
				'label'        => esc_html__('رنگ متن منو بار', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ متن منو بار در سربرگ', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_icon_four',
				'label'        => esc_html__('رنگ آیکون و منو ها', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ آیکون ها و منو در سربرگ', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'select_baner_four',
				'label'        => esc_html__('بنر سربرگ', 'leora'),
				'desc'         => esc_html__('انتخاب بنر سربرگ چهار', 'leora'),
				'std'          => '',
				'type'         => 'upload',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'select_link_baner_four',
				'label'        => esc_html__('لینک بنر سربرگ', 'leora'),
				'desc'         => esc_html__('انتخاب لینک بنر سربرگ چهار', 'leora'),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'select_baner_code_html_four',
				'label'        => esc_html__('بنر سربرگ', 'leora'),
				'desc'         => esc_html__('انتخاب بنر سربرگ چهار بصورت متنی و HTML', 'leora'),
				'std'          => '',
				'type'         => 'textarea',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'head_five',
				'label'        => esc_html__('سربرگ 5', 'leora'),
				'desc'         => esc_html__('سربرگ 5', 'leora'),
				'std'          => '',
				'type'         => 'tab',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_bac_menubar_five',
				'label'        => esc_html__('رنگ پس زمینه سربرگ', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه سربرگ', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_text_header_five',
				'label'        => esc_html__('رنگ متن سربرگ', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ متن سربرگ ', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_icon_five',
				'label'        => esc_html__('رنگ آیکون ', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ آیکون ها در سربرگ', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'header_tab_6',
				'label'        => esc_html__('سربرگ 6', 'leora'),
				'desc'         => esc_html__('سربرگ شش', 'leora'),
				'std'          => '',
				'type'         => 'tab',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_shop_header_6',
				'label'        => esc_html__('رنگ پس زمینه سربرگ', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه سربرگ', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'header_menu_background_6',
				'label'        => esc_html__('منو', 'leora'),
				'desc'         => esc_html__('انتخاب پس زمینه منو', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_text_menu_6',
				'label'        => esc_html__('رنگ متن ', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ متن سربرگ', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_text_menu_6',
				'label'        => esc_html__('رنگ متن منو ', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ متن منو سربرگ', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_icon_6',
				'label'        => esc_html__('رنگ متن و آیکون', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ متن و آیکون سربرگ', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'border_color_search_6',
				'label'        => esc_html__('حاشیه جستجو', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ حاشیه جستجو', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'header_border_profile_6',
				'label'        => esc_html__('پروفایل', 'leora'),
				'desc'         => esc_html__('انتخاب حاشیه پروفایل کاربران ', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'header_profile_6',
				'label'        => esc_html__('پروفایل', 'leora'),
				'desc'         => esc_html__('انتخاب پس زمینه پروفایل کاربران ', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'fullwidth_shop_color_6',
				'label'        => esc_html__('سبد خرید', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه سبد خرید', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'fullwidth_shop_color_text_6',
				'label'        => esc_html__('سبد خرید', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ متن سبد خرید', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'fullwidth_shop_badge_6',
				'label'        => esc_html__('تعداد سبد خرید', 'leora'),
				'desc'         => esc_html__('انتخاب پس زمینه تعداد کالا در سبد خرید', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'header_radius_6',
				'label'        => esc_html__('گردی', 'leora'),
				'desc'         => esc_html__('تنظیم گردی سربرگ ', 'leora'),
				'std'          => '',
				'type'         => 'numeric-slider',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'header_tab_7',
				'label'        => esc_html__('سربرگ 7', 'leora'),
				'desc'         => esc_html__('سربرگ هفت', 'leora'),
				'std'          => '',
				'type'         => 'tab',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'header_tab_7_backcolor',
				'label'        => esc_html__('پس زمینه سربرگ', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه سربرگ' , 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'header_tab_7_backcolor_menu',
				'label'        => esc_html__('پس زمینه منو سربرگ', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه منو سربرگ' , 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'header_tab_7_backcolor_menu_text',
				'label'        => esc_html__('متن منو سربرگ', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ متن منو سربرگ' , 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'header_tab_7_icon',
				'label'        => esc_html__('رنگ ایکون', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ ایکون در سربرگ' , 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'header_tab_7_icon_border',
				'label'        => esc_html__('رنگ حاشیه ایکون', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ حاشیه ایکون در سربرگ' , 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'select_link_baner_7',
				'label'        => esc_html__('لینک بنر سربرگ', 'leora'),
				'desc'         => esc_html__('انتخاب لینک بنر سربرگ هفت', 'leora'),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'select_baner_7',
				'label'        => esc_html__('بنر سربرگ', 'leora'),
				'desc'         => esc_html__('انتخاب بنر سربرگ هفت', 'leora'),
				'std'          => '',
				'type'         => 'upload',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'header_tab_8',
				'label'        => esc_html__('سربرگ 8', 'leora'),
				'desc'         => esc_html__('سربرگ هشت', 'leora'),
				'std'          => '',
				'type'         => 'tab',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'header_tab_8_backcolor',
				'label'        => esc_html__('پس زمینه سربرگ', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه سربرگ' , 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'header_tab_8_backcolor_menu_text',
				'label'        => esc_html__('متن منو سربرگ', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ متن منو سربرگ' , 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'header_tab_8_icon',
				'label'        => esc_html__('رنگ ایکون', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ ایکون در سربرگ' , 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'header_tab_8_icon_border',
				'label'        => esc_html__('رنگ حاشیه ایکون', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ حاشیه ایکون در سربرگ' , 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'select_link_baner_8',
				'label'        => esc_html__('لینک بنر سربرگ', 'leora'),
				'desc'         => esc_html__('انتخاب لینک بنر سربرگ هشت', 'leora'),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'select_baner_8',
				'label'        => esc_html__('بنر سربرگ', 'leora'),
				'desc'         => esc_html__('انتخاب بنر سربرگ هشت', 'leora'),
				'std'          => '',
				'type'         => 'upload',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'header_tab_9',
				'label'        => esc_html__('سربرگ 9', 'leora'),
				'desc'         => esc_html__('سربرگ نه', 'leora'),
				'std'          => '',
				'type'         => 'tab',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'header_tab_10_backcolor',
				'label'        => esc_html__('پس زمینه سربرگ', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه سربرگ' , 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'header_tab_10_backcolor_menu_text',
				'label'        => esc_html__('متن منو سربرگ', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ متن منو سربرگ' , 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'header_tab_10_icon',
				'label'        => esc_html__('رنگ ایکون', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ ایکون در سربرگ' , 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'header_tab_10_icon_border',
				'label'        => esc_html__('رنگ حاشیه ایکون', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ حاشیه ایکون در سربرگ' , 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'header_tab_10',
				'label'        => esc_html__('سربرگ 10', 'leora'),
				'desc'         => esc_html__('سربرگ 10', 'leora'),
				'std'          => '',
				'type'         => 'tab',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'header_tab_11_backcolor',
				'label'        => esc_html__('پس زمینه سربرگ', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه سربرگ' , 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'header_tab_11_backcolor_menu_text',
				'label'        => esc_html__('متن منو سربرگ', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ متن منو سربرگ' , 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'header_tab_11_icon',
				'label'        => esc_html__('رنگ ایکون', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ ایکون در سربرگ' , 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'header_tab_11_border',
				'label'        => esc_html__('رنگ حاشیه', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ حاشیه در سربرگ' , 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'header_tab_11_icon_border',
				'label'        => esc_html__('رنگ حاشیه ایکون', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ حاشیه ایکون در سربرگ' , 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'header_tab_11',
				'label'        => esc_html__('سربرگ 11', 'leora'),
				'desc'         => esc_html__('سربرگ 11', 'leora'),
				'std'          => '',
				'type'         => 'tab',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'header_11_advanced_button',
				'label'        => esc_html__('متن دکمه', 'leora'),
				'desc'         => esc_html__('انتخاب متن دکمه در سربرگ' , 'leora'),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'header_11_advanced_button_icon',
				'label'        => esc_html__('آیکون دکمه', 'leora'),
				'desc'         => esc_html__('انتخاب آیکون دکمه در سربرگ ( برای انتخاب ایکون اسم شبکه اجتماعی بصورت انگلیسی با حروف کوچک نوشته شود)' , 'leora'),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'header_tab_12_backcolor',
				'label'        => esc_html__('پس زمینه سربرگ', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه سربرگ' , 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'header_tab_12_backcolor_menu_text',
				'label'        => esc_html__('متن منو سربرگ', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ متن منو سربرگ' , 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'header_tab_12_icon',
				'label'        => esc_html__('رنگ ایکون', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ ایکون در سربرگ' , 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'header_tab_12_border',
				'label'        => esc_html__('رنگ حاشیه', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ حاشیه در سربرگ' , 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'header_tab_12_icon_border',
				'label'        => esc_html__('رنگ حاشیه ایکون', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ حاشیه ایکون در سربرگ' , 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'header_tab_12_button',
				'label'        => esc_html__('پس زمینه دکمه', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه دکمه در سربرگ' , 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'header_tab_12_button_text',
				'label'        => esc_html__('متن دکمه', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ متن دکمه در سربرگ' , 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'general_content',
				'label'        => esc_html__('عمومی', 'leora'),
				'desc'         => esc_html__('عمومی', 'leora'),
				'std'          => '',
				'type'         => 'tab',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'select_single',
				'label'        => 'انتخاب قالب نوشته',
				'desc'         => 'انتخاب قالب نوشته بصورت پیش فرض',
				'std'          => '',
				'type'         => 'select',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
				'choices'      => array(
					array(
						'value' => 'def_single',
						'label' => 'پیش فرض',
						'src'   => '',
					),
					array(
						'value' => 'single_1',
						'label' => 'قالب 1',
						'src'   => '',
					),
					array(
						'value' => 'single_2',
						'label' => 'قالب 2',
						'src'   => '',
					),
					array(
						'value' => 'single_3',
						'label' => 'قالب 3',
						'src'   => '',
					),
					array(
						'value' => 'single_4',
						'label' => 'قالب 4',
						'src'   => '',
					),
					array(
						'value' => 'single_5',
						'label' => 'قالب 5',
						'src'   => '',
					),
					array(
						'value' => 'single_6',
						'label' => 'قالب 6',
						'src'   => '',
					),
					array(
						'value' => 'single_7',
						'label' => 'قالب 7',
						'src'   => '',
					),
					array(
						'value' => 'single_8',
						'label' => 'قالب 8',
						'src'   => '',
					),
					array(
						'value' => 'single_9',
						'label' => 'قالب 9',
						'src'   => '',
					),
					array(
						'value' => 'single_10',
						'label' => 'قالب 10',
						'src'   => '',
					),
					array(
						'value' => 'single_11',
						'label' => 'قالب 11',
						'src'   => '',
					),
					array(
						'value' => 'single_12',
						'label' => 'قالب 12',
						'src'   => '',
					),
				),
			),
			array(
				'id'           => 'select_related_posts',
				'label'        => ' سبک مطالب مرتبط',
				'desc'         => 'انتخاب سبک نمایش مطالب مرتبط در صفحه داخلی پیش فرض',
				'std'          => '',
				'type'         => 'select',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
				'choices'      => array(
					array(
						'value' => 'posts_list',
						'label' => 'لیست',
						'src'   => '',
					),
					array(
						'value' => 'posts_box',
						'label' => 'باکس',
						'src'   => '',
					),
				),
			),
			array(
				'id'           => 'news_audio_down',
				'label'        => esc_html__('نمایش اطلاعات مفید', 'leora'),
				'desc'         => esc_html__('فعال و غیر فعال کردن اطلاعات مفید بر روی تصویر شاخص صفحه نوشته (بازدید ، دانلود ، فایل صوتی ، pdf)', 'leora'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'content_post_img',
				'label'        => esc_html__(' عرض تصاویر', 'leora'),
				'desc'         => esc_html__('تمام عرض / استاندارد سایز تصاویر در پست نوشته ها', 'leora'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'news_audio_down_download',
				'label'        => esc_html__('نمایش اطلاعات مفید', 'leora'),
				'desc'         => esc_html__(' فعال و غیر فعال کردن اطلاعات مفید نمایش در صفحه داخلی دانلود (بازدید ، دانلود ، فایل صوتی ، pdf) ', 'leora'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),	
			array(
				'id'           => 'content_post_color',
				'label'        => esc_html__('رنگ نوشته ', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ پست نوشته ها', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'content_post_number_related',
				'label'        => esc_html__('مطالب مرتبط ', 'leora'),
				'desc'         => esc_html__('انتخاب تعداد مطالب مرتبط در صفحه نوشته', 'leora'),
				'std'          => '',
				'type'         => 'numeric-slider',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'avatar_name',
				'label'        => esc_html__(' نویسنده', 'leora'),
				'desc'         => esc_html__('فعال و غیر فعال کردن باکس نویسنده', 'leora'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'display_viwe',
				'label'        => esc_html__('تعداد بازدید', 'leora'),
				'desc'         => esc_html__('فعال و غیر فعال کردن تعداد بازدید', 'leora'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'display_time',
				'label'        => esc_html__('تاریخ نوشته', 'leora'),
				'desc'         => esc_html__('فعال و غیر فعال کردن تاریخ نوشته', 'leora'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'display_share',
				'label'        => esc_html__('اشتراک گذاری', 'leora'),
				'desc'         => esc_html__('فعال و غیر فعال کردن اشتراک گذاری', 'leora'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'comments_number',
				'label'        => esc_html__('تعداد کامنت', 'leora'),
				'desc'         => esc_html__('فعال و غیر فعال کردن تعداد کامنت', 'leora'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'd_category',
				'label'        => esc_html__('دسته بندی ها', 'leora'),
				'desc'         => esc_html__('فعال و غیر فعال کردن دسته بندی ها', 'leora'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'single_next_prev',
				'label'        => esc_html__('نمایش نوشته قبلی و بعدی', 'leora'),
				'desc'         => esc_html__('نمایش نوشته قبلی و بعدی در صفحات داخلی نوشته', 'leora'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'comment_rules',
				'label'        => esc_html__('قوانین نظرات', 'leora'),
				'desc'         => esc_html__('متن قوانین ارسال دیدگاه ، قوانین بصورت لیست نوشته شود و از ul > li استفاده کنید.', 'leora'),
				'std'          => '',
				'type'         => 'textarea',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'general_content_single_1',
				'label'        => esc_html__('قالب 1', 'leora'),
				'desc'         => esc_html__('قالب 1', 'leora'),
				'std'          => '',
				'type'         => 'tab',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'share_single_1',
				'label'        => esc_html__('اشتراک گذاری', 'leora'),
				'desc'         => esc_html__('فعال کردن و غیرفعال کردن اشتراک گذاری', 'leora'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'avatar_single_1',
				'label'        => esc_html__('نویسنده', 'leora'),
				'desc'         => esc_html__('فعال کردن و غیرفعال کردن نویسنده نوشته', 'leora'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'general_content_single_3',
				'label'        => esc_html__('قالب 3', 'leora'),
				'desc'         => esc_html__('قالب 3', 'leora'),
				'std'          => '',
				'type'         => 'tab',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'share_single_3',
				'label'        => esc_html__('اشتراک گذاری', 'leora'),
				'desc'         => esc_html__('فعال کردن و غیرفعال کردن اشتراک گذاری', 'leora'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'avatar_single_3',
				'label'        => esc_html__('نویسنده', 'leora'),
				'desc'         => esc_html__('فعال کردن و غیرفعال کردن نویسنده نوشته', 'leora'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'general_content_single_4',
				'label'        => esc_html__('قالب 4', 'leora'),
				'desc'         => esc_html__('قالب 4', 'leora'),
				'std'          => '',
				'type'         => 'tab',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'avatar_single_4',
				'label'        => esc_html__('نویسنده', 'leora'),
				'desc'         => esc_html__('فعال کردن و غیرفعال کردن نویسنده نوشته', 'leora'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'general_content_single_6',
				'label'        => esc_html__('قالب 6', 'leora'),
				'desc'         => esc_html__('قالب 6', 'leora'),
				'std'          => '',
				'type'         => 'tab',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_backgrund_single_6',
				'label'        => esc_html__('رنگ پس زمینه', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه صفحه داخلی', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'general_content_single_8',
				'label'        => esc_html__('قالب 8', 'leora'),
				'desc'         => esc_html__('قالب 8', 'leora'),
				'std'          => '',
				'type'         => 'tab',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_backgrund_single_8',
				'label'        => esc_html__('رنگ پس زمینه', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه صفحه داخلی', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'general_content_single_9',
				'label'        => esc_html__('قالب 9', 'leora'),
				'desc'         => esc_html__('قالب 9', 'leora'),
				'std'          => '',
				'type'         => 'tab',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_backgrund_single_9',
				'label'        => esc_html__('رنگ پس زمینه', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه صفحه داخلی', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'general_content_single_10',
				'label'        => esc_html__('قالب 10', 'leora'),
				'desc'         => esc_html__('قالب 10', 'leora'),
				'std'          => '',
				'type'         => 'tab',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_backgrund_single_10',
				'label'        => esc_html__('رنگ پس زمینه', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه صفحه داخلی', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'general_content_single_11',
				'label'        => esc_html__('قالب 11', 'leora'),
				'desc'         => esc_html__('قالب 11', 'leora'),
				'std'          => '',
				'type'         => 'tab',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_backgrund_single_11',
				'label'        => esc_html__('رنگ پس زمینه', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه صفحه داخلی', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'general_content_single_12',
				'label'        => esc_html__('قالب 12', 'leora'),
				'desc'         => esc_html__('قالب 12', 'leora'),
				'std'          => '',
				'type'         => 'tab',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_backgrund_single_12',
				'label'        => esc_html__('رنگ پس زمینه', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه صفحه داخلی', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'suggestions_general',
				'label'        => esc_html__('عمومی', 'leora'),
				'desc'         => esc_html__('عمومی', 'leora'),
				'std'          => '',
				'type'         => 'tab',
				'section'      => 'read_more',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'show_read_more',
				'label'        => esc_html__('نمایش پیشنهادات', 'leora'),
				'desc'         => esc_html__('فعال / غیر فعال کردن پیشنهادات در صفحه نوشته ', 'leora'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'read_more',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'show_read_more_archive',
				'label'        => esc_html__('نمایش پیشنهادات', 'leora'),
				'desc'         => esc_html__('فعال / غیر فعال کردن پیشنهادات در صفحه آرشیو', 'leora'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'read_more',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'show_article_popular',
				'label'        => esc_html__('نمایش مطالب پربازدید', 'leora'),
				'desc'         => esc_html__('فعال و غیر فعال کردن مطالب پربازدید در صفحه نوشته ها', 'leora'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'read_more',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			), 
			array(
				'id'           => 'show_arcive_popular',
				'label'        => esc_html__('نمایش مطالب پر بازدید', 'leora'),
				'desc'         => esc_html__('فعال و غیر فعال کردن مطالب پربازدید در صفحه آرشیو', 'leora'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'read_more',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'suggestions',
				'label'        => esc_html__('پیشنهادات', 'leora'),
				'desc'         => esc_html__('پیشنهادات', 'leora'),
				'std'          => '',
				'type'         => 'tab',
				'section'      => 'read_more',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'text_read_more',
				'label'        => esc_html__('عنوان پیشنهادات', 'leora'),
				'desc'         => esc_html__('انتخاب عنوان پیشنهادات در صفحه نوشته ها', 'leora'),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'read_more',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'item_read_more',
				'label'        => esc_html__('تعداد مطالب ', 'leora'),
				'desc'         => esc_html__('انتخاب تعداد مطالب ،پیشنهادات در صفحه نوشته ها', 'leora'),
				'std'          => '',
				'type'         => 'numeric-slider',
				'section'      => 'read_more',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'colorpicker_tab_background',
				'label'        => esc_html__('پس زمینه تب فعال', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه تب هنگام فعال شدن', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'read_more',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'colorpicker_tab_background_active',
				'label'        => esc_html__('متن تب فعال', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ متن تب هنگام فعال شدن', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'read_more',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'colorpicker_tab_text',
				'label'        => esc_html__('متن تب', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ متن تب', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'read_more',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'colorpicker_tab_border',
				'label'        => esc_html__('حاشیه تب', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ حاشیه تب', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'read_more',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'colorpicker_tab_border_radius',
				'label'        => esc_html__('گردی', 'leora'),
				'desc'         => esc_html__('انتخاب گردی محتوای تب', 'leora'),
				'std'          => '',
				'type'         => 'numeric-slider',
				'section'      => 'read_more',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'read_more_footer',
				'label'        => esc_html__('read more', 'leora'),
				'desc'         => '',
				'std'          => '',
				'type'         => 'list-item',
				'section'      => 'read_more',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
				'settings'    => array( 
					array(
						'id'          => 'category_select_id_1',
						'label'       => __('انتخاب دسته بندی ستون یک', 'leora'),
						'desc'        => __('انتخاب دسته بندی بیشتر بخوانید در صفحه نوشته', 'leora'),
						'std'         => '',
						'type'        => 'category-select',
						'section'     => 'read_more',
						'rows'        => '',
						'post_type'   => '',
						'taxonomy'    => '',
						'min_max_step' => '',
						'class'       => '',
						'condition'   => '',
						'operator'    => 'and'
					),
				  )
			),
			array(
				'id'           => 'suggestions_slid',
				'label'        => esc_html__('اسلاید', 'leora'),
				'desc'         => esc_html__('اسلاید', 'leora'),
				'std'          => '',
				'type'         => 'tab',
				'section'      => 'read_more',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'select__query',
				'label'        => 'ویژگی نوشته',
				'desc'         => 'نمایش بر اساس مطالب محبوب ، پربازدید ، اخیر در بالای نوشته',
				'std'          => '',
				'type'         => 'select',
				'section'      => 'read_more',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
				'choices'      => array(
					array(
						'value' => 'date',
						'label' => 'اخیر',
						'src'   => '',
					),
					array(
						'value' => 'popular_posts',
						'label' => 'محبوب',
						'src'   => '',
					),
					array(
						'value' => 'comment_count',
						'label' => 'پربازدید',
						'src'   => '',
					),
				),
			),
			array(
				'id'           => 'show_archive_category',
				'label'        => esc_html__('نمایش دسته بندی', 'leora'),
				'desc'         => esc_html__('فعال و غیر فعال کردن دسته بندی', 'leora'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'read_more',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'show_archive_infomations',
				'label'        => esc_html__('مشخصات', 'leora'),
				'desc'         => esc_html__('فعال و غیر فعال کردن مشخصات', 'leora'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'read_more',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'show_archive_icon',
				'label'        => esc_html__('نمایش آیکون', 'leora'),
				'desc'         => esc_html__('فعال و غیر فعال کردن آیکون', 'leora'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'read_more',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'colorpicker_tab_category_back',
				'label'        => esc_html__('دسته بندی', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه دسته بندی', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'read_more',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'colorpicker_tab_category_text',
				'label'        => esc_html__('دسته بندی', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ متن دسته بندی', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'read_more',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'colorpicker_tab_bookmark_back',
				'label'        => esc_html__('پس زمینه آیکون', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه آیکون', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'read_more',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'colorpicker_tab_bookmark_text',
				'label'        => esc_html__('آیکون', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ آیکون ', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'read_more',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'suggenstioanstop_border_radius',
				'label'        => esc_html__('گردی', 'leora'),
				'desc'         => esc_html__('انتخاب گردی محتوای تب', 'leora'),
				'std'          => '',
				'type'         => 'numeric-slider',
				'section'      => 'read_more',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'general_footer',
				'label'        => esc_html__('عمومی', 'leora'),
				'desc'         => esc_html__('عمومی', 'leora'),
				'std'          => '',
				'type'         => 'tab',
				'section'      => 'footer_blog',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'background_footer_blog',
				'label'        => esc_html__('Blog Footer Background', 'leora'),
				'desc'         => esc_html__('Choose a footer background on the blog', 'leora'),
				'std'          => '',
				'type'         => 'background',
				'section'      => 'footer_blog',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_footer_text_menu',
				'label'        => esc_html__('Footer menu color text', 'leora'),
				'desc'         => esc_html__('Color the menu text in the blog footer', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'footer_blog',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'copyright_text',
				'label'        => esc_html__('Copyright text', 'leora'),
				'desc'         => esc_html__('Copyright text in the blog footer', 'leora'),
				'std'          => '',
				'type'         => 'textarea-simple',
				'section'      => 'footer_blog',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'copyright_text_color',
				'label'        => esc_html__('Copyright text color', 'leora'),
				'desc'         => esc_html__('The color of the copyrighted text in the blog footer', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'footer_blog',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'title_text_color',
				'label'        => esc_html__('color title', 'leora'),
				'desc'         => esc_html__('The color of the title text in the blog footer', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'footer_blog',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'icon_social_text_color',
				'label'        => esc_html__('color icon', 'leora'),
				'desc'         => esc_html__('The color of the icon social in the blog footer', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'footer_blog',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'footer_social',
				'label'        => esc_html__('شبکه اجتماعی', 'leora'),
				'desc'         => esc_html__('شبکه اجتماعی', 'leora'),
				'std'          => '',
				'type'         => 'tab',
				'section'      => 'footer_blog',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'display_social',
				'label'        => esc_html__('نمایش شبکه اجتماعی', 'leora'),
				'desc'         => esc_html__('فعال و غیر فعال کردن شبکه اجتماعی ', 'leora'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'footer_blog',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'social_links',
				'label'        => esc_html__('social network', 'leora'),
				'desc'         => '',
				'std'          => '',
				'type'         => 'social-links',
				'section'      => 'footer_blog',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'display_search_advanced',
				'label'        => esc_html__('نمایش جستجوی پیشرفته', 'leora'),
				'desc'         => esc_html__('فعال و غیر فعال کردن جستجوی پیشرفته ', 'leora'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'search',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'search_advanced_img_1',
				'label'        => esc_html__('آپلود تصویر', 'leora'),
				'desc'         => esc_html__('انتخاب تصویر نمایش در بخش جستجوی پاپ اپ', 'leora'),
				'std'          => '',
				'type'         => 'upload',
				'section'      => 'search',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'search_advanced_link_1',
				'label'        => esc_html__('لینک تصویر', 'leora'),
				'desc'         => esc_html__('انتخاب لینک نمایش در بخش جستجوی پاپ اپ', 'leora'),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'search',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'search_advanced_img_2',
				'label'        => esc_html__('آپلود تصویر', 'leora'),
				'desc'         => esc_html__('انتخاب تصویر نمایش در بخش جستجوی پاپ اپ', 'leora'),
				'std'          => '',
				'type'         => 'upload',
				'section'      => 'search',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'search_advanced_link_2',
				'label'        => esc_html__('لینک تصویر', 'leora'),
				'desc'         => esc_html__('انتخاب لینک نمایش در بخش جستجوی پاپ اپ', 'leora'),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'search',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'search_advanced_img_3',
				'label'        => esc_html__('آپلود تصویر', 'leora'),
				'desc'         => esc_html__('انتخاب تصویر نمایش در بخش جستجوی پاپ اپ', 'leora'),
				'std'          => '',
				'type'         => 'upload',
				'section'      => 'search',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'search_advanced_link_3',
				'label'        => esc_html__('لینک تصویر', 'leora'),
				'desc'         => esc_html__('انتخاب لینک نمایش در بخش جستجوی پاپ اپ', 'leora'),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'search',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'search_advanced_img_4',
				'label'        => esc_html__('آپلود تصویر', 'leora'),
				'desc'         => esc_html__('انتخاب تصویر نمایش در بخش جستجوی پاپ اپ', 'leora'),
				'std'          => '',
				'type'         => 'upload',
				'section'      => 'search',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'search_advanced_link_4',
				'label'        => esc_html__('لینک تصویر', 'leora'),
				'desc'         => esc_html__('انتخاب لینک نمایش در بخش جستجوی پاپ اپ', 'leora'),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'search',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_backgrund_add_cart',
				'label'        => esc_html__('رنگ پس زمینه دکمه سبد خرید', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه دکمه افزودن به سبد خرید در صفحه محصول', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'product_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_text_add_cart',
				'label'        => esc_html__('رنگ متن دکمه سبد خرید', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ متن دکمه افزودن به سبد خرید در صفحه محصول', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'product_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'link_call_back_to_top',
				'label'        => esc_html__('لینک تماس', 'leora'),
				'desc'         => esc_html__('انتخاب لینک تماس با ما یا لینک تلگرام ، واتساپ و...', 'leora'),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'back_to_top',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'text_call_back_to_top',
				'label'        => esc_html__('متن نگهدارنده تماس', 'leora'),
				'desc'         => esc_html__('انتخاب شماره تماس  یا ایدی تلگرام ، واتساپ و...', 'leora'),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'back_to_top',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'display_profile_back',
				'label'        => esc_html__('نمایش پروفایل', 'leora'),
				'desc'         => esc_html__('فعال و غیر فعال کردن دکمه پروفایل کاربری', 'leora'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'back_to_top',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'display_share_back',
				'label'        => esc_html__('نمایش اشتراک گذاری', 'leora'),
				'desc'         => esc_html__('فعال و غیر فعال کردن دکمه اشتراک گذاری', 'leora'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'back_to_top',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'display_call_back',
				'label'        => esc_html__('نمایش تماس باما', 'leora'),
				'desc'         => esc_html__('فعال و غیر فعال کردن دکمه تماس با ما', 'leora'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'back_to_top',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'display_back_to_top',
				'label'        => esc_html__('نمایش بازگشت به بالا', 'leora'),
				'desc'         => esc_html__('فعال و غیر فعال کردن دکمه بازگشت به بالا', 'leora'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'back_to_top',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_background_back_to_top',
				'label'        => esc_html__('رنگ پس زمینه', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه دکمه ها', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'back_to_top',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_icon_back_to_top',
				'label'        => esc_html__('رنگ آیکون ها', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ آیکون ها', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'back_to_top',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_hover_back_to_top',
				'label'        => esc_html__('رنگ پس زمینه هاور ', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه هاور شدن دکمه ها', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'back_to_top',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_hover_text_back_to_top',
				'label'        => esc_html__('رنگ  متن هاور ', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ  متن هنگام هاور شدن دکمه ها', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'back_to_top',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'link_profile_user',
				'label'        => esc_html__('page profile ', 'leora'),
				'desc'         => esc_html__('select page profile users', 'leora'),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'profile_user',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'text_profile_user',
				'label'        => esc_html__('text contact ', 'leora'),
				'desc'         => esc_html__('text contact profile users', 'leora'),
				'std'          => '',
				'type'         => 'textarea',
				'section'      => 'profile_user',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'show_social_network',
				'label'        => esc_html__('نمایش شبکه اجتماعی ', 'leora'),
				'desc'         => esc_html__('فعال / غیر فعال کردن نمایش شبکه اجتماعی در بالای فوتر', 'leora'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'social_network',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'social_network_name',
				'label'        => esc_html__('عنوان', 'leora'),
				'desc'         => esc_html__('عنوان دکمه شبکه اجتماعی در بالای فوتر', 'leora'),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'social_network',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'social_network_link',
				'label'        => esc_html__('لینک', 'leora'),
				'desc'         => esc_html__('لینک دکمه شبکه اجتماعی در بالای فوتر', 'leora'),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'social_network',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'social_network_border_radius',
				'label'        => esc_html__('گردی', 'leora'),
				'desc'         => esc_html__('گردی کناری شبکه اجتماعی در بالای فوتر', 'leora'),
				'std'          => '',
				'type'         => 'numeric-slider',
				'section'      => 'social_network',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'social_network_backgr_color',
				'label'        => esc_html__('رنگ پس زمینه', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه شبکه اجتماعی', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'social_network',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'social_network_bth_color',
				'label'        => esc_html__('رنگ پس زمینه دکمه', 'leora'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه دکمه شبکه اجتماعی', 'leora'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'social_network',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'social_top_footer',
				'label'        => esc_html__('social network', 'leora'),
				'desc'         => '',
				'std'          => '',
				'type'         => 'list-item',
				'section'      => 'social_network',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
				'settings'    => array( 
					array(
						'id'          => 'social_icon',
						'label'       => __( 'Icon', 'leora' ),
						'desc'         => esc_html__('نام شبکه اجتماعی بصورت انگلیسی و با حروف کوچک', 'leora'),
						'std'         => '',
						'type'        => 'text',
						'rows'        => '10',
						'post_type'   => '',
						'taxonomy'    => '',
						'min_max_step'=> '',
						'class'       => '',
						'condition'   => '',
						'operator'    => 'and'
					  ),
					array(
					  'id'          => 'social_link',
					  'label'       => __( 'link', 'leora' ),
					  'desc'        => '',
					  'std'         => '',
					  'type'        => 'text',
					  'rows'        => '10',
					  'post_type'   => '',
					  'taxonomy'    => '',
					  'min_max_step'=> '',
					  'class'       => '',
					  'condition'   => '',
					  'operator'    => 'and'
					),
					array(
					  'id'          => 'social_images',
					  'label'       => __( 'images', 'leora' ),
					  'desc'        => 'انتخاب تصویر شبکه اجتماعی',
					  'std'         => '',
					  'type'        => 'upload',
					  'rows'        => '10',
					  'post_type'   => '',
					  'taxonomy'    => '',
					  'min_max_step'=> '',
					  'class'       => '',
					  'condition'   => '',
					  'operator'    => 'and'
					),
				  )
			),
			array(
				'id'           => 'advertising_area_title',
				'label'        => esc_html__('عنوان تبلیغات', 'leora'),
				'desc'         => esc_html__('درج عنوان تبلیغات نمایش در صفحات داخلی', 'leora'),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'advertising',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'advertising_area',
				'label'        => esc_html__('متن یا کد تبلیغات', 'leora'),
				'desc'         => esc_html__('درج متن تبلیغات یا درج کد پلتفرم های تبلیغاتی همانند یکتانت', 'leora'),
				'std'          => '',
				'type'         => 'textarea',
				'section'      => 'advertising',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'advertising_post_top',
				'label'        => esc_html__('بنر تبلیغات نوشته', 'leora'),
				'desc'         => esc_html__('انتخاب بنر تبلیغاتی در بالای صفحه نوشته', 'leora'),
				'std'          => '',
				'type'         => 'upload',
				'section'      => 'advertising',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'advertising_post_top_link',
				'label'        => esc_html__('لینک تبلیغاتی نوشته', 'leora'),
				'desc'         => esc_html__('انتخاب لینک بنر  تبلیغاتی در بالای صفحه نوشته', 'leora'),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'advertising',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'advertising_post_bot',
				'label'        => esc_html__('بنر تبلیغات نوشته', 'leora'),
				'desc'         => esc_html__('انتخاب بنر تبلیغاتی در پایین صفحه نوشته', 'leora'),
				'std'          => '',
				'type'         => 'upload',
				'section'      => 'advertising',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'advertising_post_bot_link',
				'label'        => esc_html__('لینک تبلیغاتی نوشته', 'leora'),
				'desc'         => esc_html__('انتخاب لینک بنر  تبلیغاتی در پایین صفحه نوشته', 'leora'),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'advertising',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'add_css_advan',
				'label'        => esc_html__('custom css', 'leora'),
				'desc'         => '',
				'std'          => '',
				'type'         => 'css',
				'section'      => 'advanced',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
		)
	);

	// Allow settings to be filtered before saving.
	$custom_settings = apply_filters(ot_settings_id() . '_args', $custom_settings);

	// Settings are not the same update the DB.
	if ($saved_settings !== $custom_settings) {
		update_option(ot_settings_id(), $custom_settings);
	}

	// Lets OptionTree know the UI Builder is being overridden.
	global $ot_has_custom_theme_options;
	$ot_has_custom_theme_options = true;
	$select_classic = ot_get_option('select_classic');
	if ($select_classic == 'classic') {
	add_filter( 'gutenberg_use_widgets_block_editor', '__return_false' );
	add_filter( 'use_widgets_block_editor', '__return_false' );
	}
	/* ------------------------------------------------  top and down sidbar mobile ----------------------------*/
}
