<?php
function metaboxs_get_meta($value)
{
	global $post;

	$field = get_post_meta($post->ID, $value, true);
	if (!empty($field)) {
		return is_array($field) ? stripslashes_deep($field) : stripslashes(wp_kses_decode_entities($field));
	} else {
		return false;
	}
}

function metaboxs_add_meta_box()
{
	add_meta_box(
		'metaboxs-metaboxs',
		__('additional', 'leora'),
		'metaboxs_html',
		'product',
		'normal',
		'high'
	);
}
add_action('add_meta_boxes', 'metaboxs_add_meta_box');

function metaboxs_html($post)
{
	wp_nonce_field('_metaboxs_nonce', 'metaboxs_nonce'); ?>

	<p>
		<label for="Delivery_Time"><?php _e('حداکثر زمان تحویل', 'leora'); ?></label><br>
		<input size="50" type="text" name="Delivery_Time" id="Delivery_Time" value="<?php echo metaboxs_get_meta('Delivery_Time'); ?>">
	</p>
	<p>
		<label for="metaboxs_metaboxs1"><?php _e('English title', 'leora'); ?></label><br>
		<input size="50" type="text" name="metaboxs_metaboxs1" id="metaboxs_metaboxs1" value="<?php echo metaboxs_get_meta('metaboxs_metaboxs1'); ?>">
	</p>
	<p>
		<label for="metaboxs_metaboxs3"><?php _e('Warning', 'leora'); ?></label><br>
		<textarea rows="4" cols="50" name="metaboxs_metaboxs3" id="metaboxs_metaboxs3"><?php echo metaboxs_get_meta('metaboxs_metaboxs3'); ?></textarea>
	</p><?php
	}

	function metaboxs_save($post_id)
	{
		if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;
		if (!isset($_POST['metaboxs_nonce']) || !wp_verify_nonce($_POST['metaboxs_nonce'], '_metaboxs_nonce')) return;
		if (!current_user_can('edit_post', $post_id)) return;

		if (isset($_POST['metaboxs_metaboxs1']))
			update_post_meta($post_id, 'metaboxs_metaboxs1', esc_attr($_POST['metaboxs_metaboxs1']));
		if (isset($_POST['metaboxs_metaboxs3']))
			update_post_meta($post_id, 'metaboxs_metaboxs3', esc_attr($_POST['metaboxs_metaboxs3']));
		if (isset($_POST['Delivery_Time']))
			update_post_meta($post_id, 'Delivery_Time', esc_attr($_POST['Delivery_Time']));
	}
	add_action('save_post', 'metaboxs_save');

	/*
	Usage: metaboxs_get_meta( 'metaboxs_metaboxs1' )
	Usage: metaboxs_get_meta( 'metaboxs_metaboxs3' )
*/

	function __get_meta($value)
	{
		global $post;

		$field = get_post_meta($post->ID, $value, true);
		if (!empty($field)) {
			return is_array($field) ? stripslashes_deep($field) : stripslashes(wp_kses_decode_entities($field));
		} else {
			return false;
		}
	}

	function __add_meta_box()
	{
		add_meta_box(
			'_--',
			__('Link application', 'leora'),
			'__html',
			'post',
			'normal',
			'low'
		);
	}
	add_action('add_meta_boxes', '__add_meta_box');

	function __html($post)
	{
		wp_nonce_field('___nonce', '__nonce'); ?>
	<p><?php __('App display in the content box', 'leora'); ?></p>
	<p>
		<label for="__application0"><?php _e('Link 1', 'leora'); ?></label><br>
		<input size="50" type="text" name="__application0" id="__application0" value="<?php echo __get_meta('__application0'); ?>">
	</p>
	<p>
		<label for="__application1"><?php _e('Link 2', 'leora'); ?></label><br>
		<input size="50" type="text" name="__application1" id="__application1" value="<?php echo __get_meta('__application1'); ?>">
	</p>
	<p>
		<label for="__application2"><?php _e('Link 3', 'leora'); ?></label><br>
		<input size="50" type="text" name="__application2" id="__application2" value="<?php echo __get_meta('__application2'); ?>">
	</p>
	<p>
		<label for="__application3"><?php _e('Link 4', 'leora'); ?></label><br>
		<input size="50" type="text" name="__application3" id="__application3" value="<?php echo __get_meta('__application3'); ?>">
	</p>
<?php
	}

	function __save($post_id)
	{
		if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;
		if (!isset($_POST['__nonce']) || !wp_verify_nonce($_POST['__nonce'], '___nonce')) return;
		if (!current_user_can('edit_post', $post_id)) return;

		if (isset($_POST['__application0']))
			update_post_meta($post_id, '__application0', esc_attr($_POST['__application0']));
		if (isset($_POST['__application1']))
			update_post_meta($post_id, '__application1', esc_attr($_POST['__application1']));
		if (isset($_POST['__application2']))
			update_post_meta($post_id, '__application2', esc_attr($_POST['__application2']));
		if (isset($_POST['__application3']))
			update_post_meta($post_id, '__application3', esc_attr($_POST['__application3']));
	}
	add_action('save_post', '__save');
	function source_get_meta($value)
	{
		global $post;
		$field = get_post_meta($post->ID, $value, true);
		if (!empty($field)) {
			return is_array($field) ? stripslashes_deep($field) : stripslashes(wp_kses_decode_entities($field));
		} else {
			return false;
		}
	}

	function info_content_get_meta($value)
	{
		global $post;

		$field = get_post_meta($post->ID, $value, true);
		if (!empty($field)) {
			return is_array($field) ? stripslashes_deep($field) : stripslashes(wp_kses_decode_entities($field));
		} else {
			return false;
		}
	}

	function info_content_add_meta_box()
	{
		add_meta_box(
			'info_content-info-content',
			__('info content', 'leora'),
			'info_content_html',
			'post',
			'normal',
			'default'
		);
	}
	add_action('add_meta_boxes', 'info_content_add_meta_box');

	function info_content_html($post)
	{
		wp_nonce_field('_info_content_nonce', 'info_content_nonce'); ?>
	<p>
		<label for="info_content_version"><?php _e('version', 'leora'); ?></label><br>
		<input type="text" name="info_content_version" id="info_content_version" value="<?php echo info_content_get_meta('info_content_version'); ?>">
	</p>
	<p>
		<label for="info_content_sursee"><?php _e('sursee', 'leora'); ?></label><br>
		<input type="text" name="info_content_sursee" id="info_content_sursee" value="<?php echo info_content_get_meta('info_content_sursee'); ?>">
	</p>
	<p>
		<label for="info_content_sursee_link"><?php _e('sursee link', 'leora'); ?></label><br>
		<input type="text" name="info_content_sursee_link" id="info_content_sursee_link" value="<?php echo info_content_get_meta('info_content_sursee_link'); ?>">
	</p>
	<p>
		<label for="info_content_sursee1"><?php _e('sursee', 'leora'); ?>2</label><br>
		<input type="text" name="info_content_sursee1" id="info_content_sursee1" value="<?php echo info_content_get_meta('info_content_sursee1'); ?>">
	</p>
	<p>
		<label for="info_content_sursee_link1"><?php _e('sursee link', 'leora'); ?>2</label><br>
		<input type="text" name="info_content_sursee_link1" id="info_content_sursee_link1" value="<?php echo info_content_get_meta('info_content_sursee_link1'); ?>">
	</p>
	<p>
		<label for="info_content_audio_link"><?php _e('لینک فایل صوتی', 'leora'); ?></label><br>
		<input type="text" placeholder="https://audio.mp3" name="info_content_audio_link" id="info_content_audio_link" value="<?php echo info_content_get_meta('info_content_audio_link'); ?>">
	</p> 
	<p>
	<label for="info_content_file_download"><?php _e('لینک فایل دانلودی', 'leora'); ?></label><br>
	<input type="text" placeholder="https://download.zip" name="info_content_file_download" id="info_content_file_download" value="<?php echo info_content_get_meta('info_content_file_download'); ?>">
	</p> 
	<p>
		<label for="info_content_file_pdf"><?php _e('لینک فایل PDF', 'leora'); ?></label><br>
		<input type="text" placeholder="https://download.pdf" name="info_content_file_pdf" id="info_content_file_pdf" value="<?php echo info_content_get_meta('info_content_file_pdf'); ?>">
	</p> 
	<?php
	}

	function info_content_save($post_id)
	{
		if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;
		if (!isset($_POST['info_content_nonce']) || !wp_verify_nonce($_POST['info_content_nonce'], '_info_content_nonce')) return;
		if (!current_user_can('edit_post', $post_id)) return;

		if (isset($_POST['info_content_version']))
			update_post_meta($post_id, 'info_content_version', esc_attr($_POST['info_content_version']));
		if (isset($_POST['info_content_sursee']))
			update_post_meta($post_id, 'info_content_sursee', esc_attr($_POST['info_content_sursee']));
		if (isset($_POST['info_content_sursee_link']))
			update_post_meta($post_id, 'info_content_sursee_link', esc_attr($_POST['info_content_sursee_link']));
		if (isset($_POST['info_content_sursee1']))
			update_post_meta($post_id, 'info_content_sursee1', esc_attr($_POST['info_content_sursee1']));
		if (isset($_POST['info_content_sursee_link1']))
			update_post_meta($post_id, 'info_content_sursee_link1', esc_attr($_POST['info_content_sursee_link1']));
		if (isset($_POST['info_content_audio_link']))
			update_post_meta($post_id, 'info_content_audio_link', esc_attr($_POST['info_content_audio_link']));
		if (isset($_POST['info_content_file_download']))
			update_post_meta($post_id, 'info_content_file_download', esc_attr($_POST['info_content_file_download']));
		if (isset($_POST['info_content_file_pdf']))
			update_post_meta($post_id, 'info_content_file_pdf', esc_attr($_POST['info_content_file_pdf']));
	}
	add_action('save_post', 'info_content_save');

	/*
	Usage: info_content_get_meta( 'info_content_version' )
	Usage: info_content_get_meta( 'info_content_audio_link' )
	Usage: info_content_get_meta( 'info_content_sursee_link' )
*/
	/**
	 * original product
	 */

	function original_product_get_meta($value)
	{
		global $post;

		$field = get_post_meta($post->ID, $value, true);
		if (!empty($field)) {
			return is_array($field) ? stripslashes_deep($field) : stripslashes(wp_kses_decode_entities($field));
		} else {
			return false;
		}
	}

	function original_product_add_meta_box()
	{
		add_meta_box(
			'original_product-original-product',
			__('Product Information', 'leora'),
			'original_product_html',
			'product',
			'side',
			'default'
		);
	}
	add_action('add_meta_boxes', 'original_product_add_meta_box');

	function original_product_html($post)
	{
		wp_nonce_field('_original_product_nonce', 'original_product_nonce'); ?>
	<p>
		<input type="checkbox" name="original_product_original" id="original_product_original" value="original" <?php echo (original_product_get_meta('original_product_original') === 'original') ? 'checked' : ''; ?>>
		<label for="original_product_original"><?php _e('original', 'leora'); ?></label>
	</p>
	<p>
		<input type="checkbox" name="free_product" id="free_product" value="original" <?php echo (original_product_get_meta('free_product') === 'original') ? 'checked' : ''; ?>>
		<label for="free_product"><?php _e('free delivery', 'leora'); ?></label>
	</p>
	<p>
		<input type="checkbox" name="gift_product" id="gift_product" value="original" <?php echo (original_product_get_meta('gift_product') === 'original') ? 'checked' : ''; ?>>
		<label for="gift_product"><?php _e('Buy gifts', 'leora'); ?></label>
	</p>
	<p>
		<input type="checkbox" name="Marketing" id="Marketing" value="original" <?php echo (original_product_get_meta('Marketing') === 'original') ? 'checked' : ''; ?>>
		<label for="gift_product"><?php _e('affiliate marketing', 'leora'); ?></label>
	</p>
	<p>
		<input type="checkbox" name="Warranty" id="Warranty" value="original" <?php echo (original_product_get_meta('Warranty') === 'original') ? 'checked' : ''; ?>>
		<label for="gift_product"><?php _e('Warranty', 'leora'); ?></label>
	</p>
	<p>
		<input type="checkbox" name="Marketing_link" id="Marketing_link" value="original" <?php echo (original_product_get_meta('Marketing_link') === 'original') ? 'checked' : ''; ?>>
		<label for="gift_product"><?php _e('link', 'leora'); ?></label>
	</p>
<?php
	}

	function original_product_save($post_id)
	{
		if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;
		if (!isset($_POST['original_product_nonce']) || !wp_verify_nonce($_POST['original_product_nonce'], '_original_product_nonce')) return;
		if (!current_user_can('edit_post', $post_id)) return;

		if (isset($_POST['original_product_original']))
			update_post_meta($post_id, 'original_product_original', esc_attr($_POST['original_product_original']));
		else
			update_post_meta($post_id, 'original_product_original', null);

		if (isset($_POST['free_product']))
			update_post_meta($post_id, 'free_product', esc_attr($_POST['free_product']));
		else
			update_post_meta($post_id, 'free_product', null);

		if (isset($_POST['gift_product']))
			update_post_meta($post_id, 'gift_product', esc_attr($_POST['gift_product']));
		else
			update_post_meta($post_id, 'gift_product', null);

		if (isset($_POST['Marketing']))
			update_post_meta($post_id, 'Marketing', esc_attr($_POST['Marketing']));
		else
			update_post_meta($post_id, 'Marketing', null);

		if (isset($_POST['Marketing_link']))
			update_post_meta($post_id, 'Marketing_link', esc_attr($_POST['Marketing_link']));
		else
			update_post_meta($post_id, 'Marketing_link', null);
		if (isset($_POST['Warranty']))
			update_post_meta($post_id, 'Warranty', esc_attr($_POST['Warranty']));
		else
			update_post_meta($post_id, 'Warranty', null);
	}
	add_action('save_post', 'original_product_save');

/*
	Usage: original_product_get_meta( 'original_product_original' )
*/
