<?php

##ASD 250*250 ------------------------------------------ #
add_action('widgets_init', 'ads250_250_widget_box');
function ads250_250_widget_box()
{
	register_widget('ads250_250_widget');
}
class ads250_250_widget extends WP_Widget
{
	function __construct()
	{
		$widget_ops = array('classname' => 'e3lan e3lan250_250-widget', 'description' => '');
		$control_ops = array('width' => 250, 'height' => 350, 'id_base' => 'ads250_250-widget');
		parent::__construct(
			'embed-embed',
			__('Advertising', 'leora'),
			'embed_html',
			'post',
			'normal',
			'default',
			$widget_ops,
			$control_ops
		);
	}

	function widget($args, $instance)
	{
		extract($args);
		$tran_bg = $instance['tran_bg'];
		$new_window = $instance['new_window'];
		$nofollow = $instance['nofollow'];

		if ($new_window) $new_window = ' target="_blank" ';
		else $new_window = '';

		if ($nofollow) $nofollow = 'rel="nofollow"';
		else $nofollow = '';

		if (!$tran_bg) {
			echo $before_widget;
		} ?>
		<div <?php if ($tran_bg) echo 'id="' . $args['widget_id'] . '"'; ?> class="e3lan-widget-content e3lan250-250">
			<?php $i = 1; ?>
			<?php if (!empty($instance['ads' . $i . '_code'])) { ?>
				<div class="e3lan-cell">
					<?php echo do_shortcode($instance['ads' . $i . '_code']); ?>

				</div>
			<?php } elseif (!empty($instance['ads' . $i . '_img'])) { ?>
				<div class="e3lan-cell">
					<?php if ($instance['ads' . $i . '_url']) { ?><a href="<?php echo $instance['ads' . $i . '_url'] ?>" <?php echo $new_window ?> <?php echo $nofollow ?>><?php } ?>
						<img src="<?php echo $instance['ads' . $i . '_img'] ?>" alt="" />
						<?php if ($instance['ads' . $i . '_url']) { ?></a><?php } ?>
				</div>
			<?php
			}
			?>
		</div>
	<?php
		if (!$tran_bg)
			echo $after_widget;
	}

	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		$instance['tran_bg'] = strip_tags($new_instance['tran_bg']);
		$instance['new_window'] = strip_tags($new_instance['new_window']);
		$instance['nofollow'] = strip_tags($new_instance['nofollow']);

		$i = 1;
		$instance['ads' . $i . '_img'] = strip_tags($new_instance['ads' . $i . '_img']);
		$instance['ads' . $i . '_url'] = strip_tags($new_instance['ads' . $i . '_url']);
		$instance['ads' . $i . '_code'] =  $new_instance['ads' . $i . '_code'];

		return $instance;
	}
	function form($instance)
	{
	?>
		<p>
			<label for="<?php echo $this->get_field_id('tran_bg'); ?>"><?php _e('Content only:', 'leora') ?></label>
			<input id="<?php echo $this->get_field_id('tran_bg'); ?>" name="<?php echo $this->get_field_name('tran_bg'); ?>" value="true" <?php if (!empty($instance['tran_bg'])) echo 'checked="checked"'; ?> type="checkbox" />
			<br /><small><?php _e('Check this box to hide the widget title and background.', 'leora') ?></small>
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('new_window'); ?>"><?php _e('Open in a new window:', 'leora') ?></label>
			<input id="<?php echo $this->get_field_id('new_window'); ?>" name="<?php echo $this->get_field_name('new_window'); ?>" value="true" <?php if (!empty($instance['new_window'])) echo 'checked="checked"'; ?> type="checkbox" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('nofollow'); ?>"><?php _e('nofollow', 'leora') ?></label>
			<input id="<?php echo $this->get_field_id('nofollow'); ?>" name="<?php echo $this->get_field_name('nofollow'); ?>" value="true" <?php if (!empty($instance['nofollow'])) echo 'checked="checked"'; ?> type="checkbox" />
		</p>
		<?php $i = 1 ?>
		<em style="display:block; border-bottom:1px solid #CCC; margin:20px 0 5px; font-weight:bold"><?php _e('Advertising:', 'leora') ?></em>
		<p>
			<label for="<?php echo $this->get_field_id('ads' . $i . '_img'); ?>"><?php _e('Promotional image path:', 'leora') ?></label>
			<input id="<?php echo $this->get_field_id('ads' . $i . '_img'); ?>" name="<?php echo $this->get_field_name('ads' . $i . '_img'); ?>" value="<?php if (!empty($instance['ads' . $i . '_img'])) echo $instance['ads' . $i . '_img']; ?>" class="widefat" type="text" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('ads' . $i . '_url'); ?>"><?php _e('Ad link:', 'leora') ?></label>
			<input id="<?php echo $this->get_field_id('ads' . $i . '_url'); ?>" name="<?php echo $this->get_field_name('ads' . $i . '_url'); ?>" value="<?php if (!empty($instance['ads' . $i . '_url'])) echo $instance['ads' . $i . '_url']; ?>" class="widefat" type="text" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('ads' . $i . '_code'); ?>"><?php _e('Ads Adsense code:', 'leora') ?></label>
			<textarea id="<?php echo $this->get_field_id('ads' . $i . '_code'); ?>" name="<?php echo $this->get_field_name('ads' . $i . '_code'); ?>" class="widefat"><?php if (!empty($instance['ads' . $i . '_code'])) echo $instance['ads' . $i . '_code']; ?></textarea>
		</p>
<?php
	}
}
