<?php

class My_Custom_Widget extends WP_Widget
{
	public function __construct()
	{
		parent::__construct(
			'my_custom_widget',
			__('Icon', 'leora'),
			array(
				'customize_selective_refresh' => true,
			)
		);
	}
	public function form($instance)
	{
		$defaults = array(
			'textarea' => '',
			'textarea1' => '',
			'select'   => '',
		);

		extract(wp_parse_args((array) $instance, $defaults)); ?>

		<?php // Textarea Field 
		?>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id('textarea')); ?>"><?php _e('Icon and img:', 'leora'); ?></label>
			<textarea class="widefat" id="<?php echo esc_attr($this->get_field_id('textarea')); ?>" name="<?php echo esc_attr($this->get_field_name('textarea')); ?>"><?php echo wp_kses_post($textarea); ?></textarea>
		</p>
		<?php // Textarea Field 
		?>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id('textarea1')); ?>"><?php _e('Text:', 'leora'); ?></label>
			<textarea class="widefat" id="<?php echo esc_attr($this->get_field_id('textarea1')); ?>" name="<?php echo esc_attr($this->get_field_name('textarea1')); ?>"><?php echo wp_kses_post($textarea1); ?></textarea>
		</p>

	<?php }
	public function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		$instance['textarea'] = isset($new_instance['textarea']) ? wp_kses_post($new_instance['textarea']) : '';
		$instance['textarea1'] = isset($new_instance['textarea1']) ? wp_kses_post($new_instance['textarea1']) : '';
		$instance['textarea'] = isset($new_instance['textarea']) ? wp_kses_post($new_instance['textarea']) : '';
		return $instance;
	}

	public function widget($args, $instance)
	{
		extract($args);
		$textarea1 = isset($instance['textarea1']) ? $instance['textarea1'] : '';
		$textarea = isset($instance['textarea']) ? $instance['textarea'] : '';
		// WordPress core before_widget hook (always include )
		echo $before_widget;
		echo '<div class="wo-product__feature-col"><a href="#" class="wo-product__feature-item">';
		// Display textarea field
		if ($textarea) {
			echo '<p class="sidshopp">' . $textarea . '</p>';
		}
		if ($textarea1) {
			echo '<span>' . $textarea1 . '</span>';
		}
		echo '</div></a>';
		echo $after_widget;
	}
}
// Register the widget
function my_register_custom_widget()
{
	register_widget('My_Custom_Widget');
}
add_action('widgets_init', 'my_register_custom_widget');



// ---------------------- Widgets Social Network ----------------------

class leora_widget_social extends WP_Widget
{

	function __construct()
	{
		parent::__construct(
			'leora_widget_social',
			__('Social Network', 'leora'),
			array('description' => __('برای انتخاب آیکون شبکه اجتماعی به پنل دنور مراجعه کنید.', 'leora'),)
		);
	}

	public function widget($args, $instance)
	{
		$title = apply_filters('widget_title', $instance['title']);

		echo $args['before_widget'];
		if (!empty($title))
			echo $args['before_title'] . $title . $args['after_title'];
		if (function_exists('ot_get_option')) {
			$social_media_channels = array(
				"facebook"      => "fab fa-facebook-f",
				"twitter"      => "fa-brands fa-x-twitter",
				"instagram"     => "fab fa-instagram",
				"google+"       => "fab fa-google-plus-g",
				"linkedin"      => "fab fa-linkedin-in",
				"pinterest"     => "fab fa-pinterest",
				"youtube"       => "fab fa-youtube",
				"dribbble"      => "fal fa-digging",
				"github"        => "fab fa-github",
				"forrst"        => "fal fa-tree",
				"digg"          => "fab fa-digg",
				"delicious"     => "fab fa-delicious",
				"tumblr"        => "fab fa-tumblr",
				"skype"         => "fab fa-skype",
				"soundCloud"    => "fab fa-soundcloud",
				"vimeo"         => "fab fa-vimeo-v",
				"flickr"        => "fab fa-flickr",
				"vk"        => "fab fa-vk",
				"telegram"      => "fab fa-telegram",
				"apple"         => "fab fa-apple",
				"android"       => "fab fa-android",
			);
			$social_media_icons = ot_get_option('social_links_shop');
		};
	?>
		<?php if ($social_media_icons) { ?>
			<ul class="social_footer_ul social_links_shop">
				<?php
				foreach ($social_media_icons as $key => $icon) {
					if ($social_media_channels[$icon['name']]) {
						echo "<li class='social-media-icon'><a target='_blank' href='" . $icon['href'] . "'><i class='" . $social_media_channels[$icon['name']] . "'></i></a></li>";
					}
				}
				?>
			</ul>
		<?php } ?>
		</div>
	<?php
		echo $args['after_widget'];
	}

	public function form($instance)
	{
		if (isset($instance['title'])) {
			$title = $instance['title'];
		} else {
			$title = __('New title', 'leora');
		}
	?>
		<p>
			<label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:', 'leora'); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
		</p>
<?php
	}

	public function update($new_instance, $old_instance)
	{
		$instance = array();
		$instance['title'] = (!empty($new_instance['title'])) ? strip_tags($new_instance['title']) : '';
		return $instance;
	}
}

function leora_load_widget()
{
	register_widget('leora_widget_social');
}
add_action('widgets_init', 'leora_load_widget');
