<div class="container">
    <section class="widget_box_ch_list box_ch_list_4 mb-3" style="padding:1rem;">
        <div class="row">
            <div class="col-12">
                <article class="article_list_posts list_posts_3">
                  <div class="col-12">
                    <h3 class="section-heading_3" style="background:unset;">
                        <?php echo $settings['title']; ?>
                    </h3>
                    </div>
                    <div class="listing_posts">
                        <ul>
                            <?php
                        $args = array();
                        $args['post_status'] = 'publish';
                        $args['ignore_sticky_posts'] = 1;
                        if (!empty($settings['grid_post_type']) && post_type_exists($settings['grid_post_type'])) {
                          $args['post_type'] = $settings['grid_post_type'];
                        }
                        if (!empty($settings['grid_post_categories']) && $settings['grid_post_type'] == 'post') {
                          $args['category_name'] = $settings['grid_post_categories'];
                        }
                        if (!empty($settings['grid_product_categories']) && $settings['grid_post_type'] == 'product') {
                          $args['tax_query'] = array(
                            'relation' => 'AND',
                            array(
                              'taxonomy' => 'product_cat',
                              'field' => 'slug',
                              'terms' => $settings['grid_product_categories'],
                            ),
                          );
                        }
                        if (!empty($settings['grid_items']) && intval($settings['grid_items']) == $settings['grid_items']) {
                          $args['posts_per_page'] = $settings['grid_items'];
                        }
                        if (!empty($settings['grid_order_by'])) {
                          $args['orderby'] = $settings['grid_order_by'];
                        }
                        if (!empty($settings['grid_pagination'])) {
                          $paged         = get_query_var('paged');
                          if (empty($paged)) {
                            $paged         = get_query_var('page');
                          }
                          $args['paged'] = $paged;
                        }
                        $query = new \WP_Query($args);
                        if ($query->have_posts()):

                          while ($query->have_posts()):
                            $query->the_post();
                            $thumb = wp_get_attachment_image_src(get_post_thumbnail_id(), 'medium_large');
                ?>
                            <li class="col-12 col-sm-6 col-md-4">
                                <div class="featured">
                                    <div class="card__overload--author">
                                        نوشته شده توسط <?php the_author(); ?>
                                        <?php echo human_time_diff( get_the_time('U'), current_time('timestamp') ) . ' پیش'; ?>

                                    </div>

                                    <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"
                                        style="background-image: url('<?php echo $thumb['0']; ?>');">
                                    </a>
                                </div>
                                <h3 class="title">
                                    <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                </h3>
                                <div class="post-meta">
                                    <span class="time">
                                        <?php do_action('type_article'); echo human_time_diff(get_the_time('U'), current_time('timestamp')) . ' پیش'; ?>
                                    </span>
                                </div>
                            </li>
                            <?php endwhile; endif; ?>
                        </ul>
                    </div>
                </article>
            </div>
        </div>
    </section>
</div>