<?php

/**
 * Image box
 *
 */

use \Elementor\Group_Control_Image_Size;

if (!defined('ABSPATH')) {
	exit;
}

class Background_Image_Written extends \Elementor\Widget_Base
{

	public function get_name()
	{
		return 'image-boxx';
	}

	public function get_title()
	{
		return __('image box', 'leora');
	}

	public function get_icon()
	{
		return 'eicon-image-hotspot';
	}

    public function get_categories()
    {
        return ['elementor-widget-be'];
    }

	    protected function register_controls()
    {
        $this->init_content_general_controls();
    }

    protected function init_content_general_controls()
	{
		$this->start_controls_section(
			'general_section',
			[
				'label' => __('General', 'leora'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'grid_style',
			[
				'label' => __('Grid Style', 'leora'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '1',
				'options' => [
					'1' => esc_html__('Layout 1', 'leora'),
					'2' => esc_html__('Layout 2', 'leora'),
				],
			]
		);
		$this->add_control(
			'bg_image',
			[
			  'label' => __( 'Choose Image', 'leora' ),
			  'type' => \Elementor\Controls_Manager::MEDIA,
			  'dynamic' => [
				'active' => true,
			  ],
			  'default' => [
				'url' => \Elementor\Utils::get_placeholder_image_src(),
			  ],
			  'condition' => [
				'grid_style' => '2',
			]
			]
		  );
		  $this->add_group_control(
			\Elementor\Group_Control_Image_Size::get_type(),
			[
			  'name' => 'bg_image', // Actually its `image_size`
			  'label' => __( 'Image Resolution', 'leora' ),
			  'default' => 'large',
			  'condition' => [
				'bg_image[id]!' => '',
			  ],
			  'separator' => 'none',
			  'condition' => [
				'grid_style' => '2',
			  ],
			]
	   
		  );
		$this->end_controls_section();
		$this->start_controls_section(
			'content_section',
			[
				'label' => __('Content', 'leora'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				'condition' => [
                    'grid_style' => '1',
                ]
			]
		);
		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'list_title',
			[
				'label' => __('Title', 'leora'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __('List Title', 'leora'),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'image',
			[
				'label' => __('Choose Image slider', 'leora'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$repeater->add_group_control(
			\Elementor\Group_Control_Image_Size::get_type(),
			[
				'name' => 'thumbnail', // Usage: `{name}_size` and `{name}_custom_dimension`, in this case `thumbnail_size` and `thumbnail_custom_dimension`.
				'default' => 'full',
				'separator' => 'none',
			]
		);
		$repeater->add_control(
			'website_link',
			[
				'label' => __('Link', 'leora'),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __('https://your-link.com', 'leora'),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
		);
		$this->add_control(
			'list',
			[
				'label' => __('Repeater List', 'leora'),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'list_title' => __('Title #1', 'leora'),
						'list_content' => __('Item content. Click the edit button to change this text.', 'leora'),
					],
					[
						'list_title' => __('Title #2', 'leora'),
						'list_content' => __('Item content. Click the edit button to change this text.', 'leora'),
					],
				],
				'title_field' => '{{{ list_title }}}',
			]
		);
		$this->end_controls_section();
	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		$grid_style = $settings['grid_style'];
		if (1 == $grid_style) {

			include(__DIR__ . '/Image/layout-1.php');
		} elseif (2 == $grid_style) {
			if ( ! empty( $settings['bg_image']['id'] ) ) {
				$bg_image = \Elementor\Group_Control_Image_Size::get_attachment_image_src( $settings['bg_image']['id'], 'bg_image', $settings );
			  } elseif ( ! empty( $settings['bg_image']['url'] ) ) {
				$bg_image = $settings['bg_image']['url'];
			}
			$this->add_render_attribute( 'background_image', 'style', [
				'background-image: url(' . $bg_image . ');',
			] );
			include(__DIR__ . '/Image/layout-2.php');
		}
	}
}
