<?php

/**
 * Elementor Header Box Widget.
 *
 */

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Scheme_Typography;
use Elementor\Core\Schemes\Color;
use Elementor\Group_Control_Image_Size;


class Header_Box extends \Elementor\Widget_Base
{

  public function get_name()
  {
    return 'header-box';
  }

  public function get_title()
  {
    return __('Header Box', 'leora');
  }

  public function get_icon()
  {
    return 'eicon-inner-section';
  }

  public function get_categories()
  {
    return ['elementor-widget-be'];
  }

  private function wpcap_get_all_post_categories($post_type)
  {

    $options = array();

    $taxonomy = 'category';

    if (!empty($taxonomy)) {
      // Get categories for post type.
      $terms = get_terms(
        array(
          'taxonomy'   => $taxonomy,
          'hide_empty' => false,
        )
      );
      if (!empty($terms)) {
        foreach ($terms as $term) {
          if (isset($term)) {
            if (isset($term->slug) && isset($term->name)) {
              $options[$term->slug] = $term->name;
            }
          }
        }
      }
    }

    return $options;
  }

  private function grid_get_all_post_types()
  {
    $options = array();
    $exclude = array('attachment', 'elementor_widget_be'); // excluded post types

    $args = array(
      'public' => true,
    );

    foreach (get_post_types($args, 'objects') as $post_type) {

      if (!isset($post_type->name)) {
        continue;
      }

      if (!isset($post_type->label)) {
        continue;
      }

      if (in_array($post_type->name, $exclude) === true) {
        continue;
      }

      $options[$post_type->name] = $post_type->label;
    }

    return $options;
  }

      protected function register_controls()
    {
        $this->init_content_general_controls();
    }

    protected function init_content_general_controls()
  {
    $this->start_controls_section(
      'section_layout',
      [
        'label' => esc_html__('Layout', 'leora'),
      ]
    );
    $this->add_control(
      'grid_style',
      [
        'label' => __('Grid Style', 'leora'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => '1',
        'options' => [
          '1' => esc_html__('Layout 1', 'leora'),
          '2' => esc_html__('Layout 2', 'leora'),
          '3' => esc_html__('Layout 3', 'leora'),
          '4' => esc_html__('Layout 4', 'leora'),
          '5' => esc_html__('Layout 5', 'leora'),
          '6' => esc_html__('Layout 6', 'leora'),
          '7' => esc_html__('Layout 7', 'leora'),
          '8' => esc_html__('Layout 8', 'leora'),
          '9' => esc_html__('Layout 9', 'leora'),
          '10' => esc_html__('Layout 10', 'leora'),
          '11' => esc_html__('Layout 11', 'leora'),
          '12' => esc_html__('Layout 12', 'leora'),
          '13' => esc_html__('Layout 13', 'leora'),
          '14' => esc_html__('Layout 14', 'leora'),
          '15' => esc_html__('Layout 15', 'leora'),
          '16' => esc_html__('Layout 16', 'leora'),
          '17' => esc_html__('Layout 17', 'leora'),
        ],
      ]
    );
    $this->add_control(
      'title', 
      [
        'label' => __('Title', 'leora'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'grid_style' => [ '1', '3', '5', '8' ,'11'],
        ]
      ]
    );
    $this->add_control(
      'title_more',
      [
        'label' => __('Title More', 'leora'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'grid_style' => [ '1', '3', '5', '8' , '11'],
        ]
      ]
    );
		$this->add_control(
			'title_self',
			[
				'label' => __('title self', 'leora'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => 'تــــخــــفـــــیــــف تـــا',
        'condition' => [
          'grid_style' => ['11'],
        ]
			]
		);
    $this->add_control(
      'meta_data',
      [
        'label' => __('Meta Data', 'leora'),
        'label_block' => true,
        'type' => \Elementor\Controls_Manager::SELECT2,
        'default' => ['date', 'comments'],
        'multiple' => true,
        'options' => [
          'author' => __('Author', 'leora'),
          'date' => __('Date', 'leora'),
          'categories' => __('Categories', 'leora'),
          'comments' => __('Comments', 'leora'),
        ],
        'separator' => 'before',
      ]
    );

    $this->add_control(
      'meta_separator',
      [
        'label' => __('Separator Between', 'leora'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '/',
        'selectors' => [
          '{{WRAPPER}} .wpcap-grid-container .wpcap-post .post-grid-meta span + span:before' => 'content: "{{VALUE}}"',
        ],
        'condition' => [
          'meta_data!' => [],
        ],
      ]
    );
    $this->add_control(
      'posts_per_page',
      [
        'label' => __('Posts Per Page', 'leora'),
        'type' => \Elementor\Controls_Manager::NUMBER,
        'default' => 5,
      ]
    );
    // Post categories
    $this->add_control(
      'post_categories',
      [
        'label'       => __('Categories', 'leora'),
        'label_block' => true,
        'type'        => \Elementor\Controls_Manager::SELECT2,
        'multiple'    => true,
        'options'     => $this->wpcap_get_all_post_categories('post'),

      ]
    );

    $this->add_control(
      'advanced',
      [
        'label' => __('Advanced', 'leora'),
        'type' => \Elementor\Controls_Manager::HEADING,
      ]
    );

    $this->add_control(
      'orderby',
      [
        'label' => __('Order By', 'leora'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'post_date',
        'options' => [
          'post_date' => __('Date', 'leora'),
          'post_title' => __('Title', 'leora'),
          'rand' => __('Random', 'leora'),
        ],
      ]
    );

    $this->add_control(
      'order',
      [
        'label' => __('Order', 'leora'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'desc',
        'options' => [
          'asc' => __('ASC', 'leora'),
          'desc' => __('DESC', 'leora'),
        ],
      ]
    );
    $this->add_control(
      'show_more',
      [
        'label' => __('Show more', 'leora'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => __('Show', 'leora'),
        'label_off' => __('Hide', 'leora'),
        'return_value' => 'yes',
        'default' => 'yes',
      ]
    );
    $this->add_control(
      'show_more_icon',
      [
        'label' => __('Show Icon', 'leora'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => __('Show', 'leora'),
        'label_off' => __('Hide', 'leora'),
        'return_value' => 'yes',
        'default' => 'yes',
      ]
    );
    $this->add_control(
      'show_more_specifications',
      [
        'label' => __('Show Specifications', 'leora'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => __('Show', 'leora'),
        'label_off' => __('Hide', 'leora'),
        'return_value' => 'yes',
        'default' => 'yes',
      ]
    );
    $this->add_control(
      'show_more_categories',
      [
        'label' => __('Show Categories', 'leora'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => __('Show', 'leora'),
        'label_off' => __('Hide', 'leora'),
        'return_value' => 'yes',
        'default' => 'yes',
      ]
    );
    $this->add_control(
      'website_link',
      [
        'label' => __('Link More', 'leora'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('https://your-link.com', 'leora'),
        'show_external' => true,
        'default' => [
          'url' => '',
          'is_external' => true,
          'nofollow' => true,
        ],
      ]
    );
    $this->add_control(
      'layout_image_11',
      [
        'label' => __('Choose Image', 'leora'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'dynamic' => [
          'active' => true,
        ],
        'condition' => [
          'grid_style' => '11',
        ]
      ]
    );
    $this->add_control(
			'layout_content',
			[
				'label' => esc_html__( 'Description', 'leora' ),
				'type' => \Elementor\Controls_Manager::WYSIWYG,
				'default' => esc_html__( 'Default description', 'leora' ),
				'placeholder' => esc_html__( 'Type your description here', 'leora' ),
				'condition' => [
					'grid_style' => ['11'],
				],
			]
		);
    $this->end_controls_section();

    $this->start_controls_section(
      'layout_2',
      [
        'label' => esc_html__('Layout 2', 'leora'),
        'condition' => [
          'grid_style' => '2',
        ]
      ]
    );
    $this->add_control(
      'titlelayout_2',
      [
        'label' => __('Title', 'leora'),
        'type' => \Elementor\Controls_Manager::TEXT,
      ]
    );
    $this->add_control(
      'title2layout_2',
      [
        'label' => __('Title two', 'leora'),
        'type' => \Elementor\Controls_Manager::TEXT,
      ]
    );
    $this->add_control(
      'titlelayouttree',
      [
        'label' => __('Title three', 'leora'),
        'type' => \Elementor\Controls_Manager::TEXT,
      ]
    );
    $this->add_control(
      'bg_image',
      [
        'label' => __('Choose Image', 'leora'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'dynamic' => [
          'active' => true,
        ],
        'default' => [],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Image_Size::get_type(),
      [
        'name' => 'bg_image',
        'label' => __('Image Resolution', 'leora'),
        'default' => 'large',
        'condition' => [
          'bg_image[id]!' => '',
        ],
        'separator' => 'none',
      ]
    );

    $this->add_control(
      'show_image',
      [
        'label' => __('Image', 'leora'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => __('Show', 'leora'),
        'label_off' => __('Hide', 'leora'),
        'default' => 'yes',
        'separator' => 'before',
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Image_Size::get_type(),
      [
        'name' => 'post_thumbnail',
        'exclude' => ['custom'],
        'default' => 'full',
        'prefix_class' => 'post-thumbnail-size-',
        'condition' => [
          'show_image' => 'yes',
        ],
      ]
    );
    $this->end_controls_section();
    $repeater = new \Elementor\Repeater();
    $this->start_controls_section(
      'layout_4',
      [
        'label' => __('Layout 4', 'leora'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
          'grid_style' => '4',
        ]
      ]
    );
    $repeater->add_control(
      'list_title',
      [
        'label' => __('Title', 'leora'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('List Title', 'leora'),
        'label_block' => true,
      ]
    );

    $repeater->add_control(
      'icon_menu',
      [
        'label' => __('Icon', 'leora'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
          'value' => 'fas fa-star',
          'library' => 'solid',
        ],
      ]
    );
    $repeater->add_control(
      'link_menu_item',
      [
        'label' => __('Link menu', 'leora'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('https://your-link.com', 'leora'),
        'show_external' => true,
        'default' => [
          'url' => '',
          'is_external' => true,
          'nofollow' => true,
        ],
      ]
    );
    $repeater->add_control(
      'list_color_hover',
      [
        'label' => __('Color hover', 'leora'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} {{CURRENT_ITEM}}' => 'color: {{VALUE}}'
        ],
      ]
    );
    $repeater->add_control(
      'list_color',
      [
        'label' => __('Color item', 'leora'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#6b7074',
        
        'selectors' => [
          '{{WRAPPER}} .title' => 'color: {{VALUE}}',
        ],
      ]
    );

    $this->add_control(
      'list',
      [
        'label' => __('Repeater List', 'leora'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'list_title' => __('Title #1', 'leora'),
            'list_content' => __('Item content. Click the edit button to change this text.', 'leora'),
          ],
          [
            'list_title' => __('Title #2', 'leora'),
            'list_content' => __('Item content. Click the edit button to change this text.', 'leora'),
          ],
        ],
        'title_field' => '{{{ list_title }}}',
      ]
    );
    $this->end_controls_section();

    $this->start_controls_section(
      'advertising',
      [
        'label' => __('Advertising', 'leora'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
          'grid_style' => [ '4', '7', '10' ],
        ]
      ]
    );
    $this->add_control(
      'image_baneer',
      [
        'label' => __('Choose Image baneer', 'leora'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
          'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
        'condition' => [
          'grid_style' => [ '7', '4'],
        ]
      ]
    );
    $this->add_control(
      'link_image_baneer',
      [
        'label' => __('Link Image baneer', 'leora'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('https://your-link.com', 'leora'),
        'show_external' => true,
        'default' => [
          'url' => '',
          'is_external' => true,
          'nofollow' => true,
        ],
        'condition' => [
          'grid_style' => [ '7', '4' ],
        ]
      ]
    );
    $this->add_control(
      'image_sid',
      [
        'label' => __('Choose Image sidbar', 'leora'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
          'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
        'condition' => [
          'grid_style' => [ '4', '7' ],
        ]
      ]
    );
    $this->add_control(
      'link_image_sid',
      [
        'label' => __('Link Image sidbar', 'leora'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('https://your-link.com', 'leora'),
        'show_external' => true,
        'default' => [
          'url' => '',
          'is_external' => true,
          'nofollow' => true,
        ],
        'condition' => [
          'grid_style' => [ '4', '7' ],
        ]
      ]
    );
    $this->add_control(
      'image_sid_2',
      [
        'label' => __('Choose Image sidbarss', 'leora'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
          'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
        'condition' => [
          'grid_style' => ['7','10'],
        ]
      ]
    );
    $this->add_control(
      'link_image_sid_2',
      [
        'label' => __('Link Image sidbarss', 'leora'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('https://your-link.com', 'leora'),
        'show_external' => true,
        'default' => [
          'url' => '',
          'is_external' => true,
          'nofollow' => true,
        ],
        'condition' => [
          'grid_style' => ['7','10'],
        ]
      ]
    );
    $this->add_control(
      'image_sid_3',
      [
        'label' => __('Choose Image sidbar', 'leora'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
          'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
        'condition' => [
          'grid_style' => '10',
        ]
      ]
    );
    $this->add_control(
      'link_image_sid_3',
      [
        'label' => __('Link Image sidbar', 'leora'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('https://your-link.com', 'leora'),
        'show_external' => true,
        'default' => [
          'url' => '',
          'is_external' => true,
          'nofollow' => true,
        ],
        'condition' => [
          'grid_style' => '10',
        ]
      ]
    );
    $this->add_control(
      'image_sid_4',
      [
        'label' => __('Choose Image sidbar', 'leora'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
          'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
        'condition' => [
          'grid_style' => '10',
        ]
      ]
    );
    $this->add_control(
      'link_image_sid_4',
      [
        'label' => __('Link Image sidbar', 'leora'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('https://your-link.com', 'leora'),
        'show_external' => true,
        'default' => [
          'url' => '',
          'is_external' => true,
          'nofollow' => true,
        ],
        'condition' => [
          'grid_style' => '10',
        ]
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'style_section_1',
      [
        'label' => __('General', 'leora'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'title_color_1one',
      [
        'label' => __('Color author', 'leora'),
        'type' => \Elementor\Controls_Manager::COLOR,
        
        'selectors' => [
          '{{WRAPPER}} .layout-17 .article_post2 article .daymonthyear' => 'color: {{VALUE}}',
          '{{WRAPPER}} .article_post2 article .daymonthyear' => 'color: {{VALUE}}',
          '{{WRAPPER}} .backhad-layout-4 .card__overload--title,.backhad-layout-4 .card__overload--author,.backhad-layout-4 .card__overload--date,.backhad-layout-4 .article__excerpt' => 'color: {{VALUE}}',
          '{{WRAPPER}} .backhad-layout-4 .card__overload--author::afte' => 'background-color: {{VALUE}}',
        ],
        'default' => '#eee',
        'condition' => [
          'grid_style' => ['1', '4','16','17'],
        ]
      ]
    );
    $this->add_control(
      'title_color_2112',
      [
        'label' => __('background author', 'leora'),
        'type' => \Elementor\Controls_Manager::COLOR,
        
        'selectors' => [
          '{{WRAPPER}} .backhad-layout-4' => 'background: {{VALUE}}',
          '{{WRAPPER}} .backhad-layout-4 .had_img::before' => 'background:linear-gradient(-90deg,rgba(0,0,0,0) .35%,{{VALUE}} 90.68%)',
          '{{WRAPPER}} .backhad-layout-4 .had_img::after' => 'background:linear-gradient(90deg,rgba(0,0,0,0) .35%, {{VALUE}} 63.68%)',
        ],
        'default' => '#38E445',
        'condition' => [
          'grid_style' => ['1', '4'],
        ]
      ]
    );
    $this->add_control(
      'back_title_Color',
      [
        'label' => __('title', 'leora'),
        'type' => \Elementor\Controls_Manager::COLOR,
        
        'selectors' => [
          '{{WRAPPER}} .item-2-column.SixBigBox h3.mrg15B.pad15R a' => 'color: {{VALUE}}',
        ],
        'default' => '#6b7074',
        'condition' => [
          'grid_style' => ['8'],
        ]
      ]
    );
    $this->add_control(
      'background_Color_et',
      [
        'label' => __('background Color', 'leora'),
        'type' => \Elementor\Controls_Manager::COLOR,
        
        'selectors' => [
          '{{WRAPPER}} .layout-17 .article_post2 article' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .layout-16 .article_post2 article' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .layout-15 .cdsaghs' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .layout-14 .cdsaghs' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .layout-11 .cdsaghs' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .SolidRight6Left' => 'background-color: {{VALUE}}',
        ],
        'default' => '#e51a2d',
        'condition' => [
          'grid_style' => ['8','11','14','15','16','17'],
        ]
      ]
    );
    $this->add_control(
      'background_et_Color',
      [
        'label' => __('text', 'leora'),
        'type' => \Elementor\Controls_Manager::COLOR,
        
        'selectors' => [
          '{{WRAPPER}} .layout-17 .article_post2 article h2' => 'color: {{VALUE}}',
          '{{WRAPPER}} .layout-16 .article_post2 article h2' => 'color: {{VALUE}}',
          '{{WRAPPER}} .SolidRight6Left a,.SolidRight6Left i,.footerSection span' => 'color: {{VALUE}}',
          '{{WRAPPER}} .SolidRight6Left .footerSection,.SolidRight6Left i' => 'border-color: {{VALUE}}',
        ],
        'default' => '#fff',
        'condition' => [
          'grid_style' => ['8','16','17'],
        ]
      ]
    );
    $this->add_control(
      'back_border_Color',
      [
        'label' => __('border', 'leora'),
        'type' => \Elementor\Controls_Manager::COLOR,
        
        'selectors' => [
          '{{WRAPPER}} .layout-17 .article_post2 article' => 'border-color: {{VALUE}}',
          '{{WRAPPER}} .layout-16 .article_post2 article' => 'border-color: {{VALUE}}',
        ],
        'default' => '#fff',
        'condition' => [
          'grid_style' => ['16','17'],
        ]
      ]
    );
    $this->add_control(
      'border_radius_head_box',
      [
        'label' => __( 'border radius', 'leora' ),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => [ 'px', '%' ],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 100,
            'step' => 1,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 5,
        ],
        'selectors' => [
          '{{WRAPPER}} .layout-17 .article_post2 article' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
          '{{WRAPPER}} .layout-16 .article_post2 article' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
          '{{WRAPPER}} .layout-15 .widget_box_ch_list .listing_posts .featured a' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
          '{{WRAPPER}} .layout-14 .widget_box_ch_list .listing_posts .featured a' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
          '{{WRAPPER}} .layout-13 .cardSuggestions' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
          '{{WRAPPER}} .layout-11 .card-sm' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
          '{{WRAPPER}} .layout-10 .cardSuggestions,.layout-10 .ad-wrapper a' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
          '{{WRAPPER}} .home-vid .cardSuggestions,.row-no-padding.grid-banner,.video-hero.biggest,.sectionshowcase' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
          '{{WRAPPER}} .showCaseContainer,.showcasesection .bannercontainer div.banner,.bannercontainer img,.SolidRight6Left,.item-6box .bg-white.item-list-box' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
          '{{WRAPPER}} #home-top-banner-sidebar img,.home-menu-bottom-widget img' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
        ],
        'condition' => [
          'grid_style!' => ['2','4'],
        ]
      ]
    );
    $this->add_control(
			'border_radius_2',
			[
				'label' => esc_html__( 'border radius', 'leora' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .article-list li:first-child' => 'border-top-left-radius:  {{RIGHT}}{{UNIT}}!important;',
          '{{WRAPPER}} .article-list li:last-child' => 'border-bottom-left-radius:  {{LEFT}}{{UNIT}}!important;',
          '{{WRAPPER}} .landing-overlay .half-gut .guttered figure' => 'border-top-right-radius:  {{TOP}}{{UNIT}}!important;',
          '{{WRAPPER}} .landing-overlay .guttered figure' => 'border-bottom-right-radius:  {{BOTTOM}}{{UNIT}}!important;',
				],
        'condition' => [
          'grid_style' => ['2'],
        ]
			]
		);
    $this->add_control(
      'background_Color_vid',
      [
        'label' => __('background Color', 'leora'),
        'type' => \Elementor\Controls_Manager::COLOR,
        
        'selectors' => [
          '{{WRAPPER}} .nini_headr_box.layout-10' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .home-vid.flex.landing-hero,.vc-wrapper,.header-Wrapper,.wpcap-grid-container .landing-hero' => 'background-color: {{VALUE}}',
        ],
        'default' => '#4D4E4E',
        'condition' => [
          'grid_style' => ['3', '5', '7','9','10','2'],
        ]
      ]
    );
    $this->add_control(
      'Iconlayoutvid',
      [
        'label' => __('Icon', 'leora'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
          'value' => 'fas fa-star',
          'library' => 'solid',
        ],
        'condition' => [
          'grid_style' => ['3', '5','10','13'],
        ]
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'widget_header',
      [
        'label' => __('header', 'leora'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        'condition' => [
          'grid_style' => ['1','3','5'],
        ]
      ]
    );
    $this->add_control(
      'box_title',
      [
        'label' => __('title', 'leora'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#535353',
        
        'selectors' => [
          '{{WRAPPER}} .layout-1 .Survey-title,.layout-3 .Survey-title,.layout-5 .Survey-title' => 'color: {{VALUE}}!important;',
        ],
      ]
    );
    $this->add_control(
      'box_title_more',
      [
        'label' => __('Title More', 'leora'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#fff',
        
        'selectors' => [
          '{{WRAPPER}} .layout-1 .Survey-bt-mor,.layout-3 .Survey-bt-mor,.layout-5 .Survey-bt-mor' => 'background-color: {{VALUE}}!important;',
        ],
      ]
    );
    $this->add_control(
      'box_title_more_text',
      [
        'label' => __('Title More text', 'leora'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#535353',
        
        'selectors' => [
          '{{WRAPPER}} .layout-1 .Survey-bt-mor,.layout-3 .Survey-bt-mor,.layout-5 .Survey-bt-mor' => 'color: {{VALUE}}!important;',
        ],
      ]
    );
     $this->add_control(
      'border_radius_headmore',
      [
        'label' => __( 'border radius', 'leora' ),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => [ 'px', '%' ],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 100,
            'step' => 1,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 35,
        ],
        'selectors' => [
         '{{WRAPPER}} .layout-1 .Survey-bt-mor,.layout-3 .Survey-bt-mor,.layout-5 .Survey-bt-mor' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
       ],
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'style_section_2',
      [
        'label' => __('style', 'leora'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        'condition' => [
          'grid_style' => ['2','6','3','5','10','11','12','13','14','15'],
        ]
      ]
    );
    $this->add_control(
      'title_color_11',
      [
        'label' => __('title Color one', 'leora'),
        'type' => \Elementor\Controls_Manager::COLOR,
        
        'selectors' => [
          '{{WRAPPER}} .layout-15 .widget_box_ch_list .listing_posts .post-meta span,.layout-15 .widget_box_ch_list .listing_posts h3 a,.layout-15 .details,.layout-15 .card-heder14 h3 a,.layout-15 .card-heder14 .card_text' => 'color: {{VALUE}}',
          '{{WRAPPER}} .layout-14 .widget_box_ch_list .listing_posts .post-meta span,.layout-14 .widget_box_ch_list .listing_posts h3 a,.layout-14 .details,.layout-14 .card-heder14 h3 a,.layout-14 .card-heder14 .card_text' => 'color: {{VALUE}}',
          '{{WRAPPER}} .layout-13 .card__bookmark' => 'color: {{VALUE}}',
          '{{WRAPPER}} .layout-12 .card__bookmark' => 'color: {{VALUE}}',
          '{{WRAPPER}} .layout-11 .card-lg__container .card__text-sm' => 'color: {{VALUE}}',
          '{{WRAPPER}} .layout-11 .card-lg__container .card__text-lg' => 'color: {{VALUE}}',
          '{{WRAPPER}} .layout-10 .card__bookmark' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .layout-3 .card__bookmark' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .layout-5 .card__bookmark' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .box-had-layout-6 .card__bookmark' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'title_color_21',
      [
        'label' => __('title Color two and three', 'leora'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#212121',
        
        'selectors' => [
          '{{WRAPPER}} .layout-13 .card__bookmark' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .layout-12 .card__bookmark' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .layout-11 .card__btn' => 'border-color: {{VALUE}}',
          '{{WRAPPER}} .layout-11 .card__btn' => 'color: {{VALUE}}',
          '{{WRAPPER}} .layout-10 .card__btn' => 'color: {{VALUE}}',
          '{{WRAPPER}} .layout-3 .card__bookmark' => 'color: {{VALUE}}',
          '{{WRAPPER}} .layout-5 .card__bookmark' => 'color: {{VALUE}}',
          '{{WRAPPER}} .box-had-layout-6 .card__bookmark' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'background_color_category',
      [
        'label' => __('background Color category', 'leora'),
        'type' => \Elementor\Controls_Manager::COLOR,
        
        'selectors' => [
          '{{WRAPPER}} .layout-13 .card__overload--category' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .layout-12 .card__overload--category' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .layout-10 .card__overload--category' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .layout-5 .card__overload--category' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .layout-3 .card__overload--category' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .layout-2 .card__overload--category' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .box-had-layout-6 .card__overload--category' => 'background-color: {{VALUE}}',
        ],
        'condition' => [
          'grid_style!' => ['11'],
        ],
        'default' => '#16205b',
      ]
    );
    $this->add_control(
      'title_color_category',
      [
        'label' => __('title Color category', 'leora'),
        'type' => \Elementor\Controls_Manager::COLOR,
        
        'selectors' => [
          '{{WRAPPER}} .layout-13 .card__overload--category' => 'color: {{VALUE}}',
          '{{WRAPPER}} .layout-12 .card__overload--category' => 'color: {{VALUE}}',
          '{{WRAPPER}} .layout-10 .card__overload--category' => 'color: {{VALUE}}',
          '{{WRAPPER}} .layout-5 .card__overload--category' => 'color: {{VALUE}}',
          '{{WRAPPER}} .layout-3 .card__overload--category' => 'color: {{VALUE}}',
          '{{WRAPPER}} .layout-2 .card__overload--category' => 'color: {{VALUE}}',
          '{{WRAPPER}} .box-had-layout-6 .card__overload--category' => 'color: {{VALUE}}',
        ],
        'condition' => [
          'grid_style!' => ['11'],
        ],
        'default' => '#fff',
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'style_section_4',
      [
        'label' => __('checkbox', 'leora'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        'condition' => [
          'grid_style' => ['1', '9'],
        ]
      ]
    );
    $this->add_control(
      'show_views',
      [
        'label' => __('Show views', 'leora'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => __('Show', 'leora'),
        'label_off' => __('Hide', 'leora'),
        'return_value' => 'yes',
        'default' => 'yes',
      ]
    );
    $this->add_control(
      'show_author',
      [
        'label' => __('Show author', 'leora'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => __('Show', 'leora'),
        'label_off' => __('Hide', 'leora'),
        'return_value' => 'yes',
        'default' => 'yes',
      ]
    );
    $this->end_controls_section();
  }
  protected function render()
  {
    $settings = $this->get_settings_for_display();

    $bg_image = '';
    if (!empty($settings['bg_image']['id'])) {
      $bg_image = \Elementor\Group_Control_Image_Size::get_attachment_image_src($settings['bg_image']['id'], 'bg_image', $settings);
    } elseif (!empty($settings['bg_image']['url'])) {
      $bg_image = $settings['bg_image']['url'];
    }
    if (empty($bg_image) && 'classic' == $settings) {
      $print_bg = false;
    }
    if (!empty($bg_image)) {
      $this->add_render_attribute('background_image', 'style', [
        'background-image: url(' . $bg_image . ');',
      ]);
    }
    $settings = $this->get_settings();
    if (!empty($settings['grid_pagination'])) {
      $paged         = get_query_var('paged');
      if (empty($paged)) {
        $paged         = get_query_var('page');
      }
      $args['paged'] = $paged;
    }
    if (empty($settings['title']) && empty($settings['description']) && empty($settings['button']) && 'none' == $settings) {
      $print_content = false;
    }
    $grid_style = $settings['grid_style'];

    $posts_per_page = (!empty($settings['posts_per_page']) ?  $settings['posts_per_page'] : 3);
    $cats = is_array($settings['post_categories']) ? implode(',', $settings['post_categories']) : $settings['post_categories'];
    $query_args = array(
      'posts_per_page'     => absint($posts_per_page),
      'no_found_rows'      => true,
      'post__not_in'          => get_option('sticky_posts'),
      'ignore_sticky_posts'   => true,
      'category_name'     => $cats
    );
    // Order by.
    if (!empty($settings['orderby'])) {
      $query_args['orderby'] = $settings['orderby'];
    }
    // Order .
    if (!empty($settings['order'])) {
      $query_args['order'] = $settings['order'];
    }
    $all_posts = new \WP_Query($query_args);

    if ($all_posts->have_posts()) :
      $settings['title_color_21'] = $settings['title_color_21'] ?? '#212121';
      $settings['title_color_11'] = $settings['title_color_11'] ?? '#212121';
      $settings['box_title'] = $settings['box_title'] ?? '#535353';
      $settings['website_link'] = $settings['website_link'] ?? '#';
      $settings['title_more'] = $settings['title_more'] ?? 'بیشتر';
      if (17 == $grid_style) {

        include(__DIR__ . '/layouts/layout-17.php');
      } elseif (16 == $grid_style) {

        include(__DIR__ . '/layouts/layout-16.php');
      }  elseif (15 == $grid_style) {

        include(__DIR__ . '/layouts/layout-15.php');
      } elseif (14 == $grid_style) {

        include(__DIR__ . '/layouts/layout-14.php');
      } elseif (13 == $grid_style) {

        include(__DIR__ . '/layouts/layout-13.php');
      } elseif (12 == $grid_style) {

        include(__DIR__ . '/layouts/layout-12.php');
      } elseif (11 == $grid_style) {

        include(__DIR__ . '/layouts/layout-11.php');
      } elseif (10 == $grid_style) {

        include(__DIR__ . '/layouts/layout-10.php');
      } elseif (9 == $grid_style) {

        include(__DIR__ . '/layouts/layout-9.php');
      } elseif (8 == $grid_style) {

        include(__DIR__ . '/layouts/layout-8.php');
      } elseif (7 == $grid_style) {

        include(__DIR__ . '/layouts/layout-7.php');
      } elseif (6 == $grid_style) {

        include(__DIR__ . '/layouts/layout-6.php');
      } elseif (5 == $grid_style) {

        include(__DIR__ . '/layouts/layout-5.php');
      } elseif (4 == $grid_style) {

        include(__DIR__ . '/layouts/layout-4.php');
      } elseif (3 == $grid_style) {

        include(__DIR__ . '/layouts/layout-3.php');
      } elseif (2 == $grid_style) {

        include(__DIR__ . '/layouts/layout-2.php');
      } elseif (1 == $grid_style) {

        include(__DIR__ . '/layouts/layout-1.php');
      }
      wp_reset_postdata();
    endif;
  }

  protected function render_meta()
  {
    $settings = $this->get_settings();
    $meta_data = $settings['meta_data'];
    if (empty($meta_data)) {
      return;
    }
?>
    <div class="post-grid-meta">
      <?php
      if (in_array('date', $meta_data)) { ?>
        <span class="post-author"><?php do_action('type_article'); echo apply_filters('the_date', get_the_date(), get_option('date_format'), '', ''); ?></span>
      <?php
      }

      if (in_array('categories', $meta_data)) {
        $categories_list = get_the_category_list(esc_html__(', ', 'leora'));

        if ($categories_list) {
          printf('<span class="post-categories">%s</span>', $categories_list); // WPCS: XSS OK.
        }
      }

      if (in_array('comments', $meta_data)) { ?>
        <span class="post-comments"><?php comments_number(); ?></span>

      <?php
      }
      ?>
    </div>
    <?php

  }
  protected function render_thumbnail()
  {

    $settings = $this->get_settings();

    $show_image = $settings['show_image'];

    if ('yes' !== $show_image) {
      return;
    }

    $post_thumbnail_size = $settings['post_thumbnail_size'];

    if (has_post_thumbnail()) :  ?>
      <div class="post-grid-thumbnail">
        <a href="<?php the_permalink(); ?>">
          <?php the_post_thumbnail($post_thumbnail_size); ?>
        </a>
      </div>
<?php endif;
  }
}
