<?php

/**
 * Elementor Header Box Widget.
 *
 */

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Scheme_Typography;
use Elementor\Core\Schemes\Color;
use Elementor\Group_Control_Image_Size;


class Head_Box extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'head-box';
    }

    public function get_title()
    {
        return __('head box', 'leora');
    }

    public function get_icon()
    {
        return 'eicon-image-box';
    }

    public function get_categories()
    {
        return ['elementor-widget-be'];
    }

        protected function register_controls()
    {
        $this->init_content_general_controls();
    }

    protected function init_content_general_controls()
    {
        $this->start_controls_section(
            'section_layout',
            [
                'label' => esc_html__('Layout', 'leora'),
            ]
        );
        $this->add_control(
            'grid_style',
            [
                'label' => __('Grid Style', 'leora'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '1',
                'options' => [
                    '1' => esc_html__('Layout 1', 'leora'),
                    '2' => esc_html__('Layout 2', 'leora'),
                ],
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => __('Title', 'leora'),
                'type' => \Elementor\Controls_Manager::TEXT,
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .images_head__box h2',
                'condition' => [
                    'grid_style' => ['2'],
                ]
			]
		);
        $this->add_control(
            'title_bth',
            [
                'label' => __('Title button', 'leora'),
                'type' => \Elementor\Controls_Manager::TEXT,
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'title_bth_typography',
				'selector' => '{{WRAPPER}} .images_head__box h2',
                'condition' => [
                    'grid_style' => ['2'],
                ]
			]
		);
        $this->add_control(
			'item_description',
			[
				'label' => esc_html__( 'Description', 'leora' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'rows' => 10,
				'default' => esc_html__( 'Default description', 'leora' ),
				'placeholder' => esc_html__( 'Type your description here', 'leora' ),
                'condition' => [
                    'grid_style' => ['1'],
                ]
			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'content_typography',
				'selector' => '{{WRAPPER}} .search_head_box .title',
                'condition' => [
                    'grid_style' => ['1'],
                ]
			]
		);
        $this->add_control(
            'item_description_2',
            [
              'label' => __('Description', 'leora'),
              'type' => \Elementor\Controls_Manager::WYSIWYG,
              'default' => __('Default description', 'leora'),
              'placeholder' => __('Type your description here', 'leora'),
              'condition' => [
                'grid_style' => '2',
              ]
            ]
          );
          $this->add_control(
			'image',
			[
				'label' => esc_html__( 'Choose Image', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
        $this->add_control(
            'website_link',
            [
              'label' => __('Link More', 'leora'),
              'type' => \Elementor\Controls_Manager::URL,
              'placeholder' => __('https://your-link.com', 'leora'),
              'show_external' => true,
              'default' => [
                'url' => '',
                'is_external' => true,
                'nofollow' => true,
              ],
            ]
          );
        $this->end_controls_section();
        $this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Content', 'leora' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'grid_style' => '1',
                ]
			]
		);
		$repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'cat_count_background_Color',
            [
                'label' => __('background Color', 'leora'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#8571ff',
                
                'selectors' => [
                    '{{WRAPPER}} .cat_item_list_box a' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $repeater->add_control(
            'cat_count_text_Color',
            [
                'label' => __('text Color', 'leora'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffff',
                
                'selectors' => [
                    '{{WRAPPER}} .cat_item_list_box a' => 'background-color: {{VALUE}}',
                ],
            ]
        );
		$repeater->add_control(
			'cat_count', [
				'label' => __( 'category ID', 'leora' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '1' , 'leora' ),
				'label_block' => true,
			]
		);
		$this->add_control(
			'list',
			[
				'label' => __( 'Repeater List', 'leora' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'list_title' => __( 'Title #1', 'leora' ),
					],
					[
						'list_title' => __( 'Title #2', 'leora' ),
					],
				],
				'title_field' => '{{{ list_title }}}',
			]
		);

		$this->end_controls_section();
        $this->start_controls_section(
            'style_section_3',
            [
                'label' => __('General', 'leora'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'grid_style' => ['1','2'],
                  ]
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'background',
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .search_head_box',
                'selector' => '{{WRAPPER}} .images_head__box',
			]
		);
        $this->add_control(
            'title_Color',
            [
                'label' => __('Text Color', 'leora'),
                'type' => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .search_head_box .title' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .images_head__box h2' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'grid_style' => ['1','2'],
                ]
            ]
        );
        $this->add_control(
            'title_Color_text',
            [
                'label' => __('Text Color', 'leora'),
                'type' => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .images_head__box a' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'grid_style' => ['2'],
                ]
            ]
        );
        $this->add_control(
            'title_background_Color',
            [
                'label' => __('background Color', 'leora'),
                'type' => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .images_head__box a' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'grid_style' => ['2'],
                ]
            ]
        );
        $this->add_control(
            'search_icon',
            [
                'label' => __('Search Icon', 'leora'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#212121',
                
                'selectors' => [
                    '{{WRAPPER}} .search_head_box .custom-search button' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'grid_style' => ['1'],
                ]
            ]
        );
        $this->end_controls_section();

    }
    protected function render($instance = [])
    {
        $settings = $this->get_settings_for_display();
        $settings['title_color'] = $settings['title_color'] ?? '#212121';
        
        $bg_image = '';
        $grid_style = $settings['grid_style'];
            if (1 == $grid_style) {

                include(__DIR__ . '/headbox/search.php');
            } elseif (2 == $grid_style) {

                include(__DIR__ . '/headbox/images.php');
            }
            wp_reset_postdata();
    }

    protected function render_meta()
    {
        $settings = $this->get_settings();
        $meta_data = $settings['meta_data'];
        if (empty($meta_data)) {
            return;
        }
        ?>
        <div class="post-grid-meta">
            <?php
            if (in_array('date', $meta_data)) { ?>
                <span class="post-author"><?php echo apply_filters('the_date', get_the_date(), get_option('date_format'), '', ''); ?></span>
            <?php
            }

            if (in_array('categories', $meta_data)) {
                $categories_list = get_the_category_list(esc_html__(', ', 'leora'));

                if ($categories_list) {
                    printf('<span class="post-categories">%s</span>', $categories_list); // WPCS: XSS OK.
                }
            }

            if (in_array('comments', $meta_data)) { ?>
                <span class="post-comments"><?php comments_number(); ?></span>

            <?php
            }
            ?>
        </div>
        <?php

    }
    protected function render_thumbnail()
    {

        $settings = $this->get_settings();

        $show_image = $settings['show_image'];

        if ('yes' !== $show_image) {
            return;
        }

        $post_thumbnail_size = $settings['post_thumbnail_size'];

        if (has_post_thumbnail()) :  ?>
            <div class="post-grid-thumbnail">
                <a href="<?php the_permalink(); ?>">
                    <?php the_post_thumbnail($post_thumbnail_size); ?>
                </a>
            </div>
<?php endif;
    }
}
