<?php

/**
 * Elementor Box Content Responsive Widget.
 *
 */

class Dimag_Slid_Box extends \Elementor\Widget_Base
{

  public function get_name()
  {
    return 'dimag-slid-box';
  }

  public function get_title()
  {
    return __('slid box', 'leora');
  }

  public function get_icon()
  {
    return 'eicon-slider-album';
  }

  public function get_categories()
  {
    return ['elementor-widget-be'];
  }

  private function grid_get_all_post_type_categories($post_type)
  {
    $options = array();

    if ($post_type == 'post') {
      $taxonomy = 'category';
    } else {
      $taxonomy = 'product_cat';
    }

    // Get categories for post type.
    $terms = get_terms(
      array(
        'taxonomy' => $taxonomy,
        'hide_empty' => false,
      )
    );

    foreach ($terms as $term) {
      $options[$term->slug] = $term->name;
    }

    return $options;
  }
  private function grid_get_all_post_types()
  {
    $options = array();
    $exclude = array('attachment', 'elementor_widget_be'); // excluded post types

    $args = array(
      'public' => true,
    );

    foreach (get_post_types($args, 'objects') as $post_type) {

      if (!isset($post_type->name)) {
        continue;
      }

      if (!isset($post_type->label)) {
        continue;
      }

      if (in_array($post_type->name, $exclude) === true) {
        continue;
      }

      $options[$post_type->name] = $post_type->label;
    }

    return $options;
  }



      protected function register_controls()
    {
        $this->init_content_general_controls();
    }

    protected function init_content_general_controls()
  {
    $this->start_controls_section(
      'section_content',
      [
        'label' => __('Content', 'leora'),
      ]
    );
    $this->add_control(
      'title',
      [
        'label' => __('Title', 'leora'),
        'type' => \Elementor\Controls_Manager::TEXT,
      ]
    );
    $this->add_control(
      'title_more',
      [
        'label' => __('Title More', 'leora'),
        'type' => \Elementor\Controls_Manager::TEXT,
      ]
    );
    // Post type.
    $this->add_control(
      'grid_post_type',
      [
        'type'    => \Elementor\Controls_Manager::SELECT,
        'label'   => '<i class="fa fa-tag"></i> ' . __('Post Type', 'leora'),
        'default' => 'post',
        'options' => $this->grid_get_all_post_types(),
      ]
    );
    $this->add_control(
      'grid_items',
      [
        'type'        => \Elementor\Controls_Manager::NUMBER,
        'label'       => '<i class="fa fa-th-large"></i> ' . __('Items', 'leora'),
        'placeholder' => __('How many items?', 'leora'),
        'default'     => 4,
      ]
    );

    // Post categories.
    $this->add_control(
      'grid_post_categories',
      [
        'type'    => \Elementor\Controls_Manager::SELECT,
        'label'   => '<i class="fa fa-folder"></i> ' . __('Category', 'leora'),
        'options' => $this->grid_get_all_post_type_categories('post'),
        'condition' => [
          'grid_post_type' => 'post',
        ],
      ]
    );
    $this->add_control(
      'show_more',
      [
        'label' => __('Show more', 'leora'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => __('Show', 'leora'),
        'label_off' => __('Hide', 'leora'),
        'return_value' => 'yes',
        'default' => 'yes',
      ]
    );
    $this->add_control(
      'website_link',
      [
        'label' => __('Link More', 'leora'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('https://your-link.com', 'leora'),
        'show_external' => true,
        'default' => [
          'url' => '',
          'is_external' => true,
          'nofollow' => true,
        ],
      ]
    );
    // Order by.
    $this->add_control(
      'grid_order_by',
      [
        'type'    => \Elementor\Controls_Manager::SELECT,
        'label'   => '<i class="fa fa-sort"></i> ' . __('Order by', 'leora'),
        'default' => 'date',
        'options' => [
          'date'          => __('Date', 'leora'),
          'title'         => __('Title', 'leora'),
          'modified'      => __('Modified date', 'leora'),
          'comment_count' => __('Comment count', 'leora'),
          'rand'          => __('Random', 'leora'),
        ],
      ]
    );

    // Price.
    $this->add_control(
      'grid_content_price',
      [
        'label' => '<i class="fa fa-usd"></i> ' . __('Price', 'leora'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'default' => 'yes',
        'condition' => [
          'section_grid.grid_post_type' => 'product',
        ],
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'section_style',
      [
        'label' => __( 'Style', 'leora' ),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
     'background_color',
     [
       'label' => __('background color', 'leora'),
       'type' => \Elementor\Controls_Manager::COLOR,
       'default' => '#fff',
       
       'selectors' => [
         '{{WRAPPER}}  .dimagcarousel,.dimagcarousel .module-title__btn_cla,.dimagcarousel .module-title h2' => 'background: {{VALUE}}!important;',
       ],
     ]
   );
   $this->add_control(
     'box_title',
     [
       'label' => __('title', 'leora'),
       'type' => \Elementor\Controls_Manager::COLOR,
       'default' => '#535353',
       
       'selectors' => [
         '{{WRAPPER}} .dimagcarousel .module-title h2 span,.dimagcarousel .module-title__btn' => 'color: {{VALUE}}!important;',
       ],
     ]
   );
   $this->add_control(
     'box_title_more',
     [
       'label' => __('border', 'leora'),
       'type' => \Elementor\Controls_Manager::COLOR,
       'default' => '#bdbdbd',
       
       'selectors' => [
         '{{WRAPPER}} .dimagcarousel .module-title__btn,.dimagcarousel .module-title__sep' => 'border-color: {{VALUE}}!important;',
       ],
     ]
   );
    $this->add_control(
     'border_radius_article_blog_1',
     [
       'label' => __( 'border radius', 'leora' ),
       'type' => \Elementor\Controls_Manager::SLIDER,
       'size_units' => [ 'px', '%' ],
       'range' => [
         'px' => [
           'min' => 0,
           'max' => 100,
           'step' => 1,
         ],
         '%' => [
           'min' => 0,
           'max' => 100,
         ],
       ],
       'default' => [
         'unit' => 'px',
         'size' => 5,
       ],
       'selectors' => [
        '{{WRAPPER}} .dimagcarousel' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
      ],
     ]
   );
   $this->add_control(
    'border_radius_more',
    [
      'label' => __( 'border radius read more', 'leora' ),
      'type' => \Elementor\Controls_Manager::SLIDER,
      'size_units' => [ 'px', '%' ],
      'range' => [
        'px' => [
          'min' => 0,
          'max' => 100,
          'step' => 1,
        ],
        '%' => [
          'min' => 0,
          'max' => 100,
        ],
      ],
      'default' => [
        'unit' => 'px',
        'size' => 35,
      ],
      'selectors' => [
        '{{WRAPPER}} .dimagcarousel .module-title__btn' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
      ],
    ]
  );
    $this->end_controls_section();
    $this->start_controls_section(
     'section_style_box',
     [
       'label' => __( 'box', 'leora' ),
       'tab' => \Elementor\Controls_Manager::TAB_STYLE,
     ]
   );
   $this->add_control(
     'border_radius_article',
     [
       'label' => __( 'border radius', 'leora' ),
       'type' => \Elementor\Controls_Manager::SLIDER,
       'size_units' => [ 'px', '%' ],
       'range' => [
         'px' => [
           'min' => 0,
           'max' => 100,
           'step' => 1,
         ],
         '%' => [
           'min' => 0,
           'max' => 100,
         ],
       ],
       'default' => [
         'unit' => 'px',
         'size' => 5,
       ],
       'selectors' => [
         '{{WRAPPER}} .dimagcarousel .carousel__body__item' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
       ],
     ]
   );
    $this->end_controls_section();
   }


  protected function render()
  {
    $settings = $this->get_settings();
    $settings['background_color'] = $settings['background_color'] ?? '#fff'; ?>
    <script>
      $('.owl-two_5.owl-carousel').owlCarousel({
        items: 5,
        rtl: true,
        lazyLoad: true,
        autoWidth: false,
        navText: ['<i class="fal fa-chevron-right"></i>', '<i class="fal fa-chevron-left"></i>'],
        nav: true,
        dots: false,
        autoplay: false,
        loop: true,
        responsive: {
          0: {
            items: 1,
            nav: false,
          },
          600: {
            items: 1,
            nav: false,
          },
          1000: {
            items: 5
          }
        }
      });
    </script>
    <?php
    $target = $settings['website_link']['is_external'] ? ' target="_blank"' : '';
    $nofollow = $settings['website_link']['nofollow'] ? ' rel="nofollow"' : '';
    ?>
    <div class="homepage__main container">
      <section class="dimagcarousel" style="background-color:<?php echo $settings['background_color']; ?>">
        <div class="module-title">
          <div class="row">
            <div class="col-12">
              <h2><span><?php echo $settings['title']; ?></span></h2>
              <span class="module-title__sep"></span>
              <span class="module-title__btn_cla">
                <?php
                if ('yes' === $settings['show_more']) {
                  echo '<a class="module-title__btn" href="' . $settings['website_link']['url'] . '"' . $target . $nofollow . '>';
                  echo $settings['title_more'];
                  ''; ?></a>
                <?php } ?>
              </span>
            </div>
          </div>
        </div>
        <section class="owl-two_5 owl-carousel owl-theme">
          <?php
          $args = array();
          $args['post_status'] = 'publish';
          $args['ignore_sticky_posts'] = 1;
          if (!empty($settings['grid_post_type']) && post_type_exists($settings['grid_post_type'])) {
            $args['post_type'] = $settings['grid_post_type'];
          }
          if (!empty($settings['grid_post_categories']) && $settings['grid_post_type'] == 'post') {
            $args['category_name'] = $settings['grid_post_categories'];
          }
          if (!empty($settings['grid_product_categories']) && $settings['grid_post_type'] == 'product') {
            $args['tax_query'] = array(
              'relation' => 'AND',
              array(
                'taxonomy' => 'product_cat',
                'field' => 'slug',
                'terms' => $settings['grid_product_categories'],
              ),
            );
          }
          if (!empty($settings['grid_items']) && intval($settings['grid_items']) == $settings['grid_items']) {
            $args['posts_per_page'] = $settings['grid_items'];
          }
          if (!empty($settings['grid_order_by'])) {
            $args['orderby'] = $settings['grid_order_by'];
          }
          if (!empty($settings['grid_pagination'])) {
            $paged         = get_query_var('paged');
            if (empty($paged)) {
              $paged         = get_query_var('page');
            }
            $args['paged'] = $paged;
          }
          $query = new \WP_Query($args);
          if ($query->have_posts()) {
            while ($query->have_posts()) {
              $query->the_post();
          ?>
              <a href="<?php the_permalink(); ?>" class="carousel__body__item">
                <?php
                if (has_post_thumbnail()) {
                  the_post_thumbnail(array(300, 300), array('alt' => '' . get_the_title(), 'title' => '' . get_the_title() . ''));
                } else { ?>
                  <img style="object-fit: cover;" src="<?php print(get_template_directory_uri()); ?>/assets/images/thumb.gif" width="200" height="200" alt="<?php _e('Image not found', 'leora'); ?>" title="<?php _e('Image not found', 'leora'); ?>">
                <?php } ?>
                <div class="item__txt">
                  <span><?php the_title(); ?></span>
                </div>
                <div class="item__details">
                  <?php
                    $avatar_name  = ot_get_option('avatar_name', false);
                    if ($avatar_name  == 'on') :
                  ?>
                  <div class="user-profile-stat-wrapper">
                    <?php echo get_avatar(get_the_author_meta('ID'), 32); ?>
                    <span class="item__details--author"><?php the_author(); ?></span>
                  </div>
                  <?php endif; ?> 
                  <time class="item__details--date" style="float:<?php if ($avatar_name  == 'off'){ echo 'right'; }?>"><?php do_action('type_article'); ?><i class="fal fa-clock"></i><?php echo human_time_diff(get_the_time('U'), current_time('timestamp')) . ' پیش'; ?></time>
                </div>
              </a>
          <?php
            }
          } // end if; 
          ?>
        </section>
      </section>
    </div>
<?php
  }
}
