<?php

/**
 * Elementor Header Box Widget.
 *
 */

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Scheme_Typography;
use Elementor\Core\Schemes\Color;
use Elementor\Group_Control_Image_Size;


class Article extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'article';
    }

    public function get_title()
    {
        return __('article', 'leora');
    }

    public function get_icon()
    {
        return 'eicon-image-box';
    }

    public function get_categories()
    {
        return ['elementor-widget-be'];
    }

    private function wpcap_get_all_post_categories($post_type)
    {

        $options = array();

        $taxonomy = 'category';

        if (!empty($taxonomy)) {
            // Get categories for post type.
            $terms = get_terms(
                array(
                    'taxonomy'   => $taxonomy,
                    'hide_empty' => false,
                )
            );
            if (!empty($terms)) {
                foreach ($terms as $term) {
                    if (isset($term)) {
                        if (isset($term->slug) && isset($term->name)) {
                            $options[$term->slug] = $term->name;
                        }
                    }
                }
            }
        }

        return $options;
    }

    private function grid_get_all_post_types()
    {
        $options = array();
        $exclude = array('attachment', 'elementor_widget_be'); // excluded post types

        $args = array(
            'public' => true,
        );

        foreach (get_post_types($args, 'objects') as $post_type) {

            if (!isset($post_type->name)) {
                continue;
            }

            if (!isset($post_type->label)) {
                continue;
            }

            if (in_array($post_type->name, $exclude) === true) {
                continue;
            }

            $options[$post_type->name] = $post_type->label;
        }

        return $options;
    }

        protected function register_controls()
    {
        $this->init_content_general_controls();
    }

    protected function init_content_general_controls()
    {
        $this->start_controls_section(
            'section_layout',
            [
                'label' => esc_html__('Layout', 'leora'),
            ]
        );
        $this->add_control(
            'grid_style',
            [
                'label' => __('Grid Style', 'leora'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '1',
                'options' => [
                    '1' => esc_html__('Layout 1', 'leora'),
                    '2' => esc_html__('Layout 2', 'leora'),
                    '3' => esc_html__('Layout 3', 'leora'),
                    '4' => esc_html__('Layout 4', 'leora'),
                    '5' => esc_html__('Layout 5', 'leora'),
                    '6' => esc_html__('Layout 6', 'leora'),
                    '7' => esc_html__('Layout 7', 'leora'),
                    '8' => esc_html__('Layout 8', 'leora'),
                    '9' => esc_html__('Layout 9', 'leora'),
                    '10' => esc_html__('Layout 10', 'leora'),
                    '11' => esc_html__('Layout 11', 'leora'),
                    '12' => esc_html__('Layout 12', 'leora'),
                    '13' => esc_html__('Layout 13', 'leora'),
                    '14' => esc_html__('Layout 14', 'leora'),
                    '15' => esc_html__('Layout 15', 'leora'),
                    '16' => esc_html__('Layout 16', 'leora'),
                    '17' => esc_html__('Layout 17', 'leora'),
                ],
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => __('Title', 'leora'),
                'type' => \Elementor\Controls_Manager::TEXT,
            ]
        );
        $this->add_control(
			'title_show_more',
			[
				'label' => __('title show more', 'leora'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => 'title show more',
			]
		);
        $this->add_control(
            'show_more_icon',
            [
              'label' => __('Show Icon', 'leora'),
              'type' => \Elementor\Controls_Manager::SWITCHER,
              'label_on' => __('Show', 'leora'),
              'label_off' => __('Hide', 'leora'),
              'return_value' => 'yes',
              'default' => 'yes',
              'condition' => [
                'grid_style' => ['11'],
              ],
            ]
          );
          $this->add_control(
            'show_more_specifications_1',
            [
              'label' => __('Show Specifications', 'leora'),
              'type' => \Elementor\Controls_Manager::SWITCHER,
              'label_on' => __('Show', 'leora'),
              'label_off' => __('Hide', 'leora'),
              'return_value' => 'yes',
              'default' => 'yes',
              'condition' => [
                'grid_style' => ['11'],
              ],
            ]
          );
          $this->add_control(
            'show_more_categories',
            [
              'label' => __('Show Categories', 'leora'),
              'type' => \Elementor\Controls_Manager::SWITCHER,
              'label_on' => __('Show', 'leora'),
              'label_off' => __('Hide', 'leora'),
              'return_value' => 'yes',
              'default' => 'yes',
              'condition' => [
                'grid_style' => ['11'],
              ],
            ]
          );
        $this->add_control(
			'title_more',
			[
				'label' => __('button title', 'leora'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => 'title show more',
			]
		);
        $this->add_control(
            'meta_data',
            [
                'label' => __('Meta Data', 'leora'),
                'label_block' => true,
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => ['date', 'comments'],
                'multiple' => true,
                'options' => [
                    'author' => __('Author', 'leora'),
                    'date' => __('Date', 'leora'),
                    'categories' => __('Categories', 'leora'),
                    'comments' => __('Comments', 'leora'),
                ],
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'meta_separator',
            [
                'label' => __('Separator Between', 'leora'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '/',
                'selectors' => [
                    '{{WRAPPER}} .wpcap-grid-container .wpcap-post .post-grid-meta span + span:before' => 'content: "{{VALUE}}"',
                ],
                'condition' => [
                    'meta_data!' => [],
                ],
            ]
        );
        $this->add_control(
            'posts_per_page',
            [
                'label' => __('Posts Per Page', 'leora'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 5,
            ]
        );
        // Post categories
        $this->add_control(
            'post_categories',
            [
                'label'       => __('Categories', 'leora'),
                'label_block' => true,
                'type'        => \Elementor\Controls_Manager::SELECT2,
                'multiple'    => true,
                'options'     => $this->wpcap_get_all_post_categories('post'),

            ]
        );

        $this->add_control(
            'advanced',
            [
                'label' => __('Advanced', 'leora'),
                'type' => \Elementor\Controls_Manager::HEADING,
            ]
        );

        $this->add_control(
            'orderby',
            [
                'label' => __('Order By', 'leora'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'post_date',
                'options' => [
                    'post_date' => __('Date', 'leora'),
                    'post_title' => __('Title', 'leora'),
                    'rand' => __('Random', 'leora'),
                ],
            ]
        );

        $this->add_control(
            'order',
            [
                'label' => __('Order', 'leora'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'desc',
                'options' => [
                    'asc' => __('ASC', 'leora'),
                    'desc' => __('DESC', 'leora'),
                ],
            ]
        );
        $this->add_control(
            'show_more',
            [
                'label' => __('Show more', 'leora'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'leora'),
                'label_off' => __('Hide', 'leora'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control( 
            'show_more_specifications',
            [
              'label' => __('Show Specifications', 'leora'),
              'type' => \Elementor\Controls_Manager::SWITCHER,
              'label_on' => __('Show', 'leora'),
              'label_off' => __('Hide', 'leora'),
              'return_value' => 'yes',
              'default' => 'yes',
              'condition' => [
                'grid_style' => ['14','16','17'],
              ]
            ]
        );
        $this->add_control(
            'show_excerpt_text',
            [
              'label' => __('Show Specifications', 'leora'),
              'type' => \Elementor\Controls_Manager::SWITCHER,
              'label_on' => __('Show', 'leora'),
              'label_off' => __('Hide', 'leora'),
              'return_value' => 'yes',
              'default' => 'yes',
              'condition' => [
                'grid_style' => ['14','16','17'],
              ]
            ]
        );
        $this->add_control(
            'website_link',
            [
                'label' => __('Link More', 'leora'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('https://your-link.com', 'leora'),
                'show_external' => true,
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'style_section_3',
            [
                'label' => __('General', 'leora'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'grid_style!' => ['1','9','11','13','14','15','16','17'],
                  ]
            ]
        );
        $this->add_control(
            'background_Color_vid',
            [
                'label' => __('background Color', 'leora'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FFFF',
                
                'selectors' => [
                    '{{WRAPPER}} .larticle-3 .article_post3' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .card_box_10 .card_box_art10' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'grid_style!' => ['4','5','6','7','12'],
                ]
            ]
        );
        $this->add_control(
            'border_radius',
            [
              'label' => __( 'border radius', 'leora' ),
              'type' => \Elementor\Controls_Manager::SLIDER,
              'size_units' => [ 'px', '%' ],
              'range' => [
                'px' => [
                  'min' => 0,
                  'max' => 100,
                  'step' => 1,
                ],
                '%' => [
                  'min' => 0,
                  'max' => 100,
                ],
              ],
              'default' => [
                'unit' => 'px',
                'size' => 0,
              ],
              'selectors' => [
               '{{WRAPPER}} .article_post3 ' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
               '{{WRAPPER}} .card_box_10 .card_box_art10' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
               '{{WRAPPER}} .contai,.card_box_6 .article-text-box' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
               '{{WRAPPER}} .card_box_3 .card_arti' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
               '{{WRAPPER}} .card_box_2 .card_cont' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
               '{{WRAPPER}} .article_post2' => 'border-radius: {{SIZE}}{{UNIT}}!important;',

             ],
            ]
          );
        $this->end_controls_section();
        $this->start_controls_section(
            'widget_header',
            [
              'label' => __('header', 'leora'),
              'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
          );
          $this->add_control(
            'box_title',
            [
              'label' => __('title', 'leora'),
              'type' => \Elementor\Controls_Manager::COLOR,
              'default' => '#535353',
              
              'selectors' => [
                '{{WRAPPER}} .article_post2 .article__title' => 'color: {{VALUE}}!important;',
                '{{WRAPPER}} .larticle-1 .head_card_title' => 'color: {{VALUE}}!important;',
                '{{WRAPPER}} .card_box_10 .head_card_title' => 'color: {{VALUE}}!important;',
                '{{WRAPPER}} .card_box_2 .head_card_title' => 'color: {{VALUE}}!important;',
                '{{WRAPPER}} .larticle-1 .section-heading' => 'color: {{VALUE}}!important;',
              ],
            ]
          );
          $this->add_control(
            'box_title_redmor',
            [
              'label' => __('title show more', 'leora'),
              'type' => \Elementor\Controls_Manager::COLOR,
              'default' => '#535353',
              
              'selectors' => [
                '{{WRAPPER}} .card_box_2 .head_card_more' => 'color: {{VALUE}}!important;',
                '{{WRAPPER}} .larticle-1 .head_card_more' => 'color: {{VALUE}}!important;',
                '{{WRAPPER}} .card_box_10 .head_card_more' => 'color: {{VALUE}}!important;',
              ],
            ]
          );
          $this->add_control(
            'Iconlayoutvid',
            [
                'label' => __('Icon', 'leora'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'solid',
                ],
                'condition' => [
                    'grid_style!' => ['1','4','5','6','7','9','10','11','12','13','14','15','16','17'],
                ]
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'style_section_box',
            [
                'label' => __('box', 'leora'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'border_Color',
            [
                'label' => __('border Color', 'leora'),
                'type' => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .contai .boxcz .details .contentx a,.article_post3 .block_articels,.article_post2 article' => 'border-color: {{VALUE}}',
                ],
                'default' => '#eee',
                'condition' => [
                    'grid_style!' => ['1', '4','5','6','9','10','11','12','13','14','15','16','17'],
                  ]
            ]
        );
        $this->add_control(
            'title_color_box_bth',
            [
                'label' => __('title button color', 'leora'),
                'type' => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .card_box_2 .btn' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .card_box_17 .content_wrapper .terms-wrapper a' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .card_box_16 .content_wrapper .terms-wrapper a' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .card_box_15 .c_post_item .content_wrapper .terms-wrapper a' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .card_box_14 .c_post_item .content_wrapper .terms-wrapper a' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .card_box_12 .mobileNewsTitle' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .card_box_11 .card__overload--category,.contai .boxcz .details .contentx a,.card_box_6 .article__category' => 'color: {{VALUE}}',
                ],
                'default' => '#fff',
                'condition' => [
                    'grid_style' => ['4','6','7','11','12','14','15','16','17'],
                  ]
            ]
        );
        $this->add_control(
            'background_color_box',
            [
                'label' => __('background button', 'leora'),
                'type' => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .card_box_2 .btn' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .card_box_17 .content_wrapper .terms-wrapper a' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .card_box_16 .content_wrapper .terms-wrapper a' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .card_box_15 .c_post_item .content_wrapper .terms-wrapper a' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .card_box_14 .c_post_item .content_wrapper .terms-wrapper a' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .card_box_12 .mobileNewsTitle' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .card_box_11 .card__overload--category,.card_box_6 .article__category' => 'background-color: {{VALUE}}',
                ],
                'default' => '#000',
                'condition' => [
                    'grid_style' => ['4','6','11','12','14','15','16','17'],
                  ]
            ]
        );
        $this->add_control(
            'title_color_box_bth_bookmark',
            [
                'label' => __('title button color 2', 'leora'),
                'type' => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .card_box_17 .content_wrapper .read-more-wrapper a' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .card_box_16 .content_wrapper .read-more-wrapper a' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .card_box_14 .c_post_item .content_wrapper .read-more-wrapper a' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .card_box_12 .reviewContainer .rateNumber.orangBg' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .card_box_11 .card__bookmark' => 'color: {{VALUE}}',
                ],
                'default' => '#fff',
                'condition' => [
                    'grid_style' => ['11','12','14','16','17'],
                  ]
            ]
        );
        $this->add_control(
            'background_color_box_bookmark',
            [
                'label' => __('background button 2', 'leora'),
                'type' => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .card_box_17 .content_wrapper .read-more-wrapper a' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .card_box_16 .content_wrapper .read-more-wrapper a' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .card_box_14 .c_post_item .content_wrapper .read-more-wrapper a' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .card_box_12 .rateNumber::before' => 'border-bottom:11.55px solid {{VALUE}}',
                    '{{WRAPPER}} .card_box_12 .rateNumber::after' => 'border-top:11.55px solid {{VALUE}}',
                    '{{WRAPPER}} .card_box_12 .detailCont > .orangBg,.card_box_12 .detailCont > .orangBg > a' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .card_box_12 .reviewContainer .rateNumber.orangBg' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .card_box_11 .card__bookmark' => 'background-color: {{VALUE}}',
                ],
                'default' => '#000',
                'condition' => [
                    'grid_style' => ['11','12','14','16','17'],
                  ]
            ]
        );
        $this->add_control(
            'border_radius_box',
            [
              'label' => __( 'border radius', 'leora' ),
              'type' => \Elementor\Controls_Manager::SLIDER,
              'size_units' => [ 'px', '%' ],
              'range' => [
                'px' => [
                  'min' => 0,
                  'max' => 100,
                  'step' => 1,
                ],
                '%' => [
                  'min' => 0,
                  'max' => 100,
                ],
              ],
              'default' => [
                'unit' => 'px',
                'size' => 0,
              ],
              'selectors' => [
                '{{WRAPPER}} .larticle-2 .article_post2 article' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
                '{{WRAPPER}} .larticle-3 .block_articels' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
                '{{WRAPPER}} .article_post3 .article3_list_posts li .featured a' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
                '{{WRAPPER}} .card_box_3 .btn' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
                '{{WRAPPER}} .card_box_10 .widget_box_ch_list .listing_posts .featured a' => 'border-radius: {{SIZE}}{{UNIT}};',
                '{{WRAPPER}} .card_box_9 .box-card.fiv' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
                '{{WRAPPER}} .card_box_9 .fid-box-row.app-card img' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
                '{{WRAPPER}} .card_box_11 .cardSuggestions' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
                '{{WRAPPER}} .card_box_17 article,.card_box_17 .image_wrapper' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
                '{{WRAPPER}} .card_box_16 article,.card_box_16 .image_wrapper' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
                '{{WRAPPER}} .card_box_15 .c_post_item,.card_box_15 .c_post_item .content_wrapper' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
                '{{WRAPPER}} .card_box_14 .c_post_item,.card_box_14 .c_post_item .image_wrapper' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
                '{{WRAPPER}} .card_box_13 .newsWrapper,.card_box_13 .rudborder' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
                '{{WRAPPER}} .card_box_12 .digtwocart,.card_box_12 .thumbBox,.card_box_12 .mobileNews .newsWrapper' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
                '{{WRAPPER}} ,.larticle-1 .widget-item-content' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
             ],
             'condition' => [
                'grid_style!' => ['4','6','7'],
              ]
            ]
          );
        $this->end_controls_section();

    }
    protected function render($instance = [])
    {
        $settings = $this->get_settings_for_display();
        $settings['box_title'] = $settings['box_title'] ?? '#535353';
        $settings['box_title_redmor'] = $settings['box_title_redmor'] ?? '#535353';
        $settings['background_Color_vid'] = $settings['background_Color_vid'] ?? '#FFFF';

        $bg_image = '';
        if (!empty($settings['bg_image']['id'])) {
            $bg_image = \Elementor\Group_Control_Image_Size::get_attachment_image_src($settings['bg_image']['id'], 'bg_image', $settings);
        } elseif (!empty($settings['bg_image']['url'])) {
            $bg_image = $settings['bg_image']['url'];
        }
        if (empty($bg_image) && 'classic' == $settings) {
            $print_bg = false;
        }
        if (!empty($bg_image)) {
            $this->add_render_attribute('background_image', 'style', [
                'background-image: url(' . $bg_image . ');',
            ]);
        }
        if (!empty($settings['grid_pagination'])) {
            $paged         = get_query_var('paged');
            if (empty($paged)) {
                $paged         = get_query_var('page');
            }
            $args['paged'] = $paged;
        }
        if (empty($settings['title']) && empty($settings['description']) && empty($settings['button']) && 'none' == $settings) {
            $print_content = false;
        }
        $grid_style = $settings['grid_style'];

        $posts_per_page = (!empty($settings['posts_per_page']) ?  $settings['posts_per_page'] : 3);
        $cats = is_array($settings['post_categories']) ? implode(',', $settings['post_categories']) : $settings['post_categories'];
        $query_args = array(
            'posts_per_page'     => absint($posts_per_page),
            'no_found_rows'      => true,
            'post__not_in'          => get_option('sticky_posts'),
            'ignore_sticky_posts'   => true,
            'category_name'     => $cats
        );
        // Order by.
        if (!empty($settings['orderby'])) {
            $query_args['orderby'] = $settings['orderby'];
        }
        // Order .
        if (!empty($settings['order'])) {
            $query_args['order'] = $settings['order'];
        }
        $all_posts = new \WP_Query($query_args);

        if ($all_posts->have_posts()) :

            if (1 == $grid_style) {

                include(__DIR__ . '/article/layout-1.php');
            } elseif (2 == $grid_style) {

                include(__DIR__ . '/article/layout-2.php');
            } elseif (3 == $grid_style) {

                include(__DIR__ . '/article/layout-3.php');
            } elseif (4 == $grid_style) {

                include(__DIR__ . '/article/layout-4.php');
            } elseif (5 == $grid_style) {

                include(__DIR__ . '/article/layout-5.php');
            } elseif (6 == $grid_style) {

                include(__DIR__ . '/article/layout-6.php');
            } elseif (7 == $grid_style) {

                include(__DIR__ . '/article/layout-7.php');
            } elseif (8 == $grid_style) {

                include(__DIR__ . '/article/layout-8.php');
            } elseif (9 == $grid_style) {

                include(__DIR__ . '/article/layout-9.php');
            } elseif (10 == $grid_style) {

                include(__DIR__ . '/article/layout-10.php');
            } elseif (11 == $grid_style) {

                include(__DIR__ . '/article/layout-11.php');
            } elseif (12 == $grid_style) {

                include(__DIR__ . '/article/layout-12.php');
            } elseif (13 == $grid_style) {

                include(__DIR__ . '/article/layout-13.php');
            } elseif (14 == $grid_style) {

                include(__DIR__ . '/article/layout-14.php');
            } elseif (15 == $grid_style) {

                include(__DIR__ . '/article/layout-15.php');
            } elseif (16 == $grid_style) {

                include(__DIR__ . '/article/layout-16.php');
            } elseif (17 == $grid_style) {

                include(__DIR__ . '/article/layout-17.php');
            }
            wp_reset_postdata();
        endif;
    }

    protected function render_meta()
    {
        $settings = $this->get_settings();
        $meta_data = $settings['meta_data'];
        if (empty($meta_data)) {
            return;
        }
        ?>
        <div class="post-grid-meta">
            <?php
            if (in_array('date', $meta_data)) { ?>
                <span class="post-author"><?php echo apply_filters('the_date', get_the_date(), get_option('date_format'), '', ''); ?></span>
            <?php
            }

            if (in_array('categories', $meta_data)) {
                $categories_list = get_the_category_list(esc_html__(', ', 'leora'));

                if ($categories_list) {
                    printf('<span class="post-categories">%s</span>', $categories_list); // WPCS: XSS OK.
                }
            }

            if (in_array('comments', $meta_data)) { ?>
                <span class="post-comments"><?php comments_number(); ?></span>

            <?php
            }
            ?>
        </div>
        <?php

    }
    protected function render_thumbnail()
    {

        $settings = $this->get_settings();

        $show_image = $settings['show_image'];

        if ('yes' !== $show_image) {
            return;
        }

        $post_thumbnail_size = $settings['post_thumbnail_size'];

        if (has_post_thumbnail()) :  ?>
            <div class="post-grid-thumbnail">
                <a href="<?php the_permalink(); ?>">
                    <?php the_post_thumbnail($post_thumbnail_size); ?>
                </a>
            </div>
<?php endif;
    }
}
