<?php
/**
 * Elementor Header Box Widget.
 *
 */
 use Elementor\Widget_Base;
 use Elementor\Controls_Manager;
 use Elementor\Group_Control_Typography;
 use Elementor\Group_Control_Box_Shadow;
 use Elementor\Scheme_Typography;
 use Elementor\Core\Schemes\Color;
 use Elementor\Group_Control_Image_Size;


 class Article_Adv extends \Elementor\Widget_Base {

 	public function get_name() {
 		return 'article-adv';
 	}

 	public function get_title() {
 		return __( 'article adv', 'leora' );
 	}

 	public function get_icon() {
 		return 'eicon-inner-section';
 	}

 	public function get_categories() {
 		return [ 'elementor-widget-be' ];
 	}

  private function wpcap_get_all_post_categories( $post_type ) {

      $options = array();

      $taxonomy = 'category';

      if ( ! empty( $taxonomy ) ) {
        // Get categories for post type.
        $terms = get_terms(
          array(
            'taxonomy'   => $taxonomy,
            'hide_empty' => false,
          )
        );
        if ( ! empty( $terms ) ) {
          foreach ( $terms as $term ) {
            if ( isset( $term ) ) {
              if ( isset( $term->slug ) && isset( $term->name ) ) {
                $options[ $term->slug ] = $term->name;
              }
            }
          }
        }
      }

      return $options;
    }

  private function grid_get_all_post_types() {
   $options = array();
   $exclude = array( 'attachment', 'elementor_widget_be' ); // excluded post types

   $args = array(
     'public' => true,
   );

   foreach ( get_post_types( $args, 'objects' ) as $post_type ) {

     if ( ! isset( $post_type->name ) ) {
       continue;
     }

     if ( ! isset( $post_type->label ) ) {
       continue;
     }

     if ( in_array( $post_type->name, $exclude ) === true ) {
       continue;
     }

     $options[ $post_type->name ] = $post_type->label;
   }

   return $options;
 }
 
 protected function _register_controls() {
   $this->start_controls_section(
     'section_general',
     [
       'label' => esc_html__( 'general', 'leora' ),
     ]
   );
   $this->add_control(
     'grid_style',
     [
       'label' => __( 'Grid Style', 'leora' ),
       'type' => \Elementor\Controls_Manager::SELECT,
       'default' => '1',
       'options' => [
         '1' => esc_html__( 'Layout 1', 'leora' ),
         '2' => esc_html__( 'Layout 2', 'leora' ),
         '3' => esc_html__( 'Layout 3', 'leora' ),
       ],
     ]
   );
   $this->add_control(
     'title',
     [
       'label' => __( 'Title', 'leora' ),
       'type' => \Elementor\Controls_Manager::TEXT,
     ]
   );
   $this->add_control(
     'title_show_more',
     [
       'label' => __( 'Title More', 'leora' ),
       'type' => \Elementor\Controls_Manager::TEXT,
     ]
   );
   $this->add_control(
    'title_english',
    [
      'label' => __('title english', 'leora'),
      'type' => \Elementor\Controls_Manager::TEXT,
      'default' => 'title english',
    ]
  );
  $this->add_control(
    'title_article_more',
    [
      'label' => __('article more', 'leora'),
      'type' => \Elementor\Controls_Manager::TEXT,
      'default' => 'article more',
    ]
  );
   $this->add_control(
    'des_title', [
              'label' => __( 'Description', 'leora' ),
              'type' => \Elementor\Controls_Manager::WYSIWYG,
              'default' => __( 'Default description', 'leora' ),
              'placeholder' => __( 'Item content. Click the edit button to change this text.', 'leora' ),
              
    ]
  );

   $this->add_control(
     'more_link',
     [
       'label' => __( 'Link More', 'leora' ),
       'type' => \Elementor\Controls_Manager::URL,
       'placeholder' => __( 'https://your-link.com', 'leora' ),
       'show_external' => true,
       'default' => [
         'url' => '',
         'is_external' => true,
         'nofollow' => true,
       ],
     ]
   );
   $this->end_controls_section();
   $this->start_controls_section(
    'section_setting',
    [
      'label' => __('setting', 'leora'),
    ]
  );
  $this->add_control(
    'meta_data',
    [
      'label' => __( 'Meta Data', 'leora' ),
      'label_block' => true,
      'type' => \Elementor\Controls_Manager::SELECT2,
      'default' => [ 'date', 'comments' ],
      'multiple' => true,
      'options' => [
        'author' => __( 'Author', 'leora' ),
        'date' => __( 'Date', 'leora' ),
        'categories' => __( 'Categories', 'leora' ),
        'comments' => __( 'Comments', 'leora' ),
      ],
      'separator' => 'before',
    ]
  );
  $this->add_control(
    'meta_separator',
    [
      'label' => __( 'Separator Between', 'leora' ),
      'type' => \Elementor\Controls_Manager::TEXT,
      'default' => '/',
      'selectors' => [
        '{{WRAPPER}} .wpcap-grid-container .wpcap-post .post-grid-meta span + span:before' => 'content: "{{VALUE}}"',
      ],
      'condition' => [
        'meta_data!' => [],
      ],
    ]
  );
  $this->add_control(
    'posts_per_page',
    [
      'label' => __( 'Posts Per Page', 'leora' ),
      'type' => \Elementor\Controls_Manager::NUMBER,
      'default' => 5,
    ]
  );
  // Post categories
  $this->add_control(
    'post_categories',
    [
      'label'       => __( 'Categories', 'leora' ),
      'label_block' => true,
      'type'        => \Elementor\Controls_Manager::SELECT2,
      'multiple'    => true,
      'options'     => $this->wpcap_get_all_post_categories( 'post' ),

    ]
  );

  $this->add_control(
    'advanced',
    [
      'label' => __( 'Advanced', 'leora' ),
      'type' => \Elementor\Controls_Manager::HEADING,
    ]
  );

  $this->add_control(
    'orderby',
    [
      'label' => __( 'Order By', 'leora' ),
      'type' => \Elementor\Controls_Manager::SELECT,
      'default' => 'post_date',
      'options' => [
        'post_date' => __( 'Date', 'leora' ),
        'post_title' => __( 'Title', 'leora' ),
        'rand' => __( 'Random', 'leora' ),
      ],
    ]
  );

  $this->add_control(
    'order',
    [
      'label' => __( 'Order', 'leora' ),
      'type' => \Elementor\Controls_Manager::SELECT,
      'default' => 'desc',
      'options' => [
        'asc' => __( 'ASC', 'leora' ),
        'desc' => __( 'DESC', 'leora' ),
      ],
    ]
  );

  $this->end_controls_section();

   $this->start_controls_section(
    'section_show',
    [
      'label' => __('the show', 'leora'),
    ]
  );
  $this->add_control(
    'wid_article_blog_red_more_bth_show',
    [
      'label' => __('button read more', 'leora'),
      'type' => \Elementor\Controls_Manager::SWITCHER,
      'label_on' => __('Show', 'leora'),
      'label_off' => __('Hide', 'leora'),
      'return_value' => 'yes',
      'default' => 'yes',
    ]
  );
  $this->add_control(
    'wid_article_blog_time_and_avatar_show',
    [
      'label' => __('time and avatar', 'leora'),
      'type' => \Elementor\Controls_Manager::SWITCHER,
      'label_on' => __('Show', 'leora'),
      'label_off' => __('Hide', 'leora'),
      'return_value' => 'yes',
      'default' => 'yes',
    ]
  );
  $this->add_control(
    'wid_article_blog_description',
    [
      'label' => __('description', 'leora'),
      'type' => \Elementor\Controls_Manager::SWITCHER,
      'label_on' => __('Show', 'leora'),
      'label_off' => __('Hide', 'leora'),
      'return_value' => 'yes',
      'default' => 'yes',
    ]
  );
  $this->add_control(
    'wid_article_blog_time_show',
    [
      'label' => __('time', 'leora'),
      'type' => \Elementor\Controls_Manager::SWITCHER,
      'label_on' => __('Show', 'leora'),
      'label_off' => __('Hide', 'leora'),
      'return_value' => 'yes',
      'default' => 'yes',
    ]
  );
  $this->add_control(
    'wid_article_blog_avatar_name_show',
    [
      'label' => __('avatar name', 'leora'),
      'type' => \Elementor\Controls_Manager::SWITCHER,
      'label_on' => __('Show', 'leora'),
      'label_off' => __('Hide', 'leora'),
      'return_value' => 'yes',
      'default' => 'yes',
    ]
  );
  $this->add_control(
    'wid_article_blog_avatar_img_show',
    [
      'label' => __('avatar images', 'leora'),
      'type' => \Elementor\Controls_Manager::SWITCHER,
      'label_on' => __('Show', 'leora'),
      'label_off' => __('Hide', 'leora'),
      'return_value' => 'yes',
      'default' => 'yes',
    ]
  );
  $this->add_control(
    'wid_article_blog_comment_show',
    [
      'label' => __('comment', 'leora'),
      'type' => \Elementor\Controls_Manager::SWITCHER,
      'label_on' => __('Show', 'leora'),
      'label_off' => __('Hide', 'leora'),
      'return_value' => 'yes',
      'default' => 'yes',
    ]
  );
  $this->add_control(
    'wid_article_blog_tag_show',
    [
      'label' => __('tag icon', 'leora'),
      'type' => \Elementor\Controls_Manager::SWITCHER,
      'label_on' => __('Show', 'leora'),
      'label_off' => __('Hide', 'leora'),
      'return_value' => 'yes',
      'default' => 'yes',
    ]
  );
  $this->end_controls_section();
   $this->start_controls_section(
     'layout_2',
     [
       'label' => esc_html__( 'box article', 'leora' ),
       'tab' => \Elementor\Controls_Manager::TAB_STYLE,
     ]
   );
   $this->add_control(
    'wid_article_blog_background_color',
    [
      'label' => __( 'article background color', 'leora' ),
      'type' => \Elementor\Controls_Manager::COLOR,
      'default' => '#fff',
      
      'selectors' => [
        '{{WRAPPER}} .wid_article_blog .arch__body__item,.wid_article_blog .blogcard__btns' => 'background-color: {{VALUE}}!important',
      ],
    ]
  );
  $this->add_control(
    'wid_article_blog_title_color',
    [
      'label' => __( 'article title color', 'leora' ),
      'default' => '#6a7075',
      'type' => \Elementor\Controls_Manager::COLOR,
      
      'selectors' => [
        '{{WRAPPER}} .wid_article_blog .arch__body__item .item__txt' => 'color: {{VALUE}}!important',
      ],
    ]
  );
  $this->add_control(
    'wid_article_blog_avatar_time_color',
    [
      'label' => __( 'article avatar and time color', 'leora' ),
      'type' => \Elementor\Controls_Manager::COLOR,
      'default' => '#afb6bc',
      
      'selectors' => [
        '{{WRAPPER}} .wid_article_blog .arch__body__item .item__details--author,.wid_article_blog .arch__body__item .item__details--date' => 'color: {{VALUE}}!important',
      ],
      
    ]
  );
  $this->add_control(
    'wid_article_blog_description_color',
    [
      'label' => __( 'description color', 'leora' ),
      'type' => \Elementor\Controls_Manager::COLOR,
      'default' => '#6a7075',
      
      'selectors' => [
        '{{WRAPPER}} .wid_article_blog .arch__body__item .item_description p' => 'color: {{VALUE}}!important',
      ],
      
    ]
  );
  $this->add_control(
    'wid_article_blog_icon_type',
    [
      'label' => __( 'article icon color', 'leora' ),
      'type' => \Elementor\Controls_Manager::COLOR,
      'default' => '#fff',
      
      'selectors' => [
        '{{WRAPPER}} .wid_article_blog .post_tag_types,.wid_article_blog .arch__body__item .post-comments' => 'color: {{VALUE}}!important',
      ],
      
    ]
  );
  $this->add_control(
    'wid_article_blog_read_more_background',
    [
      'label' => __( 'article read more background color', 'leora' ),
      'type' => \Elementor\Controls_Manager::COLOR,
      'default' => '#FEA000',
      
      'selectors' => [
        '{{WRAPPER}} .wid_article_blog .btn--orange' => 'background-color: {{VALUE}}!important',
      ],
      
    ]
  );
  $this->add_control(
    'wid_article_blog_read_more',
    [
      'label' => __( 'article read more text color', 'leora' ),
      'type' => \Elementor\Controls_Manager::COLOR,
      'default' => '#fff',
      
      'selectors' => [
        '{{WRAPPER}} .wid_article_blog .btn--orange' => 'color: {{VALUE}}!important',
      ],
      
    ]
  );
  $this->add_control(
    'wid_article_blog_line_color',
    [
      'label' => __( 'border color', 'leora' ),
      'type' => \Elementor\Controls_Manager::COLOR,
      'default' => '#ebebeb',
      
      'selectors' => [
        '{{WRAPPER}} .wid_article_blog .arch__body__item .item__details,.wid_article_blog .arch__body__item .item_description' => 'border-color: {{VALUE}}!important',
      ],
      
    ]
  );
  $this->add_control(
    'wid_article_blog_read_more_radius',
    [
      'label' => __( 'read more border radius', 'leora' ),
      'type' => \Elementor\Controls_Manager::DIMENSIONS,
      'size_units' => [ 'px', '%', 'em' ],
      'selectors' => [
        '{{WRAPPER}} .wid_article_blog .btn--orange' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
      ],
    ]
  );
  $this->add_control(
    'wid_article_blog_radius',
    [
      'label' => __( 'article border radius', 'leora' ),
      'type' => \Elementor\Controls_Manager::DIMENSIONS,
      'size_units' => [ 'px', '%', 'em' ],
      'selectors' => [
        '{{WRAPPER}} .wid_article_blog .arch__body__item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
      ],
    ]
  );
  $this->end_controls_section();
  $this->start_controls_section(
    'section_slider',
    [
      'label' => __('slider', 'leora'),
    ]
  );
  $this->add_control(
    'wid_show_slides',
    [
      'label' => __('show slides', 'leora'),
      'type' => \Elementor\Controls_Manager::SELECT,
      'default' => '2',
      'options' => [
         '2' => esc_html__('gride ', 'leora'),
      ],
    ]
  );
  $this->add_control(
    'wid_show_gride_columns_desktop',
    [
      'label' => __('columns desktop', 'leora'),
      'type' => \Elementor\Controls_Manager::SELECT,
      'default' => '4',
      'options' => [
        '2' => esc_html__('columns 6', 'leora'),
        '3' => esc_html__('columns 4', 'leora'),
        '4' => esc_html__('columns 3 ', 'leora'),
        '6' => esc_html__('columns 2 ', 'leora'),
        '12' => esc_html__('columns 1 ', 'leora'),

      ],
      'condition' => [
        'wid_show_slides' => '2',
      ]
    ]
  );
  $this->add_control(
    'wid_show_gride_columns_mobile',
    [
      'label' => __('columns mobile', 'leora'),
      'type' => \Elementor\Controls_Manager::SELECT,
      'default' => '12',
      'options' => [
        '12' => esc_html__('columns 1 ', 'leora'),
        '6' => esc_html__('columns 2 ', 'leora'),

      ],
      'condition' => [
        'wid_show_slides' => '2',
      ]
    ]
  );
  $this->add_control(
    'wid_show_gride_columns_padding',
    [
      'label' => __( 'padding columns', 'leora' ),
      'type' => \Elementor\Controls_Manager::DIMENSIONS,
      'size_units' => [ 'px', '%', 'em' ],
      'selectors' => [
        '{{WRAPPER}} .wid_article_blog .row .wid-item-pad   ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
      ],
      'condition' => [
        'wid_show_slides' => '2',
      ]
    ]
  );
  $this->add_control(
    'wid_slidesToShow',
    [
      'label' => __( 'slides To Show', 'leora' ),
      'type' => \Elementor\Controls_Manager::NUMBER,
      'min' => 1,
      'max' => 10,
      'step' => 1,
      'default' => 4,
      'condition' => [
        'wid_show_slides' => '1',
      ]
    ]
  );
  $this->add_control(
    'wid_slidesToScroll',
    [
      'label' => __( 'slides To Scroll', 'leora' ),
      'type' => \Elementor\Controls_Manager::NUMBER,
      'min' => 1,
      'max' => 10,
      'step' => 1,
      'default' => 1,
      'condition' => [
        'wid_show_slides' => '1',
      ]
    ]
  );
  $this->add_control(
    'wid_dots',
    [
      'label' => __('dots', 'leora'),
      'type' => \Elementor\Controls_Manager::SWITCHER,
      'label_on' => __('true', 'leora'),
      'label_off' => __('false', 'leora'),
      'return_value' => 'true',
      'default' => 'true',
      'condition' => [
        'wid_show_slides' => '1',
      ]
    ]
  );
  $this->add_control(
    'wid_autoplay',
    [
      'label' => __('autoplay', 'leora'),
      'type' => \Elementor\Controls_Manager::SWITCHER,
      'label_on' => __('true', 'leora'),
      'label_off' => __('false', 'leora'),
      'return_value' => 'true',
      'default' => 'true',
      'condition' => [
        'wid_show_slides' => '1',
      ]
    ]
  );
  $this->add_control(
    'wid_autoplaySpeed',
    [
      'label' => __( 'auto play Speed', 'leora' ),
      'type' => \Elementor\Controls_Manager::NUMBER,
      'min' => 500,
      'max' => 100000,
      'step' => 5,
      'default' => 2000,
      'condition' => [
        'wid_show_slides' => '1',
      ]
    ]
  );
  $this->add_control(
    'wid_Speed',
    [
      'label' => __( 'Speed', 'leora' ),
      'type' => \Elementor\Controls_Manager::NUMBER,
      'min' => 50,
      'max' => 100000,
      'step' => 5,
      'default' => 500,
      'condition' => [
        'wid_show_slides' => '1',
      ]
    ]
  );
  $this->end_controls_section();
  $this->start_controls_section(
    'section_header',
    [
      'label' => __('header', 'leora'),
    ]
  );
  $this->add_control(
    'wid_header',
    [
      'label' => __('header', 'leora'),
      'type' => \Elementor\Controls_Manager::SELECT,
      'default' => '3',
      'options' => [
        '1' => esc_html__('top', 'leora'),
        '3' => esc_html__('center ', 'leora'),
      ],
    ]
  );
  $this->add_control(
    'wid_header_top_background',
    [
      'label' => __( 'background color', 'leora' ),
      'type' => \Elementor\Controls_Manager::COLOR,
      'default' => '#fff',
      
      'selectors' => [
        '{{WRAPPER}} .header-widget-prod' => 'background-color: {{VALUE}}!important',
      ],
      'condition' => [
        'wid_header' => '1',
      ]
    ]
  );
  $this->add_control(
    'wid_header_top_border_radius',
    [
      'label' => __( 'border radius', 'leora' ),
      'type' => \Elementor\Controls_Manager::DIMENSIONS,
      'size_units' => [ 'px', '%', 'em' ],
      'selectors' => [
        '{{WRAPPER}} .header-widget-prod' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
      ],
      'condition' => [
        'wid_header' => '1',
      ]
    ]
  );
  $this->add_control(
    'wid_header_top_margin',
    [
      'label' => __( 'margin', 'leora' ),
      'type' => \Elementor\Controls_Manager::DIMENSIONS,
      'size_units' => [ 'px', '%', 'em' ],
      'selectors' => [
        '{{WRAPPER}} .header-widget-prod' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
      ],
      'condition' => [
        'wid_header' => '1',
      ]
    ]
  );
  $this->add_control(
    'wid_header_top_padding',
    [
      'label' => __( 'padding', 'leora' ),
      'type' => \Elementor\Controls_Manager::DIMENSIONS,
      'size_units' => [ 'px', '%', 'em' ],
      'selectors' => [
        '{{WRAPPER}} .header-widget-prod' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
      ],
      'condition' => [
        'wid_header' => '1',
      ]
    ]
  );
  $this->add_control(
    'wid_header_top_image',
    [
      'label' => __('Choose Image ', 'leora'),
      'type' => \Elementor\Controls_Manager::MEDIA,
      'dynamic' => [
        'active' => true,
      ],
      'default' => [
        'url' => \Elementor\Utils::get_placeholder_image_src(),
      ],
      'condition' => [
        'wid_header' => '1',
      ]
    ]
  );
  $this->add_group_control(
    \Elementor\Group_Control_Image_Size::get_type(),
    [
      'name' => 'wid_header_top_image', // Actually its `image_size`
      'label' => __('Image Resolution', 'leora'),
      'default' => 'full',
      'condition' => [
        'wid_header_top_image[id]!' => '',
      ],
      'separator' => 'none',
    ]

  );
  $this->add_control(
    'wid_header_top_image_border_radius',
    [
      'label' => __( 'image border radius', 'leora' ),
      'type' => \Elementor\Controls_Manager::DIMENSIONS,
      'size_units' => [ 'px', '%', 'em' ],
      'selectors' => [
        '{{WRAPPER}} .header-widget-img img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
      ],
      'condition' => [
        'wid_header' => '1',
      ]
    ]
  );
  $this->add_control(
    'wid_header_icon',
    [
      'label' => __( 'Icon', 'leora' ),
      'type' => \Elementor\Controls_Manager::ICONS,
      'default' => [
        'value' => 'fas fa-star',
        'library' => 'solid',
      ],
      'condition' => [
        'wid_header' => '3',
      ]
    ]
  );
  $this->add_control(
    'wid_header_icon_size',
    [
      'label' => __( 'font size icon', 'leora' ),
      'type' => \Elementor\Controls_Manager::SLIDER,
      'size_units' => [ 'px', '%' ],
      'range' => [
        'px' => [
          'min' => 0,
          'max' => 60,
          'step' => 5,
        ],
        '%' => [
          'min' => 0,
          'max' => 100,
        ],
      ],
      'default' => [
        'unit' => 'px',
        'size' => 50,
      ],
      'selectors' => [
        '{{WRAPPER}} .title_area_pro .per_title_area i' => 'font-size: {{SIZE}}{{UNIT}};',
      ],
      'condition' => [
        'wid_header' => '3',
      ]
    ]
  );
  $this->add_control(
    'wid_header_icon_color',
    [
      'label' => __( 'Icon color', 'leora' ),
      'type' => \Elementor\Controls_Manager::COLOR,
      'default' => '#000',
      
      'selectors' => [
        '{{WRAPPER}} .title_area_pro .per_title_area i' => 'color: {{VALUE}}!important',
      ],
      'condition' => [
        'wid_header' => '3',
      ]
    ]
  );
  $this->add_control(
    'wid_header_title_center',
    [
      'label' => __( 'title color', 'leora' ),
      'type' => \Elementor\Controls_Manager::COLOR,
      'default' => '#000',
      
      'selectors' => [
        '{{WRAPPER}} .title_area_pro .per_title_area h2 a' => 'color: {{VALUE}}!important',
      ],
      'condition' => [
        'wid_header' => '3',
      ]
    ]
  );
  $this->add_control(
    'wid_header_title_center_ english',
    [
      'label' => __( 'english title color', 'leora' ),
      'type' => \Elementor\Controls_Manager::COLOR,
      'default' => '#9999',
      
      'selectors' => [
        '{{WRAPPER}} .title_area_pro .per_title_area small' => 'color: {{VALUE}}!important',
      ],
      'condition' => [
        'wid_header' => '3',
      ]
    ]
  );
  $this->end_controls_section();
  $this->start_controls_section(
    'section_sitting_slider_style',
    [
      'label' => __('slider', 'leora'),
      'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    ]
  );
  $this->add_control(
    'wid_article_slider_arrow_border_radius',
    [
      'label' => __( 'slider arrow border radius', 'leora' ),
      'type' => \Elementor\Controls_Manager::DIMENSIONS,
      'size_units' => [ 'px', '%', 'em' ],
      'selectors' => [
        '{{WRAPPER}} .wid_article_blog .slick-arrow' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
      ],
    ]
  );
  $this->add_control(
    'wid_article_slider_arrow_background',
    [
      'label' => __( 'slider arrow background', 'leora' ),
      'type' => \Elementor\Controls_Manager::COLOR,
      'default' => '#fff',
      
      'selectors' => [
        '{{WRAPPER}} .wid_article_blog .slick-arrow' => 'background-color: {{VALUE}}!important',
      ],
    ]
  );
  $this->add_control(
    'wid_article_slider_arrow_color',
    [
      'label' => __( 'slider arrow color', 'leora' ),
      'type' => \Elementor\Controls_Manager::COLOR,
      'default' => '#acabab',
      
      'selectors' => [
        '{{WRAPPER}} .wid_article_blog .slick-arrow i' => 'color: {{VALUE}}!important',
      ],
    ]
  );
  $this->add_control(
    'wid_article_slick_dots_background',
    [
      'label' => __( 'slider dots background', 'leora' ),
      'type' => \Elementor\Controls_Manager::COLOR,
      'default' => '#f2f2f2',
      
      'selectors' => [
        '{{WRAPPER}} .wid_article_blog ul.slick-dots li button' => 'background-color: {{VALUE}}!important',
      ],
    ]
  );
  $this->add_control(
    'wid_article_slider_dots_active',
    [
      'label' => __( 'slider dots active', 'leora' ),
      'type' => \Elementor\Controls_Manager::COLOR,
      'default' => '#fc0',
      
      'selectors' => [
        '{{WRAPPER}} .wid_article_blog ul.slick-dots li.slick-active button' => 'background-color: {{VALUE}}!important',
      ],
    ]
  );
  $this->end_controls_section();
  $this->start_controls_section(
    'section_header_style',
    [
      'label' => __('header', 'leora'),
      'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    ]
  );
  $this->add_control(
    'wid_header_title',
    [
      'label' => __( 'header title', 'leora' ),
      'type' => \Elementor\Controls_Manager::COLOR,
      'default' => '#000',
      
      'selectors' => [
        '{{WRAPPER}} .header-widget-prod .content-header h2' => 'color: {{VALUE}}!important',
      ],
    ]
  );
  $this->add_control(
    'wid_header_bth_background',
    [
      'label' => __( 'button background color', 'leora' ),
      'type' => \Elementor\Controls_Manager::COLOR,
      
      'selectors' => [
        '{{WRAPPER}} .wid_header_3 a.bth-new, .header-widget-prod .content-header a.bth-new, .wid_article_blog .courses-wid-sid-bar a.bth-new' => 'background-color: {{VALUE}}!important',
      ],
    ]
  );
  $this->add_control(
    'wid_header_bth_text',
    [
      'label' => __( 'button text color', 'leora' ),
      'type' => \Elementor\Controls_Manager::COLOR,
      'default' => '#0f7c90',
      
      'selectors' => [
        '{{WRAPPER}} .wid_header_3 a.bth-new, .header-widget-prod .content-header a.bth-new, .wid_article_blog .courses-wid-sid-bar a.bth-new' => 'color: {{VALUE}}!important',
      ],
    ]
  );
  $this->add_group_control(
    \Elementor\Group_Control_Border::get_type(),
    [
      'name' => 'wid_header_bth_border',
      'label' => __( 'Border button', 'leora' ),
      'selector' => '{{WRAPPER}} .wid_header_3 a.bth-new,.header-widget-prod .content-header a.bth-new, .wid_article_blog .courses-wid-sid-bar a.bth-new',
    ]
  );
  $this->add_control(
    'wid_header__border_radius',
    [
      'label' => __( 'header border radius', 'leora' ),
      'type' => \Elementor\Controls_Manager::DIMENSIONS,
      'size_units' => [ 'px', '%', 'em' ],
      'selectors' => [
        '{{WRAPPER}} .wid_header_3 a.bth-new, .wid_article_blog .courses-wid-sid-bar' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
      ],
    ]
  );
  $this->add_control(
    'wid_header_bth_border_radius',
    [
      'label' => __( 'header button border radius', 'leora' ),
      'type' => \Elementor\Controls_Manager::DIMENSIONS,
      'size_units' => [ 'px', '%', 'em' ],
      'selectors' => [
        '{{WRAPPER}} .header-widget-prod .content-header a.bth-new, .wid_article_blog .courses-wid-sid-bar a.bth-new' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
      ],
    ]
  );
  $this->add_control(
    'wid_header_image',
    [
      'label' => __('header Choose Image ', 'leora'),
      'type' => \Elementor\Controls_Manager::MEDIA,
      'dynamic' => [
        'active' => true,
      ],
      'default' => [
        'url' => \Elementor\Utils::get_placeholder_image_src(),
      ],
    ]
  );
  $this->add_group_control(
    \Elementor\Group_Control_Image_Size::get_type(),
    [
      'name' => 'wid_header_image', // Actually its `image_size`
      'label' => __('Image Resolution', 'leora'),
      'default' => 'full',
      'condition' => [
        'wid_header_image[id]!' => '',
      ],
      'separator' => 'none',
    ]

  );
  $this->end_controls_section();
 }
 protected function render( $instance = [] ) { 
     $settings = $this->get_settings_for_display();
     $wid_header = $settings['wid_header'];
     $bg_image = '';
    if ( ! empty( $settings['bg_image']['id'] ) ) {
      $bg_image = \Elementor\Group_Control_Image_Size::get_attachment_image_src( $settings['bg_image']['id'], 'bg_image', $settings );
    } elseif ( ! empty( $settings['bg_image']['url'] ) ) {
      $bg_image = $settings['bg_image']['url'];
    }
    if ( empty( $bg_image ) && 'classic' == $settings ) {
      $print_bg = false;
    }
    if(! empty  ($bg_image) ){
    $this->add_render_attribute( 'background_image', 'style', [
      'background-image: url(' . $bg_image . ');',
    ] );
}
   $settings = $this->get_settings();
   if ( ! empty( $settings['grid_pagination'] ) ) {
    $paged         = get_query_var( 'paged' );
    if ( empty( $paged ) ) {
      $paged         = get_query_var( 'page' );
    }
    $args['paged'] = $paged;
  }
   if ( empty( $settings['title'] ) && empty( $settings['description'] ) && empty( $settings['button'] ) && 'none' == $settings ) {
     $print_content = false;
   }
   $grid_style = $settings['grid_style'];

   $posts_per_page = ( ! empty( $settings['posts_per_page'] ) ?  $settings['posts_per_page'] : 3 );
   $cats = is_array( $settings['post_categories'] ) ? implode( ',', $settings['post_categories'] ) : $settings['post_categories'];
       $query_args = array(
               'posts_per_page' 		=> absint( $posts_per_page ),
               'no_found_rows'  		=> true,
               'post__not_in'          => get_option( 'sticky_posts' ),
               'ignore_sticky_posts'   => true,
               'category_name' 		=> $cats
             );
             // Order by.
             if ( ! empty( $settings['orderby'] ) ) {
               $query_args['orderby'] = $settings['orderby'];
             }
             // Order .
             if ( ! empty( $settings['order'] ) ) {
               $query_args['order'] = $settings['order'];
             }
             $all_posts = new \WP_Query( $query_args );

             if ( $all_posts->have_posts() ) :

               if( 1 == $grid_style ){

                 include( __DIR__ . '/article-2/article-1.php' );

               }elseif( 2 == $grid_style ){

                 include( __DIR__ . '/article-2/article-2.php' );

               }elseif( 3 == $grid_style ){

                 include( __DIR__ . '/article-2/article-3.php' );

               }
                 wp_reset_postdata();
              endif;
        }

     protected function render_meta() {
       $settings = $this->get_settings();
       $meta_data = $settings['meta_data'];
       if ( empty( $meta_data ) ) {
         return;
       }
       ?>
       <div class="post-grid-meta">
         <?php
         if ( in_array( 'date', $meta_data ) ) { ?>
           <span class="post-author"><?php echo apply_filters( 'the_date', get_the_date(), get_option( 'date_format' ), '', '' ); ?></span>
           <?php
         }

         if ( in_array( 'categories', $meta_data ) ) {
           $categories_list = get_the_category_list( esc_html__( ', ', 'leora' ) );

           if ( $categories_list ) {
               printf( '<span class="post-categories">%s</span>', $categories_list ); // WPCS: XSS OK.
           }
         }

         if ( in_array( 'comments', $meta_data ) ) { ?>
           <span class="post-comments"><?php comments_number(); ?></span>

           <?php
         }
         ?>
       </div>
       <?php

     }
     protected function render_thumbnail() {

       $settings = $this->get_settings();

       $show_image = $settings['show_image'];

       if ( 'yes' !== $show_image ) {
         return;
       }

       $post_thumbnail_size = $settings['post_thumbnail_size'];

       if ( has_post_thumbnail() ) :  ?>
         <div class="post-grid-thumbnail">
           <a href="<?php the_permalink(); ?>">
             <?php the_post_thumbnail( $post_thumbnail_size ); ?>
           </a>
         </div>
           <?php endif;
     }
}