<?php

/**
 * Elementor Box Content Responsive Widget.
 *
 */

use \Elementor\Group_Control_Image_Size;


class Affiliate_Marketing extends \Elementor\Widget_Base
{

  public function get_name()
  {
    return 'affiliate';
  }

  public function get_title()
  {
    return __('Affiliate Marketing', 'leora');
  }

  public function get_icon()
  {
    return 'eicon-product-upsell';
  }

  public function get_categories()
  {
    return ['elementor-widget-be'];
  }

  private function grid_get_all_post_type_categories($post_type)
  {
    $options = array();

    if ($post_type == 'post') {
      $taxonomy = 'category';
    } else {
      $taxonomy = 'product_cat';
    }

    // Get categories for post type.
    $terms = get_terms(
      array(
        'taxonomy' => $taxonomy,
        'hide_empty' => false,
      )
    );

    foreach ($terms as $term) {
      $options[$term->slug] = $term->name;
    }

    return $options;
  }
  private function grid_get_all_post_types()
  {
    $options = array();
    $exclude = array('attachment', 'elementor_widget_be'); // excluded post types

    $args = array(
      'public' => true,
    );

    foreach (get_post_types($args, 'objects') as $post_type) {

      if (!isset($post_type->name)) {
        continue;
      }

      if (!isset($post_type->label)) {
        continue;
      }

      if (in_array($post_type->name, $exclude) === true) {
        continue;
      }

      $options[$post_type->name] = $post_type->label;
    }

    return $options;
  }
 
      protected function register_controls()
    {
        $this->init_content_general_controls();
    }

    protected function init_content_general_controls()
  {
    $this->start_controls_section(
      'section_general',
      [
        'label' => __('General', 'leora'),
      ]
    );
    $this->add_control(
      'title',
      [
        'label' => __('Title', 'leora'),
        'type' => \Elementor\Controls_Manager::TEXT,
      ]
    );
    $this->add_control(
      'title_more',
      [
        'label' => __('Title More', 'leora'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'اطلاعات بیشتر و خرید',
      ]
    );
    $this->add_control(
        'score',
        [
          'label' => __('score', 'leora'),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => '4.7',
        ]
      );
  
    $this->add_control(
      'website_link',
      [
        'label' => __('Link More', 'leora'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('https://your-link.com', 'leora'),
        'show_external' => true,
        'default' => [
          'url' => '',
          'is_external' => true,
          'nofollow' => true,
        ],
      ]
    );

    $this->end_controls_section();

    $this->start_controls_section(
        'section_content',
        [
          'label' => __('Content', 'leora'),
        ]
      );
      $this->add_control(
        'image',
        [
            'label' => esc_html__( 'Choose Image', 'leora' ),
            'type' => \Elementor\Controls_Manager::MEDIA,
            'default' => [
                'url' => \Elementor\Utils::get_placeholder_image_src(),
            ],
        ]
    );
    $this->add_control(
        'list_content', [
            'label' => esc_html__( 'Content', 'leora' ),
            'type' => \Elementor\Controls_Manager::WYSIWYG,
            'default' => esc_html__( 'List Content' , 'leora' ),
            'show_label' => false,
        ]
    );
    $this->end_controls_section();

    $this->start_controls_section(
      'section_features',
      [
        'label' => __('features', 'leora'),
      ]
    );
    $this->add_control(
      'show_features',
      [
        'label' => __('Show features', 'leora'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => __('Show', 'leora'),
        'label_off' => __('Hide', 'leora'),
        'return_value' => 'yes',
        'default' => 'yes',
      ]
    );
    $this->add_control(
      'product_features',
      [
        'label' => __('product features', 'leora'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__( 'product features' , 'leora' ),
      ]
    );
    $repeater = new \Elementor\Repeater();

    $repeater->add_control(
        'list_title', [
            'label' => esc_html__( 'Title', 'leora' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'List Title' , 'leora' ),
            'label_block' => true,
        ]
    );

    $this->add_control(
        'list',
        [
            'label' => esc_html__( 'Repeater List', 'leora' ),
            'type' => \Elementor\Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'list_title' => esc_html__( 'Title #1', 'leora' ),
                ],
                [
                    'list_title' => esc_html__( 'Title #2', 'leora' ),
                ],
            ],
            'title_field' => '{{{ list_title }}}',
        ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'section_style',
      [
        'label' => __('General', 'leora'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
        'wid_section_icon_radius',
        [
            'label' => __( 'border radius', 'leora' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .affiliate-ml' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]
    );
    $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
            'name' => 'box_shadow_affiliate',
            'label' => esc_html__( 'Box Shadow', 'leora' ),
            'selector' => '{{WRAPPER}} .affiliate-ml',
        ]
    );
    $this->add_control(
      'background_color_back',
      [
        'label' => __('background', 'leora'),
        'type' => \Elementor\Controls_Manager::COLOR,
        
        'default' => '#fff',
        'selectors' => [
          '{{WRAPPER}} .affiliate-ml' => 'background: {{VALUE}}!important',
        ],
      ]
    );
    $this->add_control(
      'title_color',
      [
        'label' => __('title', 'leora'),
        'type' => \Elementor\Controls_Manager::COLOR,
        
        'default' => '#273338',
        'selectors' => [
          '{{WRAPPER}} .affiliate-ml .title-bax a' => 'color: {{VALUE}}!important;',
        ],
      ]
    );
    $this->add_control(
      'title_color_line',
      [
        'label' => __('border color', 'leora'),
        'type' => \Elementor\Controls_Manager::COLOR,
        
        'default' => '#eee',
        'selectors' => [
          '{{WRAPPER}} .affiliate-ml .line-al-b' => 'border-color: {{VALUE}}!important;',
        ],
      ]
    );
    $this->add_control(
        'title_color_parameters',
        [
          'label' => __('title list', 'leora'),
          'type' => \Elementor\Controls_Manager::COLOR,
          
          'default' => '#6f777a',
          'selectors' => [
            '{{WRAPPER}} .affiliate-ml .product-parameters ul p span' => 'color: {{VALUE}}!important;',
          ],
        ]
      );
      $this->add_control(
        'title_color_list',
        [
          'label' => __('color list', 'leora'),
          'type' => \Elementor\Controls_Manager::COLOR,
          
          'default' => '#242424 ',
          'selectors' => [
            '{{WRAPPER}} .affiliate-ml .product-parameters ul li' => 'color: {{VALUE}}!important;',
          ],
        ]
      );
    $this->end_controls_section();
    $this->start_controls_section(
        'section_style_2',
        [
          'label' => __('button', 'leora'),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'button_background_color',
        [
          'label' => __('background', 'leora'),
          'type' => \Elementor\Controls_Manager::COLOR,
          
          'default' => '#e6512b',
          'selectors' => [
            '{{WRAPPER}} .affiliate-ml .info-cart a' => 'background: {{VALUE}}!important;',
          ],
        ]
      );   
    $this->add_control(
      'button_color',
      [
        'label' => __('color', 'leora'),
        'type' => \Elementor\Controls_Manager::COLOR,
        
        'default' => '#fff',
        'selectors' => [
          '{{WRAPPER}} .affiliate-ml .info-cart a' => 'color: {{VALUE}}!important;',
        ],
      ]
    );
    $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
            'name' => 'box_shadow_info-cart',
            'label' => esc_html__( 'Box Shadow', 'leora' ),
            'selector' => '{{WRAPPER}} .affiliate-ml .info-cart a',
        ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'section_style_images',
      [
        'label' => __('images', 'leora'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'wid_images_radius',
      [
          'label' => __( 'border radius', 'leora' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px', '%', 'em' ],
          'selectors' => [
              '{{WRAPPER}} .affiliate-ml .images img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
      ]
  );
		$this->add_control(
			'width_images',
			[
				'label' => esc_html__( 'Width', 'leora' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 5,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 300,
				],
				'selectors' => [
					'{{WRAPPER}} .affiliate-ml .images img' => 'width: {{SIZE}}{{UNIT}}!important;',
				],
			]
		);
		$this->add_control(
			'width_height',
			[
				'label' => esc_html__( 'height', 'leora' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 5,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 300,
				],
				'selectors' => [
					'{{WRAPPER}} .affiliate-ml .images img' => 'height: {{SIZE}}{{UNIT}}!important;',
				],
			]
		);
    $this->end_controls_section();
    $this->start_controls_section(
        'section_style_score',
        [
          'label' => __('score', 'leora'),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'background_color_score',
        [
          'label' => __('background', 'leora'),
          'type' => \Elementor\Controls_Manager::COLOR,
          
          'default' => '#4d4d4d',
          'selectors' => [
            '{{WRAPPER}} .affiliate-ml .pick_ribbon' => 'background: {{VALUE}}!important;',
          ],
        ]
      ); 
      $this->add_control(
        'color_score',
        [
          'label' => __('color', 'leora'),
          'type' => \Elementor\Controls_Manager::COLOR,
          
          'default' => '#fff',
          'selectors' => [
            '{{WRAPPER}} .affiliate-ml .pick_ribbon span' => 'color: {{VALUE}}!important;',
          ],
        ]
      ); 
      $this->add_control(
        'icon_score',
        [
          'label' => __('icon', 'leora'),
          'type' => \Elementor\Controls_Manager::COLOR,
          
          'default' => '#fac74b',
          'selectors' => [
            '{{WRAPPER}} .affiliate-ml .pick_ribbon i' => 'color: {{VALUE}}!important;',
          ],
        ]
      );
      $this->end_controls_section();
  }
  private function grid_pagination_section()
  {
    $this->start_controls_section(
      'section_grid_pagination',
      [
        'label'     => __('Pagination', 'leora'),
        'condition' => [
          'section_grid.grid_pagination' => 'yes',
        ],
      ]
    );

    // Pagination alignment.
    $this->add_responsive_control(
      'grid_pagination_alignment',
      [
        'label'     => __('Alignment', 'leora'),
        'type'      => \Elementor\Controls_Manager::CHOOSE,
        'options'   => [
          'left'    => [
            'title' => __('Left', 'leora'),
            'icon'  => 'fa fa-align-left',
          ],
          'center'  => [
            'title' => __('Center', 'leora'),
            'icon'  => 'fa fa-align-center',
          ],
          'right'   => [
            'title' => __('Right', 'leora'),
            'icon'  => 'fa fa-align-right',
          ],
        ],
        'default'   => 'center',
        'tablet_default'   => 'center',
        'mobile_default'   => 'center',
        'selectors' => [
          '{{WRAPPER}} .obfx-grid-pagination .pagination' => 'text-align: {{VALUE}};',
        ],
      ]
    );

    $this->end_controls_section();
  }
  private function grid_pagination_style_section()
  {
    // Tab.
    $this->start_controls_section(
      'section_grid_pagination_style',
      [
        'label' => __('Pagination', 'leora'),
        'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
        'condition' => [
          'section_grid.grid_pagination' => 'yes',
        ],
      ]
    );

    // Image margin.
    $this->add_control(
      'grid_pagination_style_margin',
      [
        'label'      => __('Margin', 'leora'),
        'type'       => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px'],
        'selectors'  => [
          '{{WRAPPER}} .obfx-grid-pagination .pagination' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->end_controls_section();
  }

  protected function render()
  {
    $settings = $this->get_settings(); ?>
    <article class="container affiliate-ml">
        <div class="row">
            <div class="col-6 info-cart">
            <?php if ($settings['title_more']): ?>
                <a href="<?php echo $settings['website_link']['url'] ?>" target="_blank" rel="nofollow">
                    <?php echo $settings['title_more']; ?>
                </a>
            <?php endif; ?>
            </div>
            <div class="col-6">
                <?php if ($settings['score']): ?>
                <div class="pick_ribbon">
                    <i class="fa fa-star star"></i>
                    <span><?php echo $settings['score']; ?></span>
                </div>
                <?php endif; ?>
            </div>
            <span class="line-al-b"></span>
            <div class="col-12 title-bax">
                <h2>
                    <a href="<?php echo $settings['website_link']['url'] ?>" target="_blank" rel="nofollow"><?php echo $settings['title']; ?></a>
                </h2>
            </div>
          </div>
            <div class="row">
              <?php if ($settings['show_features']):?>
              <div class="col-12 col-md-6 product-parameters">
                  <ul>
                      <p>
                          <span><?php echo $settings['product_features']; ?></span>
                      </p>
                      <?php
                          if ( $settings['list'] ) {
                              foreach (  $settings['list'] as $item ) {
                                  echo '<li class="elementor-repeater-item-' . esc_attr( $item['_id'] ) . '">' . $item['list_title'] . '</li>';
                              }
                          }
                      ?>
                  </ul>
              </div>
              <?php endif; ?>
              <div class="col-12 images col-md-<?php if ($settings['show_features']): echo '6';else: echo '12';endif;?>">
                  <span class="media-image-wrap">
                    <img alt="<?php echo \Elementor\Control_Media::get_image_alt( $settings['image'] ); ?>" src="<?php echo $settings['image']['url']; ?>" style="<?php if (!$settings['show_features']):echo 'float:none;margin: 0 auto;'; endif; ?>" title="<?php echo \Elementor\Control_Media::get_image_title( $settings['image'] ); ?>">
                  </span>
              </div>
            <div class="content sin-content" style="padding:1rem">
                <?php echo $settings['list_content']; ?>
            </div>
        </div>
    </article>
<?php
  }
}
