<?php
function loadfiles()
{
  wp_enqueue_style('bootstrap-rtl', get_template_directory_uri() . '/assets/css/bootstrap.min.css', false, null);
  wp_enqueue_style('owl.carousel', get_template_directory_uri() . '/assets/css/owl.carousel.min.css', false);
  wp_enqueue_style('style', get_template_directory_uri() . '/assets/css/style.min.css', false, null);
  wp_enqueue_style('shop', get_template_directory_uri() . '/assets/css/shop.min.css', false, null);
  wp_enqueue_style('Responsive', get_template_directory_uri() . '/assets/css/Responsive.min.css', false, null);
  wp_enqueue_style('fontawesome', get_template_directory_uri() . '/assets/fontawesome/css/all.min.css', false, null);
}
function rpthem_enqueue_script()
{
  wp_enqueue_script('barsa', get_template_directory_uri() . '/assets/js/barsa.min.js', array(), '1.0', 'true');
  wp_deregister_script('jquery');
  wp_enqueue_script('jquery', get_template_directory_uri() . '/assets/js/jquery.js', array(), '1.0', 'true');
  wp_enqueue_script('fontawesome', get_template_directory_uri() . '/assets/js/kit.fontawesome.js', 'true');
  wp_enqueue_script('sticky-sidebar', get_template_directory_uri() . '/assets/js/theia-sticky-sidebar.min.js', array(), '1.0', 'true');
  wp_enqueue_script('owl.carousel', get_template_directory_uri() . '/assets/js/owl.carousel.js', array(), '1.0', 'true');
  wp_enqueue_script('theme-theme', get_template_directory_uri(), array('js-cookie'), 'true');
  wp_enqueue_script('read-more', get_template_directory_uri() . '/assets/js/read-more.min.js', array(), '1.0', 'true');
  wp_register_script('ajax-search', get_template_directory_uri() . '/assets/js/ajax-search.min.js','','1.1', true);
  wp_enqueue_script('ajax-search');
  wp_localize_script(
    'ajax-search',
    'opt',
    array(
      'ajaxUrl'   => admin_url('admin-ajax.php'),
      'noResults' => esc_html__('No products found', 'liam'),
    )
  );
  if (is_singular() && comments_open() && get_option('thread_comments')) {
    wp_enqueue_script('comment-reply');
  }
}
add_action('wp_enqueue_scripts', 'rpthem_enqueue_script');
add_action('wp_enqueue_scripts', 'loadfiles');
// add defer js file

// Update js within in Admin
function custom_admin_js()
{
  wp_enqueue_script('admin', get_template_directory_uri() . '/assets/admin/js/admin.min.js', array(), '1.0', 'true');
}
add_action('admin_footer', 'custom_admin_js');
// Update CSS within in Admin
function admin_style()
{
  wp_enqueue_style('admin-styles', get_template_directory_uri() . '/assets/admin/css/admin.min.css');
}
add_action('admin_enqueue_scripts', 'admin_style');
// register menus
function configmenus()
{
  register_nav_menus(
    array(
      'main-menu-two' => __('Main menu store', 'leora'),
      'main-menu-mobile-shop' => __('Mobile Store Menu', 'leora'),
      'main-menu' => __(' main menu', 'leora'),
      'main-menu-mobile' => __('Menu Mobile', 'leora'),
      'hashtag-menu' => __('hashtag menu ', 'leora'),
      'suggestion-menu' => __('suggestion menu ', 'leora'),
      'footer-menu' => __('Footer menu ', 'leora'),
      'menu-bar-head' => __('menu bar', 'leora'),
      'menu-bar-head2' => __('menu bar 2', 'leora'),
    )
  );
}
add_action('init', 'configmenus');
// register sidebar
function widgetregister()
{
  if (function_exists('register_sidebar'))
    register_sidebar(array(
      'name'          => __('Store sidebar', 'leora'),
      'id'            => 'sidebar-shop',
      'before_widget' => '<div class="sidebar-area sid-produt">',
      'after_widget'  => '</div>',
      'before_title'  => '<h4 class="side-title"><span>',
      'after_title'   => '</span></h4>',
    ));
    register_sidebar(array(
      'name'          => __('left sidebar', 'leora'),
      'id'            => 'leftsidebar',
      'before_widget' => '<div class="sidebar-area">',
      'after_widget'  => '</div>',
      'before_title'  => '<h4 class="side-title"><span>',
      'after_title'   => '</span></h4>',
    ));
  register_sidebar(array(
    'name'          => __('right sidebar', 'leora'),
    'id'            => 'rightsidebar',
    'before_widget' => '<div class="sidebar-area">',
    'after_widget'  => '</div>',
    'before_title'  => '<h4 class="side-title"><span>',
    'after_title'   => '</span></h4>',
  ));
  register_sidebar(array(
    'name'          => __('download sidebar', 'leora'),
    'id'            => 'downloadsidebar',
    'before_widget' => '<div class="sidebar-area">',
    'after_widget'  => '</div>',
    'before_title'  => '<h4 class="side-title"><span>',
    'after_title'   => '</span></h4>',
  ));
  register_sidebar(array(
    'name'          => __('mobile sidebar', 'leora'),
    'id'            => 'mobilesidebar',
    'before_widget' => '<div class="sidebar-area">',
    'after_widget'  => '</div>',
    'before_title'  => '<h4 class="side-title"><span>',
    'after_title'   => '</span></h4>',
  ));
  register_sidebar(array(
    'name'          => __('page sidebar', 'leora'),
    'id'            => 'pagesidebar',
    'before_widget' => '<div class="sidebar-area">',
    'after_widget'  => '</div>',
    'before_title'  => '<h4 class="side-title"><span>',
    'after_title'   => '</span></h4>',
  ));
  register_sidebar(array(
    'name'          => __('page sidebar left', 'leora'),
    'id'            => 'pageleftsidebar',
    'before_widget' => '<div class="sidebar-area">',
    'after_widget'  => '</div>',
    'before_title'  => '<h4 class="side-title"><span>',
    'after_title'   => '</span></h4>',
  ));
  register_sidebar(array(
    'name'          => __('First column footer', 'leora'),
    'id'            => 'footerone',
    'before_widget' => '',
    'after_widget'  => '',
    'before_title'  => '<h5 class="title-section">',
    'after_title'   => '</h5>',
  ));
  register_sidebar(array(
    'name'          => __('Second column footer', 'leora'),
    'id'            => 'footertwo',
    'before_widget' => '',
    'after_widget'  => '',
    'before_title'  => '<h5 class="title-section">',
    'after_title'   => '</h5>',
  ));
  register_sidebar(array(
    'name'          => __('Third column footer', 'leora'),
    'id'            => 'footerthree',
    'before_widget' => '',
    'after_widget'  => '',
    'before_title'  => '<h5 class="title-section">',
    'after_title'   => '</h5>',
  ));
  register_sidebar(array(
    'name'          => __('fourth column footer', 'leora'),
    'id'            => 'footerfour',
    'before_widget' => '',
    'after_widget'  => '',
    'before_title'  => '<h5 class="title-section">',
    'after_title'   => '</h5>',
  ));
}
add_action('widgets_init', 'widgetregister');
// post readmore
function new_excerpt_more($more)
{
  global $post;
  return '<span class="post-readmore"><a target="_blank" class="post-readmore" href="' . get_permalink($post->ID) . '"> ادامه مطلب</a></span></p>';
}
function custom_excerpt_length($length)
{
  return 35;
}
add_filter('excerpt_more', 'new_excerpt_more');
// locate template
add_filter('excerpt_length', 'custom_excerpt_length', 999);
locate_template('includes/framework/widgets/widget-ads.php',      true, true);
locate_template('includes/framework/widgets/widget-posts.php',    true, true);
locate_template('includes/framework/widgets/widget-video.php',    true, true);
locate_template('includes/metabox/version-down.php',              true, true);
locate_template('includes/metabox/select-header.php',              true, true);
if (!isset($content_width)) $content_width = 618;
require_once(get_template_directory() . '/includes/framework/functions/theme-functions.php');
require_once(get_template_directory() . '/includes/custom-search.php');
require_once(get_template_directory() . '/includes/woocomerce/wo-function.php');
require_once(get_template_directory() . '/includes/framework/widgets/sid-single-shop.php');
require_once(get_template_directory() . '/includes/css.php');
require_once(get_template_directory() . '/includes/breadcrumbs.php');
require_once(get_template_directory() . '/includes/elementor/elementor.php');
require_once(get_template_directory() . '/includes/notification.php');
require_once(get_template_directory() . '/includes/jdatetime.class.php');
// load theme textdomain
add_action('init' , function(){

  if ( version_compare( $GLOBALS['wp_version'], '6.7', '<' ) ) {
    load_theme_textdomain( 'leora', get_template_directory() . '/language' );
  } else {
    load_textdomain( 'leora', get_template_directory() . '/language/' . determine_locale() . '.mo' );
  }
  
});
// add mega menu for elementor
require_once(get_template_directory() . '/includes/mega-menu/admin/class-admin-assets.php');
require_once(get_template_directory() . '/includes/mega-menu/admin/class-admin.php');
require_once(get_template_directory() . '/includes/mega-menu/class-menu-item-post-type.php');
require_once(get_template_directory() . '/includes/mega-menu/class-menu-walker.php');
require_once(get_template_directory() . '/includes/mega-menu/core-functions.php');
require_once(get_template_directory() . '/includes/mega-menu/hook-functions.php');
require_once(get_template_directory() . '/themeplat/user/profile-edit-user.php');
require_once(get_template_directory() . '/includes/woocomerce/ajax-search/ajax-search.php');
// img responsive
function img_responsive($content)
{
  return str_replace('<img class="', '<img class="img-responsive ', $content);
}
add_filter('the_content', 'img_responsive');
/*
 * Set post views count using post meta
 */
function getPostViews($postID)
{
  $count_key = 'post_views_count';
  $count = get_post_meta($postID, $count_key, true);
  if ($count == '') {
    delete_post_meta($postID, $count_key);
    add_post_meta($postID, $count_key, '0');
    return "0 بازدید";
  }
  return $count . ' بازدید';
}
function setPostViews($postID)
{
  $count_key = 'post_views_count';
  $count = get_post_meta($postID, $count_key, true);
  if ($count == '') {
    $count = 0;
    delete_post_meta($postID, $count_key);
    add_post_meta($postID, $count_key, '0');
  } else {
    $count++;
    update_post_meta($postID, $count_key, $count);
  }
}
remove_action('wp_head', 'adjacent_posts_rel_link_wp_head', 10, 0);
/*
add theme support woocommerce
*/
add_action('after_setup_theme', 'woocommerce_support');
function woocommerce_support()
{
  add_theme_support('woocommerce');
  add_theme_support('wc-product-gallery-zoom');
  add_theme_support('wc-product-gallery-lightbox');
  add_theme_support('wc-product-gallery-slider');
}
//comment
function mytheme_comment($comment, $args, $depth)
{
  if ('div' === $args['style']) {
    $tag       = 'div';
    $add_below = 'comment';
  } else {
    $tag       = 'li';
    $add_below = 'div-comment';
  } ?>
  <<?php echo $tag; ?> <?php comment_class(empty($args['has_children']) ? '' : 'parent'); ?> id="comment-<?php comment_ID() ?>"><?php
                                                                                                                                if ('div' != $args['style']) { ?>
      <div id="div-comment-<?php comment_ID() ?>" class="comment-body"><?php
                                                                                                                                } ?>
      <div class="comment-author vcard"><?php
                                        if ($args['avatar_size'] != 0) {
                                          echo get_avatar($comment, $args['avatar_size']);
                                        }
                                        printf(__('<cite class="fn">%s</cite> <span class="says-comment">says:</span>', 'leora'), get_comment_author_link()); ?>
      </div><?php
            if ($comment->comment_approved == '0') { ?>
        <em class="comment-awaiting-moderation"><?php esc_html__('Your comment is awaiting moderation.', 'leora'); ?></em><br /><?php
                                                                                                                              } ?>
      <div class="comment-meta commentmetadata">
        <a href="<?php echo htmlspecialchars(get_comment_link($comment->comment_ID)); ?>"><?php
                                                                                          /* translators: 1: date, 2: time */
                                                                                          printf(
                                                                                            __('%1$s at %2$s', 'leora'),
                                                                                            get_comment_date(),
                                                                                            get_comment_time()
                                                                                          ); ?>
        </a><?php
            edit_comment_link(__('(Edit)', 'leora'), '  ', ''); ?>
      </div>

      <?php comment_text(); ?>

      <div class="reply"><?php
                          comment_reply_link(
                            array_merge(
                              $args,
                              array(
                                'add_below' => $add_below,
                                'depth'     => $depth,
                                'max_depth' => $args['max_depth']
                              )
                            )
                          ); ?>
      </div><?php
            if ('div' != $args['style']) : ?>
      </div><?php
            endif;
          }
          add_theme_support('post-thumbnails');
          if (function_exists('add_image_size')) {
            add_image_size('thumb1', 300, false);
          }
          /* ----------------------------------------------------------------------- comment -----------------*/

          add_action('wp_enqueue_scripts', 'misha_ajax_comments_scripts');

          function misha_ajax_comments_scripts()
          {

            // I think jQuery is already included in your theme, check it yourself
            wp_enqueue_script('jquery');

            // just register for now, we will enqueue it below
            wp_register_script('ajax_comment', get_stylesheet_directory_uri() . '/assets/js/ajax-comment.min.js', array('jquery'), 'true');

              wp_localize_script('ajax_comment', 'misha_ajax_comment_params', array(
              'ajaxurl' => site_url() . '/wp-admin/admin-ajax.php'
            ));

            wp_enqueue_script('ajax_comment');
          }
          add_action('wp_ajax_ajaxcomments', 'misha_submit_ajax_comment'); // wp_ajax_{action} for registered user
          add_action('wp_ajax_nopriv_ajaxcomments', 'misha_submit_ajax_comment'); // wp_ajax_nopriv_{action} for not registered users

          function misha_submit_ajax_comment()
          {
            $comment = wp_handle_comment_submission(wp_unslash($_POST));
            if (is_wp_error($comment)) {
              $error_data = intval($comment->get_error_data());
              if (!empty($error_data)) {
                wp_die('<p>' . $comment->get_error_message() . '</p>', __('Comment Submission Failure', 'leora'), array('response' => $error_data, 'back_link' => true));
              } else {
                wp_die('Unknown error');
              }
            }
            $user = wp_get_current_user();
            do_action('set_comment_cookies', $comment, $user);
            $comment_depth = 1;
            $comment_parent = $comment->comment_parent;
            while ($comment_parent) {
              $comment_depth++;
              $parent_comment = get_comment($comment_parent);
              $comment_parent = $parent_comment->comment_parent;
            }
            $GLOBALS['comment'] = $comment;
            $GLOBALS['comment_depth'] = $comment_depth;
            $comment_html = '<li ' . comment_class('', null, null, false) . ' id="comment-' . get_comment_ID() . '">
		<article class="comment-body" id="div-comment-' . get_comment_ID() . '">
    <div class="apply_comment-user">
    <div class="comment-content">' . apply_filters('comment_text', get_comment_text($comment), $comment) . '</div>
			<footer class="comment-meta" style="margin-bottom:1rem;">
				<div class="comment-metadata">
					<a href="' . esc_url(get_comment_link($comment->comment_ID)) . '">' . sprintf(_x('%s پیش', '%s = human-readable time difference', 'leora'), human_time_diff(get_comment_time('U'), current_time('timestamp'))) . '</a>';

            if ($edit_link = get_edit_comment_link())
              $comment_html .= '<span class="edit-link"><a class="comment-edit-link" href="' . $edit_link . '">ویرایش</a></span>';

            $comment_html .= '</div>';
            if ($comment->comment_approved == '0')
              $comment_html .= '<p class="comment-awaiting-moderation">نظر شما در انتظار تایید است.</p>';

            $comment_html .= '</footer></div>
		</article>
	</li>';
            echo $comment_html;

            die();
          }
          /*------------------------------------------------------------------------ TIME POSTS -----------------------------------*/
          function days_ago()
          {
            $days = round((date('U') - get_the_time('U')) / (60 * 60 * 24));
            if ($days == 0) {
              echo "امروز";
            } elseif ($days == 1) {
              echo "دیروز";
            } else {
              echo "" . $days . " روز پیش";
            }
          }
          /* ------------------------------------------------------------------------- post views count panl worpress ------------*/
          function set_post_view_custom_field()
          {
            if (is_single()) {
              global $post;
              $post_id = $post->ID;
              $count = 1;
              $post_view_count = get_post_meta($post_id, 'post_view_count', true);
              if ($post_view_count) {
                $count = $post_view_count + 1;
              }
              update_post_meta($post_id, 'post_view_count', $count);
            }
          }
          add_action('wp_head', 'set_post_view_custom_field');
          function add_post_view_count_column($columns)
          {
            if (is_array($columns) && !isset($columns['post_view_count']))
              $columns['post_view_count'] = 'تعداد بازدید';
            return $columns;
          }
          add_filter('manage_posts_columns', 'add_post_view_count_column');
          function set_post_view_count_column($column_name, $post_ID)
          {
            if ($column_name == 'post_view_count') {
              $count = get_post_meta($post_ID, 'post_view_count', true);
              echo $count ? $count : 0;
            }
          }
          add_action('manage_posts_custom_column', 'set_post_view_count_column', 10, 2);
          /* ------------------------------------------------------------------------- post views count single ------------*/
          function get_post_view_count($post_id)
          {
            return get_post_meta($post_id, 'post_view_count', true);
          }
          /* ------------------------------------------------------------------------- thumbnails size ------------*/
          add_theme_support('post-thumbnails');
          if (function_exists('add_image_size')) {
            add_image_size('singlethumbnail', 900, false);
            add_image_size('singlenavigation', 50, 50, true);
            add_image_size('singledown', 200, false);
            add_image_size('thumb4', 1400, false);
            add_image_size('thumb5', 300, false);
          }
          /* -------------------------------------------------------css----------------------------------------------------------*/
          function add_css_advan()
          {
            if (ot_get_option('add_css_advan', false) != false) {
              echo '<style>' . ot_get_option('add_css_advan') . '</style>';
            }
          }
          add_action('wp_head', 'add_css_advan', 100);
          /* ------------------------------------------------------------------------- posts_per_page  ------------*/
          function wpdocs_five_posts_on_homepage($query)
          {
            if ($query->is_home() && $query->is_main_query()) {
              $query->set('posts_per_page', ot_get_option('item_arcive_blog'));
            }
          }
          add_action('pre_get_posts', 'wpdocs_five_posts_on_homepage');

          /* ------------------------------------------------------------------------- option tree ------------*/
          add_filter('ot_theme_mode', '__return_true');
          add_filter('ot_show_pages', '__return_false');
          require(trailingslashit(get_template_directory()) . 'option-tree/ot-loader.php');
          require(trailingslashit(get_template_directory()) . 'includes/theme-options.php');
          //The below code is to shift the price
          function ts_shuffle_variable_product_elements()
          {
            if (is_product()) {
              global $post;
              $product = wc_get_product($post->ID);
              if ($product->is_type('variable')) {
                remove_action('woocommerce_single_variation', 'woocommerce_single_variation', 10);
                add_action('woocommerce_before_variations_form', 'woocommerce_single_variation', 20);

                remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_title', 5);
                add_action('woocommerce_before_variations_form', 'woocommerce_template_single_title', 10);

                remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_excerpt', 20);
                add_action('woocommerce_before_variations_form', 'woocommerce_template_single_excerpt', 30);
              }
            }
          }
          add_action('woocommerce_before_single_product', 'ts_shuffle_variable_product_elements');
          //display active uploads svg
          function add_file_types_to_uploads($file_types)
          {
            $new_filetypes = array();
            $new_filetypes['svg'] = 'image/svg+xml';
            $file_types = array_merge($file_types, $new_filetypes);
            return $file_types;
          }
          add_filter('upload_mimes', 'add_file_types_to_uploads');
          function wpb_remove_version()
          {
            return '';
          }
          add_filter('the_generator', 'wpb_remove_version');
          function comicpress_copyright()
          {
            global $wpdb;
            $copyright_dates = $wpdb->get_results("
      SELECT
      YEAR(min(post_date_gmt)) AS firstdate,
      YEAR(max(post_date_gmt)) AS lastdate
      FROM
      $wpdb->posts
      WHERE
      post_status = 'publish'
      ");
            $output = '';
            if ($copyright_dates) {
              $copyright = " © " . $copyright_dates[0]->firstdate;
              if ($copyright_dates[0]->firstdate != $copyright_dates[0]->lastdate) {
                $copyright .= '-' . $copyright_dates[0]->lastdate;
              }
              $output = $copyright;
            }
            return $output;
          }
          remove_action('woocommerce_archive_description', 'woocommerce_taxonomy_archive_description', 10);
          function cat_cart_count($cat_name)
          {
            $count = 0; // Initializing
            foreach (WC()->cart->get_cart() as $cart_item) {
              if (has_term($term, 'product_cat', $cart_item['product_id']))
                $count += $cart_item['quantity'];
            }
            return $count == 0 ? false : $count;
          }

          add_filter('woocommerce_single_product_carousel_options', 'sf_update_woo_flexslider_options');
          function sf_update_woo_flexslider_options($options)
          {
            $options['directionNav'] = true;
            return $options;
          }
          function first_paragraph($content)
          {
            return preg_replace('/<p([^>]+)?>/', '<p$1 class="intro">', $content, 1);
          }
          add_filter('the_content', 'first_paragraph');

          if (is_404()) :
            get_header('home');
          endif;
          /* ------------------------------------------------------- Plugin Activation ----------------------------------------------------------*/
          require_once dirname(__FILE__) . '/includes/activation.php';

          add_action('tgmpa_register', 'my_theme_register_required_plugins');

          function my_theme_register_required_plugins()
          {

            $plugins = array(
              array(
                'name'      => 'Elementor',
                'slug'      => 'elementor',
                'required'  => true,
              ),
            );

            $config = array(
              'id'           => 'tgmpa',
              'default_path' => '',
              'menu'         => 'tgmpa-install-plugins',
              'parent_slug'  => 'themes.php',
              'capability'   => 'edit_theme_options',
              'has_notices'  => true,
              'dismissable'  => true,
              'dismiss_msg'  => '',
              'is_automatic' => false,
              'message'      => '',
            );

            tgmpa($plugins, $config);
          }
          /**
           * Removes some menus by page.
           */
          function remove_admin_menu_items()
          {
            remove_menu_page('yith_wcwl_panel');
          }
          add_action('admin_menu', 'remove_admin_menu_items', 9999);
          /**
           * contact page
           */
          function wpschool_contact_scripts()
          {
            wp_register_script('ajax-contact-script', get_template_directory_uri() . '/assets/js/ajax-contact-script.js', array('jquery'));
            wp_enqueue_script('ajax-contact-script');

            wp_localize_script('ajax-contact-script', 'ajax_contact_object', array(
              'ajax_url' => admin_url('admin-ajax.php'),
              'loading_message' => esc_html__('در حال ارسال اطلاعات ، لطفا صبر کنید...', 'leora')
            ));
          }
          add_action('wp_enqueue_scripts', 'wpschool_contact_scripts');

          function wpschool_ajax_contact()
          {
            $hasError = false;
            if (trim($_POST['contactName']) === '') {
              $message = 'لطفا نام خود را وارد نمایید';
              $hasError = true;
            } else {
              $name =  sanitize_text_field($_POST['contactName']);
            }
            if (trim($_POST['email']) === '') {
              $message = 'لطفا آدرس ایمیل خود را وارد نمایید.';
              $hasError = true;
            } else if (!preg_match("/^[[:alnum:]][a-z0-9_.-]*@[a-z0-9.-]+\.[a-z]{2,4}$/i", trim($_POST['email']))) {
              $message = 'آدرس ایمیل وارد شده صحیح نمی باشد';
              $hasError = true;
            } else {
              $email =  sanitize_text_field($_POST['email']);
            }
            if (trim($_POST['commentsText']) === '') {
              $message = 'لطفا پیام خود را وارد نمایید';
              $hasError = true;
            } else {
              $comments = esc_textarea($_POST['commentsText']);
            }
            if (!$hasError) {
              $emailTo = get_option('admin_email');
              $subject = 'یک پیغام از طرف ' . $name;
              $body = "نام فرستنده: $name \n\nایمیل نویسنده: $email \n\nپیغام: $comments";
              $headers = 'From: ' . $name . ' <contact@wpsho.com> ' . "\r\n" . 'Reply-To: ' . $email;
              wp_mail($emailTo, $subject, $body, $headers);
              $message = esc_html__('پیام شما با موفقیت ارسال شد، با تشکر از شما', 'leora');
            }
            echo json_encode(array('error' => $hasError, 'message' => $message));
            die();
          }
          add_action('wp_ajax_wpschool_ajax_contact', 'wpschool_ajax_contact');
          add_action('wp_ajax_nopriv_wpschool_ajax_contact', 'wpschool_ajax_contact');
          /**
           * Remove the breadcrumbs 
           */
          add_action('init', 'woo_remove_wc_breadcrumbs');
          function woo_remove_wc_breadcrumbs()
          {
            remove_action('woocommerce_before_main_content', 'woocommerce_breadcrumb', 20, 0);
          }
          /* upload img profil */
          add_action('woocommerce_before_edit_account_form', 'wc_cus_cpp_form');
          function wc_cus_cpp_form($atts, $content = NULL)
          {

            $user_id = get_current_user_id();

            if (isset($_GET['action']) && $_GET['action'] == 'delete') {
              $picture_id = get_user_meta($user_id, 'profile_pic', true);
              delete_user_meta($user_id, 'profile_pic');
              wp_delete_post($picture_id, true);
            }
            if ($_FILES and trim($_FILES['profile_pic']['name']) != '') {
              $picture_id = wc_cus_upload_picture($_FILES['profile_pic']);
              wc_cus_save_profile_pic($picture_id, $user_id);
            }
            $picture_id = get_user_meta($user_id, 'profile_pic', true);

            if (trim($picture_id) == '') :
              $delete_link = '';
            else :
              $delete_link = '<a href="' . get_permalink(get_option('woocommerce_myaccount_page_id')) . '/edit-account/?action=delete">حذف</a>';
            endif;
            echo '<div class="wc_cus_cpp_form">';
            echo get_avatar($user_id) . '<br>';
            echo '</div>';
            echo '<label class="label_getFile" for="getFile">تصویر پروفایل</label>';
            echo '<div class="form_group_profile_pic">';
            echo $delete_link;
            echo '
        <form enctype="multipart/form-data" action="" method="POST">
        <label for="choose-file" class="custom-file-upload" id="choose-file-label">
          انتخاب تصویر
        </label>
        <input  name="profile_pic" size="25" type="file" id="choose-file" 
        accept=".jpg,.jpeg,.pdf,doc,docx,application/msword,.png" style="display: none;" />
        <input class="form_sub" value="جایگذاری" type="submit">
        </form>
    ';
            echo '</div>';
          }
          function wc_cus_save_profile_pic($picture_id, $user_id)
          {
            update_user_meta($user_id, 'profile_pic', $picture_id);
          }
          function wc_cus_upload_picture($foto)
          {
            $wordpress_upload_dir = wp_upload_dir();
            $i = 1; // number of tries when the file with the same name is already exists
            $profilepicture = $foto;
            $new_file_path = $wordpress_upload_dir['path'] . '/' . $profilepicture['name'];
            $check = getimagesize($profilepicture['tmp_name']);
            $new_file_mime = $check["mime"];

            $log = new WC_Logger();

            if (empty($profilepicture))
              $log->add('custom_profile_picture', 'File is not selected.');
            if ($profilepicture['error'])
              $log->add('custom_profile_picture', $profilepicture['error']);

            if ($profilepicture['size'] > wp_max_upload_size())
              $log->add('custom_profile_picture', 'It is too large than expected.');

            if (!in_array($new_file_mime, get_allowed_mime_types()))
              $log->add('custom_profile_picture', 'WordPress doesn\'t allow this type of uploads.');
            while (file_exists($new_file_path)) {
              $i++;
              $new_file_path = $wordpress_upload_dir['path'] . '/' . $i . '_' . $profilepicture['name'];
            }
            // looks like everything is OK
            if (move_uploaded_file($profilepicture['tmp_name'], $new_file_path)) {

              $upload_id = wp_insert_attachment(array(
                'guid'           => $new_file_path,
                'post_mime_type' => $new_file_mime,
                'post_content'   => '',
                'post_status'    => 'inherit'
              ), $new_file_path);

              require_once(str_replace(esc_url(home_url()) . '/', ABSPATH, get_admin_url()) . 'includes/image.php');
              wp_update_attachment_metadata($upload_id, wp_generate_attachment_metadata($upload_id, $new_file_path));
              return $upload_id;
            }
          }
          add_filter('get_avatar', 'wc_cus_change_avatar', 1, 5);
          function wc_cus_change_avatar($avatar, $id_or_email, $size, $default, $alt)
          {
            $user = false;
            if (is_numeric($id_or_email)) {
              $id = (int) $id_or_email;
              $user = get_user_by('id', $id);
            } elseif (is_object($id_or_email)) {
              if (!empty($id_or_email->user_id)) {
                $id = (int) $id_or_email->user_id;
                $user = get_user_by('id', $id);
              }
            } else {
              $user = get_user_by('email', $id_or_email);
            }
            if ($user && is_object($user)) {
              $picture_id = get_user_meta($user->data->ID, 'profile_pic');
              if (!empty($picture_id)) {
                $avatar = wp_get_attachment_url($picture_id[0]);
                $avatar = "<img alt='{$alt}' src='{$avatar}' class='avatar avatar-{$size} photo' height='{$size}' width='{$size}' />";
              }
            }
            return $avatar;
          }
          add_action('after_setup_theme', 'wpse_theme_setup');
          function wpse_theme_setup()
          {
            add_theme_support('title-tag');
          }
          /* add fild user social */
          function thewebsitedev_user_social_links($user_contact)
          {
            $user_contact['facebook'] = __('facebook Link', 'topaz');
            $user_contact['twitter'] = __('twitter Link', 'topaz');
            $user_contact['dribbble'] = __('dribbble Link', 'topaz');
            $user_contact['instagram'] = __('instagram Link', 'topaz');
            $user_contact['pinterest'] = __('pinterest Link', 'topaz');
            $user_contact['linkedin'] = __('linkedIn Link', 'topaz');
            $user_contact['googleplus'] = __('google+ Link', 'topaz');
            return $user_contact;
          }
          add_filter('user_contactmethods', 'thewebsitedev_user_social_links');
          // Function to return user count
          function a4fran3_user_count()
          {
            $usercount = count_users();
            $result = $usercount['total_users'];
            return $result;
          }
          add_shortcode('number_users', 'a4fran3_user_count');
          /* Set post views count , Display Popular Posts By Views*/
          function shapeSpace_popular_posts($post_id)
          {
            $count_key = 'popular_posts';
            $count = get_post_meta($post_id, $count_key, true);
            if ($count == '') {
              $count = 0;
              delete_post_meta($post_id, $count_key);
              add_post_meta($post_id, $count_key, '0');
            } else {
              $count++;
              update_post_meta($post_id, $count_key, $count);
            }
          }
          function shapeSpace_track_posts($post_id)
          {
            if (!is_single()) return;
            if (empty($post_id)) {
              global $post;
              $post_id = $post->ID;
            }
            shapeSpace_popular_posts($post_id);
          }
          add_action('wp_head', 'shapeSpace_track_posts');
          /* ------------------------------------------------------- add password and fild custom for login users ----------------------------------------------------------*/
          add_action( 'register_form', 'myplugin_register_form' );
function myplugin_register_form() {

  $first_name = ( ! empty( $_POST['first_name'] ) ) ? trim( $_POST['first_name'] ) : '';
  $last_name = ( ! empty( $_POST['last_name'] ) ) ? trim( $_POST['last_name'] ) : '';

      ?>
      <div class="first-name">
        <input type="text" name="first_name" id="first_name" class="input" value="<?php echo esc_attr( wp_unslash( $first_name ) ); ?>" size="25" placeholder="نام"/></label>
      <div>
      </div class="last-name">
        <input type="text" name="last_name" id="last_name" class="input" value="<?php echo esc_attr( wp_unslash( $last_name ) ); ?>" size="25" placeholder="نام خانوادگی"/></label>
      </div>

      <?php
  }
  //2. Add validation. In this case, we make sure first_name is required.
  add_filter( 'registration_errors', 'myplugin_registration_errors', 10, 3 );
  function myplugin_registration_errors( $errors, $sanitized_user_login, $user_email ) {

      if ( empty( $_POST['first_name'] ) || ! empty( $_POST['first_name'] ) && trim( $_POST['first_name'] ) == '' ) {
          $errors->add( 'first_name_error', __( '<strong>خطا</strong>:نام خود را وارد کنید', 'leora' ) );
      }
      if ( empty( $_POST['last_name'] ) || ! empty( $_POST['last_name'] ) && trim( $_POST['last_name'] ) == '' ) {
   $errors->add( 'last_name_error', __( '<strong>خطا</strong>: نام خانوادگی خود را وارد کنید', 'leora' ) );
 }
      return $errors;
  }

  //3. Finally, save our extra registration user meta.
  add_action( 'user_register', 'myplugin_user_register' );
  function myplugin_user_register( $user_id ) {
      if ( ! empty( $_POST['first_name'] ) ) {
          update_user_meta( $user_id, 'first_name', trim( $_POST['first_name'] ) );
          update_user_meta( $user_id, 'last_name', trim( $_POST['last_name'] ) );
      }
  }
add_action( 'register_form', 'ts_show_extra_register_fields' );
function ts_show_extra_register_fields(){
?>
<div class="passwordarea">
  <input id="password" type="password" tabindex="30" size="35" value="" name="password" placeholder="پسورد"/>
</div>
<div class="repeat-password">
  <input id="repeat_password" type="password" tabindex="40" size="35" value="" name="repeat_password" placeholder="تکرار پسورد"/>
</div>
<?php
}

add_action( 'register_post', 'ts_check_extra_register_fields', 10, 3 );
function ts_check_extra_register_fields($login, $email, $errors) {
if ( $_POST['password'] !== $_POST['repeat_password'] ) {
$errors->add( 'passwords_not_matched', "!خطا: پسوردها هماهنگ نیست" );
}
if ( strlen( $_POST['password'] ) < 6 ) {
$errors->add( 'password_too_short', "!خطا: رمز عبور باید بیشتر از ۶ حزف باشد" );
}
}

add_action( 'user_register', 'ts_register_extra_fields', 100 );
function ts_register_extra_fields( $user_id ){
$userdata = array();
$userdata['ID'] = $user_id;
if ( $_POST['password'] !== '' ) {
$userdata['user_pass'] = $_POST['password'];
}
$new_user_id = wp_update_user( $userdata );
}

add_filter( 'gettext', 'ts_edit_password_email_text' );
function ts_edit_password_email_text ( $text ) {
if ( $text == 'پسورد برای شما ایمیل خواهد شد' ) {
$text = 'اگر فیلد پسورد را خالی گذاشته اید. پسورد برای شما جنریت خواهد شد. رمز عبور باید بیش از ۵ حرف باشد.';
}
return $text;
}
/* ------------------------------------------------ add type icon article ----------------------------*/
add_action('type_article', 'add_icon_type');
function add_icon_type(){
  global $post;
  $tag_types = get_post_meta($post->ID, 'tag_types', true);
  echo '<span class="type_article_pad">';
  if ($tag_types == 'podcatch') {
    echo '<i class="fal fa-microphone"></i>';
  } elseif ($tag_types == 'video') {
    echo '<i class="fal fa-play"></i>';
  } elseif ($tag_types == 'images') {
    echo '<i class="fal fa-camera-retro"></i>';
  } elseif ($tag_types == 'survey') {
    echo '<i class="fal fa-ballot-check"></i>';
  }
  echo '</span>';
}

/* ------------------------------------------------ remove admin bar  ----------------------------*/

add_action('after_setup_theme', 'remove_admin_bar');
function remove_admin_bar() {
if (!current_user_can('administrator') && !is_admin()) {
  show_admin_bar(false);
}
}

/* ------------------------------------------------  top and down sidbar mobile ----------------------------*/
add_action('init', 'ot_theme_optionsn');
function ot_theme_optionsn(){
global $ot_has_custom_theme_options;
$select_top_dowm_widget_mobile = ot_get_option('select_tp_dowm_widget_mobile');
if ($select_top_dowm_widget_mobile == 'top') {
add_action('top_post_widget', 'top_sidbar_mobile');
function top_sidbar_mobile(){
  get_sidebar('mobile');
}
} elseif($select_top_dowm_widget_mobile == 'down'){
add_action('down_post_widget', 'down_sidbar_mobile');
function down_sidbar_mobile(){
  get_sidebar('mobile');
}
} 
} 
/* ------------------------------------------------ Modify the "must_log_in" string of the comment form ----------------------------
if (!is_user_logged_in()):
  add_filter( 'comment_form_defaults', function( $fields ) {
    $fields['must_log_in'] = sprintf( __(''), ); ?>
    <p class="must-log-in remo-woo">
      برای ارسال دیدگاه باید <a onclick="document.getElementById('id01').style.display='block'" href="#"> ثبت نام </a>یا 
      <a onclick="document.getElementById('id01').style.display='block'" href="#">وارد </a>شوید.
    </p>
    <?php
    return $fields;
  });
endif;
 ------------------------------------------------ register elementor locations ----------------------------*/
function leora_register_elementor_locations( $elementor_theme_manager ) {

	$elementor_theme_manager->register_all_core_location();

}
add_action( 'elementor/theme/register_locations', 'leora_register_elementor_locations' );
/* ------------------------------------------------ register theme leora ----------------------------
if ( ! class_exists( 'leora_theme_pl' ) ) {
class leora_theme_pl {

	private $name; 
	private $slug;
	private $parent_slug;
	private $text_domain;
	private static $option_name;
	private $product_token;
	public static $api_url = 'http://guard.zhaket.com/api/';
	private static $instance = null;
	public function __construct(array $settings) {
		$defaults = [
			'name'          => __('leora', 'leora'),
			'slug'          => 'leora_guard_register',
			'parent_slug'   => 'themes.php',
			'text_domain'   => 'leora',
			'product_token' => '90e77a14-bf33-4f32-9793-a7db18d31510',
			'option_name'   => 'leora_guard_register_settings'
		];
		foreach ( $settings as $key => $setting ) {
			if( array_key_exists($key, $defaults) && !empty($setting) ) {
				$defaults[$key] = $setting;
			}
		}
		$this->name = $defaults['name'];
		$this->slug = $defaults['slug'];
		$this->parent_slug = $defaults['parent_slug'];
		$this->text_domain = $defaults['text_domain'];
		self::$option_name = $defaults['option_name'];
		$this->product_token = $defaults['product_token'];

		add_action('admin_menu', array($this, 'admin_menu'));

		add_action('wp_ajax_'.$this->slug, array($this, 'wp_starter'));

		add_action('wp_ajax_'.$this->slug.'_revalidate', array($this, 'revalidate_starter'));

		add_action('init', array($this, 'schedule_programs'));

		add_action( $this->slug.'_daily_validator', array($this, 'daily_event') );

		add_action( 'admin_notices', array($this, 'admin_notice') );

	}

	public function admin_menu() {
		add_submenu_page(
			$this->parent_slug,
			__('add License ', 'leora'),
			__('add License ', 'leora'),
			'manage_options',
			$this->slug,
			array($this, 'menu_content')
		);
	}
	public function menu_content() {
		$option = get_option(self::$option_name);
		$now = json_decode(get_option($option));
		$starter = (isset($now->starter) && !empty($now->starter)) ? base64_decode($now->starter) : '';
		if( isset($_GET['debugger']) && !empty($_GET['debugger']) && $_GET['debugger'] === 'show' ) {
			$data_show = $option;
		} else {
			$data_show = '';
		}
		?>
        <style>
            form.register_version_form,
            .current_license {
                width: 80%;
                background: #fff;
                margin: 0 auto;
                padding: 20px 30px;
            }
            form.register_version_form  .license_key {
                padding: 5px 10px;
                width: calc( 100% - 110px );
            }

            form.register_version_form button {
                width: 100px;
                height: 40px;
                text-align: center;
            }

            form.register_version_form .result,
            .current_license .check_result {
                width: 100%;
                padding: 30px 0 15px;
                text-align: center;
                display: none;
            }
            .current_license .check_result {
                padding: 20px 0;
                float: right;
                width: 100%;
            }
            form.register_version_form .result .spinner,
            .current_license .check_result .spinner {
                width: auto;
                background-position: right center;
                padding-right: 30px;
                margin: 0;
                float: none;
                visibility: visible;
                display: none;
            }
            .current_license.waiting .check_result .spinner,
            form.register_version_form .result.show .spinner {
                display: inline-block;
            }
            .current_license {
                width: 80%;
                text-align: center;
            }
            .current_license > .current_label {
                line-height: 25px;
                height: 25px;
                display: inline-block;
                font-weight: bold;
                margin-left: 10px;
            }
            .current_license > code {
                line-height: 25px;
                height: 25px;
                padding: 0 5px;
                color: #c7254e;
                margin-left: 10px;
                display: inline-block;
                -webkit-transform: translateY(2px);
                -moz-transform: translateY(2px);
                -ms-transform: translateY(2px);
                -o-transform: translateY(2px);
                transform: translateY(2px);
            }
            .current_license .action {
                color: #fff;
                line-height: 25px;
                height: 25px;
                padding: 0 5px;
                display: inline-block;
            }
            .current_license .last_check {
                line-height: 25px;
                height: 25px;
                padding: 0 5px;
                display: inline-block;
            }
            .current_license .action.active {
                background: #4CAF50;
            }
            .current_license .action.inactive {
                background: #c7254e;
            }

            .current_license .keys {
                float: right;
                width: 100%;
                text-align: center;
                padding-top: 20px;
                border-top: 1px solid #ddd;
                margin-top: 20px;
            }
            .current_license .keys .wpmlr_revalidate {
                margin-left: 30px;
            }
            .current_license .register_version_form {
                display: none;
                padding: 0;
                float: right;
                width: 80%;
                margin: 20px 10%;
            }
            .zhk_guard_notice {
                background: #fff;
                border: 1px solid rgba(0,0,0,.1);
                border-right: 4px solid #00a0d2;
                padding: 5px 15px;
                margin: 5px;
            }
            .zhk_guard_danger {
                background: #fff;
                border: 1px solid rgba(0,0,0,.1);
                border-right: 4px solid #DC3232;
                padding: 5px 15px;
                margin: 5px;
            }
            .zhk_guard_success {
                background: #fff;
                border: 1px solid rgba(0,0,0,.1);
                border-right: 4px solid #46b450;
                padding: 5px 15px;
                margin: 5px;
            }
            @media (max-width: 1024px) {
                form.register_version_form,
                .current_license {
                    width: 90%;
                }
            }
        </style>
        <div class="wrap wpmlr_wrap" data-show="<?php echo $data_show ?>">
            <h1><?php _e('add License ', 'leora'); ?></h1>
			<?php if( isset($now) && !empty($now) ): ?>
                <p><?php _e('شما در حال حاضر لایسنس خود را ثبت کرده اید. برای بررسی مجدد لایسنس خود از این فرم استفاده کنید.', 'leora'); ?></p>
                <div class="current_license">
                    <span class="current_label"><?php _e('لایسنس ثبت شده:', 'leora'); ?></span>
                    <code><?php echo $starter; ?></code>
                    <div class="action <?php echo ($now->action == 1) ? 'active' : 'inactive'; ?>">
						<?php if( $now->action == 1 ): ?>
                            <span class="dashicons dashicons-yes"></span>
							<?php echo $now->message; ?>
						<?php else: ?>
                            <span class="dashicons dashicons-no-alt"></span>
							<?php echo $now->message; ?>
						<?php endif; ?>
                    </div>
                    <div class="keys">
                        <a href="#" class="button button-primary wpmlr_revalidate" data-key="<?php echo $starter; ?>"><?php _e('بررسی مجدد', 'leora'); ?></a>
                        <a href="#" class="button zhk_guard_new_key"><?php _e('حذف لایسنس فعلی و ثبت لایسنسی جدید', 'leora'); ?></a>
                    </div>

                    <form action="#" method="post" class="register_version_form">
                        <input type="text" class="license_key" placeholder="<?php _e('New license key', 'leora'); ?>">
                        <button class="button button-primary"><?php _e('add License ', 'leora'); ?></button>
                        <div class="result">
                            <div class="spinner"><?php _e('Please wait...', 'leora'); ?></div>
                            <div class="result_text"></div>
                        </div>
                    </form>

                    <div class="check_result">
                        <div class="spinner"><?php _e('Please wait...', 'leora'); ?></div>
                        <div class="result_text"></div>
                    </div>
                    <div class="clear"></div>
                </div>
			<?php else: ?>
                <p><?php _e('برای اینکه تمام ویژگی های قالب به درستی کار کنند لطفا کلید لایسنس خود را واردکنید.', 'leora'); ?></p>
                <form action="#" method="post" class="register_version_form">
                    <input type="text" class="license_key" placeholder="<?php _e('License key', 'leora'); ?>">
                    <button class="button button-primary"><?php _e('add License ', 'leora'); ?></button>
                    <div class="result">
                        <div class="spinner"><?php _e('Please wait...', 'leora'); ?></div>
                        <div class="result_text"></div>
                    </div>
                </form>
			<?php endif; ?>
            <script>
                jQuery(document).ready(function($) {
                    var ajax_url = "<?php echo admin_url('admin-ajax.php'); ?>";
                    jQuery(document).on('submit', '.register_version_form', function(event) {
                        event.preventDefault();
                        var starter = jQuery(this).find('.license_key').val(),
                            thisEl = jQuery(this);
                        thisEl.addClass('waiting');
                        thisEl.find('.result').slideDown(300).addClass('show');
                        thisEl.find('.button').addClass('disabled');
                        thisEl.find('.result_text').slideUp(300).html('');
                        jQuery.ajax({
                            url: ajax_url,
                            type: 'POST',
                            dataType: 'json',
                            data: {
                                action: '<?php echo $this->slug; ?>',
                                starter: starter
                            },
                        })
                            .done(function(result) {
                                thisEl.find('.result_text').append(result.data).slideDown(150)
                            })
                            .fail(function(result) {
                                thisEl.find('.result_text').append('<div class="zhk_guard_danger"><?php _e('Something goes wrong please try again.', 'leora'); ?></div>').slideDown(150)
                            })
                            .always(function(result) {
                                console.log(result);
                                thisEl.removeClass('waiting');
                                thisEl.find('.result').removeClass('show');
                                thisEl.find('.button').removeClass('disabled');
                            });
                    });

                    $(document).on('click', '.wpmlr_revalidate', function(event) {
                        event.preventDefault();
                        var starter = $(this).data('key'),
                            thisEl = $(this).parents('.current_license');
                        thisEl.addClass('waiting');
                        thisEl.find('.check_result').slideDown(300);
                        thisEl.find('.button').addClass('disabled');
                        thisEl.find('.result_text').slideUp(300).html('');
                        thisEl.find('.register_version_form').slideUp(300)
                        $.ajax({
                            url: ajax_url,
                            type: 'POST',
                            dataType: 'json',
                            data: {
                                action: '<?php echo $this->slug; ?>_revalidate',
                                starter: starter
                            },
                        })
                            .done(function(result) {
                                thisEl.find('.check_result .result_text').append(result.data).slideDown(150)
                            })
                            .fail(function(result) {
                                thisEl.find('.check_result .result_text').append('<div class="wpmlr_danger"><?php _e('Something goes wrong please try again.', 'leora'); ?></div>').slideDown(150)
                            })
                            .always(function(result) {
                                thisEl.removeClass('waiting');
                                thisEl.find('.button').removeClass('disabled');
                            });
                    });


                    $(document).on('click', '.zhk_guard_new_key', function(event) {
                        event.preventDefault();
                        var thisEl = $(this).parents('.current_license');
                        thisEl.find('.result_text').slideUp(300).html('');
                        thisEl.find('.register_version_form').slideDown(300)
                    });
                });
            </script>

        </div>
		<?php

	}

	/**
	 *
	
	public function wp_starter() {
		$starter = sanitize_text_field($_POST['starter']);
		if( empty($starter) ) {
			wp_send_json_error('<div class="zhk_guard_danger">'.__('Please insert your license code', 'leora').'</div>');
		}

		$private_session = get_option(self::$option_name);
		delete_option($private_session);

		$product_token = $this->product_token;
		$result = self::install($starter, $product_token);
		$output = '';

		if ($result->status=='successful') {
			$rand_key = md5(wp_generate_password(12, true, true));
			update_option(self::$option_name, $rand_key);
			$result = array(
				'starter' => base64_encode($starter),
				'action' => 1,
				'message' => __('لایسنس معتبر میباشد.', 'leora'),
				'timer' => time(),
			);
			update_option($rand_key, json_encode($result));
			$output = '<div class="zhk_guard_success">'.__('با تشکر! مجوز شما با موفقیت فعال شد.', 'leora').'</div>';
			wp_send_json_success($output);
		} else {
			if (!is_object($result->message)) {
				$output = '<div class="zhk_guard_danger">'.$result->message.'</div>';
				wp_send_json_error($output);
			} else {
				foreach ($result->message as $message) {
					foreach ($message as $msg) {
						$output .= '<div class="zhk_guard_danger">'.$msg.'</div>';
					}
				}
				wp_send_json_error($output);
			}
		}
	}
	public function admin_notice() {
		$private_session = get_option(self::$option_name);
		$now = json_decode(get_option($private_session));
		?>
		<?php if( empty($now) ): ?>
            <div class="notice notice-error">
                <p>
					<?php printf(__( 'برای فعال سازی قالب  %s لطفا کد لایسنس خود را وارد کنید.', 'leora' ), $this->name); ?>
                    <a href="<?php echo admin_url( 'admin.php?page='.$this->slug ); ?>" class="button button-primary"><?php _e('هم اینک ثبت کنید', 'leora'); ?></a>
                </p>
            </div>
		<?php elseif( $now->action != 1 ): ?>
            <div class="notice notice-error">
                <p>
					<?php printf(__( 'There is something wrong with your %s license. please check it.', 'leora' ), $this->name); ?>
                    <a href="<?php echo admin_url( 'admin.php?page='.$this->slug ); ?>" class="button button-primary"><?php _e('Check Now', 'leora'); ?></a>
                </p>
            </div>
		<?php endif; ?>
		<?php
	}
	public function revalidate_starter() {
		$starter = sanitize_text_field($_POST['starter']);
		if( empty($starter) ) {
			wp_send_json_error('<div class="zhk_guard_danger">'.__('Please insert your license code', 'leora').'</div>');
		}

		$result = self::is_valid($starter);
		if ($result->status=='successful') {
			$rand_key = md5(wp_generate_password(12, true, true));
			update_option(self::$option_name, $rand_key);
			$how = array(
				'starter' => base64_encode($starter),
				'action' => 1,
				'message' => $result->message,
				'timer' => time(),
			);
			update_option($rand_key, json_encode($how));
			$output = '<div class="zhk_guard_success">'.__('با تشکر! مجوز شما با موفقیت فعال شد.', 'leora').'</div>';
			wp_send_json_success($output);
		} else {
			$rand_key = md5(wp_generate_password(12, true, true));
			update_option(self::$option_name, $rand_key);
			$how = array(
				'starter' => base64_encode($starter),
				'action' => 0,
				'timer' => time(),
			);
			if (!is_object($result->message)) {
				$how['message'] = $result->message;
			} else {
				foreach ($result->message as $message) {
					foreach ($message as $msg) {
						$how['message'] = $msg;
					}
				}
			}
			update_option($rand_key, json_encode($how));
			$output = '<div class="zhk_guard_danger">'.$how['message'].'</div>';
			wp_send_json_success($output);
		}

	}
	public function schedule_programs() {
		if (! wp_next_scheduled ( $this->slug.'_daily_validator' )) {
			wp_schedule_event(time(), 'daily', $this->slug.'_daily_validator');
		}
	}
	public function daily_event() {
		$private_session = get_option(self::$option_name);
		$now = json_decode(get_option($private_session));
		if( isset($now) && !empty($now) ) {
			$starter = (isset($now->starter) && !empty($now->starter)) ? base64_decode($now->starter) : '';
			$result = self::is_valid($starter);
			if( $result != null ) {
				if ($result->status=='successful') {
					delete_option($private_session);
					$rand_key = md5(wp_generate_password(12, true, true));
					update_option(self::$option_name, $rand_key);
					$how = array(
						'starter' => base64_encode($starter),
						'action' => 1,
						'message' => $result->message,
						'timer' => time(),
					);
					update_option($rand_key, json_encode($how));
				} else {

					delete_option($private_session);
					$rand_key = md5(wp_generate_password(12, true, true));
					update_option(self::$option_name, $rand_key);
					$how = array(
						'starter' => base64_encode($starter),
						'action' => 0,
						'timer' => time(),
					);
					if (!is_object($result->message)) {
						$how['message'] = $result->message;
					} else {
						foreach ($result->message as $message) {
							foreach ($message as $msg) {
								$how['message'] = $msg;
							}
						}
					}
					update_option($rand_key, json_encode($how));
				}
			}
		}
	}
	public static function is_activated() {
		$private_session = get_option(self::$option_name);
		$now = json_decode(get_option($private_session));
		if( empty($now) ) {
			return false;
		} elseif($now->action != 1) {
			return false;
		} else {
			return true;
		}
	}
	public static function send_request( $method, $params=array() ) {
		$param_string = http_build_query($params);
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_URL,
			self::$api_url.$method.'?'.$param_string
		);
		$content = curl_exec($ch);
		return json_decode($content);
	}
	public static function is_valid($license_token)	{
		$result = self::send_request('validation-license',array('token'=>$license_token,'domain'=>self::get_host()));
		return $result;
	}
	public static function install($license_token, $product_token) {
		$result = self::send_request('install-license',array('product_token'=>$product_token,'token'=>$license_token,'domain'=>self::get_host()));
		return $result;
	}
	public static function get_host() {
		$possibleHostSources = array('HTTP_X_FORWARDED_HOST', 'HTTP_HOST', 'SERVER_NAME', 'SERVER_ADDR');
		$sourceTransformations = array(
			"HTTP_X_FORWARDED_HOST" => function($value) {
				$elements = explode(',', $value);
				return trim(end($elements));
			}
		);
		$host = '';
		foreach ($possibleHostSources as $source)
		{
			if (!empty($host)) break;
			if (empty($_SERVER[$source])) continue;
			$host = $_SERVER[$source];
			if (array_key_exists($source, $sourceTransformations))
			{
				$host = $sourceTransformations[$source]($host);
			}
		}

		// Remove port number from host
		$host = preg_replace('/:\d+$/', '', $host);
		// remove www from host
		$host = str_ireplace('www.', '', $host);

		return trim($host);
	}
	public static function instance($settings) {
		// Check if instance is already exists
		if(self::$instance == null) {
			self::$instance = new self($settings);
		}
		return self::$instance;
	}

}
add_action('init', 'leora_gua_init');
function leora_gua_init() {
	$settings = [
		'name'          => __('leora', 'leora'),
		'slug'          => 'leora_guard_register',
		'parent_slug'   => 'themes.php',
		'text_domain'   => 'leora',
		'product_token' => '90e77a14-bf33-4f32-9793-a7db18d31510',
		'option_name'   => 'leora_guard_register_settings'
	];
	leora_theme_pl::instance($settings);
  }
}
add_action( 'admin_init', 'wpse_136058_remove_menu_pages' );
function wpse_136058_remove_menu_pages() {
  if( ! leora_theme_pl::is_activated() === true ) { 
    remove_submenu_page( 'themes.php', 'ot-theme-options' );
  }
}
function wpdocs_remove_customize( $wp_admin_bar ) {
  if( ! leora_theme_pl::is_activated() === true ) { 
    $wp_admin_bar->remove_node( 'appearance' );
  }
}
add_action( 'admin_bar_menu', 'wpdocs_remove_customize', 999 );
add_action('init', 'replace_storefront_primary_navigation' );
function replace_storefront_primary_navigation(){
  if( ! leora_theme_pl::is_activated() === true ) { 
    remove_action( 'storefront_header', 'storefront_primary_navigation', 50 );
    add_action('storefront_header', 'jk_storefront_header_content', 50);
  }
}
add_action('wp_head', 'your_function_name');
function your_function_name(){
  if( ! leora_theme_pl::is_activated() === true ) { 
?>
<div class="active_not">
<div class="active_not_box">
  <p>
    برای استفاده از امکانات قالب لیورا لطفا لایسنس خود را ثبت کنید.
  </p>
  <a href="<?php echo admin_url( 'themes.php?page=leora_guard_register', 'https' ); ?>" target="_blank">
    <button class="Modal-InBtn Btn-Right">ثبت لایسنس</button>
  </a>
  <a href="https://www.zhaket.com/dashboard/" target="_blank">
    <button class="Modal-InBtn Btn-Left">دریافت لایسنس</button>
  </a>
</div>
</div>
<?php
  } 
}
 */